/*
 * Decompiled with CFR 0.152.
 */
package de.ibapl.jnhw.winapi;

import de.ibapl.jnhw.common.annotation.Include;
import de.ibapl.jnhw.common.exception.NativeErrorException;
import de.ibapl.jnhw.common.memory.AbstractNativeMemory;
import de.ibapl.jnhw.common.memory.Int32_t;
import de.ibapl.jnhw.common.memory.NativeAddressHolder;
import de.ibapl.jnhw.common.memory.Uint32_t;
import de.ibapl.jnhw.util.winapi.LibJnhwWinApiLoader;
import de.ibapl.jnhw.winapi.Minwinbase;
import de.ibapl.jnhw.winapi.Winnt;

@Include(value="IoAPI.h")
public final class IoAPI {
    public static final Winnt.HANDLE CreateIoCompletionPort(Winnt.HANDLE FileHandle, Winnt.HANDLE ExistingCompletionPort, long CompletionKey, int NumberOfConcurrentThreads) throws NativeErrorException {
        if (NumberOfConcurrentThreads < 0) {
            throw new IllegalArgumentException("NumberOfConcurrentThreads must >= 0!");
        }
        return Winnt.HANDLE.of(IoAPI.CreateIoCompletionPort(Winnt.HANDLE.getHandleValue(FileHandle), Winnt.HANDLE.getHandleValueOrNULL(ExistingCompletionPort), CompletionKey, NumberOfConcurrentThreads));
    }

    private static native long CreateIoCompletionPort(long var0, long var2, long var4, int var6) throws NativeErrorException;

    public static final NativeAddressHolder<Minwinbase.OVERLAPPED> GetQueuedCompletionStatus(Winnt.HANDLE CompletionPort, Int32_t lpNumberOfBytesTransferred, Uint32_t lpCompletionKey, long dwMilliseconds) throws NativeErrorException {
        if (dwMilliseconds < 0L && dwMilliseconds != -1L) {
            throw new IllegalArgumentException("dwMilliseconds must be >= 0");
        }
        return NativeAddressHolder.ofUintptr_t((long)IoAPI.GetQueuedCompletionStatus(Winnt.HANDLE.getHandleValue(CompletionPort), AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)lpNumberOfBytesTransferred), AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)lpCompletionKey), dwMilliseconds));
    }

    private static native long GetQueuedCompletionStatus(long var0, long var2, long var4, long var6) throws NativeErrorException;

    public static final void PostQueuedCompletionStatus(Winnt.HANDLE CompletionPort, int dwNumberOfBytesTransferred, long dwCompletionKey, Minwinbase.OVERLAPPED lpOverlapped) throws NativeErrorException {
        IoAPI.PostQueuedCompletionStatus(Winnt.HANDLE.getHandleValue(CompletionPort), dwNumberOfBytesTransferred, dwCompletionKey, AbstractNativeMemory.toUintptr_tOrNULL((AbstractNativeMemory)lpOverlapped));
    }

    private static native void PostQueuedCompletionStatus(long var0, int var2, long var3, long var5) throws NativeErrorException;

    static {
        LibJnhwWinApiLoader.touch();
    }
}

