/*
 * Decompiled with CFR 0.152.
 */
package de.ibapl.jnhw.winapi;

import de.ibapl.jnhw.common.annotation.Include;
import de.ibapl.jnhw.common.memory.AbstractNativeMemory;
import de.ibapl.jnhw.common.memory.OpaqueMemory32;
import de.ibapl.jnhw.common.memory.Struct32;
import de.ibapl.jnhw.common.memory.Uint32_t;
import de.ibapl.jnhw.util.winapi.LibJnhwWinApiLoader;
import de.ibapl.jnhw.util.winapi.WinApiDataType;
import de.ibapl.jnhw.winapi.Winnt;
import de.ibapl.jnhw.winapi.Winreg;

@Include(value="WinDef.h")
public abstract class WinDef {
    static {
        LibJnhwWinApiLoader.touch();
    }

    public static class RegistryHKEY
    extends HKEY
    implements AutoCloseable {
        public static RegistryHKEY of(long value) {
            return new RegistryHKEY(value);
        }

        protected RegistryHKEY(long value) {
            super(value);
        }

        @Override
        public void close() throws Exception {
            Winreg.RegCloseKey(this.value);
        }
    }

    public static class PHKEY
    extends Winnt.PHANDLE {
        public PHKEY() {
            super((long value) -> new HKEY(value));
        }

        @Override
        protected HKEY createTarget(long value) {
            return new HKEY(value);
        }

        @Override
        public HKEY dereference() {
            return (HKEY)super.dereference();
        }

        public void setFromHKEY(HKEY target) {
            this.setFromHANDLE(target);
        }
    }

    public static class LPDWORD
    extends Uint32_t {
    }

    public static class LPBYTE
    extends Struct32 {
        private static final int SIZE_OF_WCHAR = WinApiDataType.WCHAR.baseDataType.SIZE_OF;

        public static String getUnicodeString(LPBYTE lpData, boolean isNullTerminated, int bufferEnd) {
            if (isNullTerminated) {
                return MEM_ACCESS.getUnicodeString((OpaqueMemory32)lpData, 0L, 0, bufferEnd / SIZE_OF_WCHAR - 1);
            }
            return MEM_ACCESS.getUnicodeString((OpaqueMemory32)lpData, 0L, 0, bufferEnd / SIZE_OF_WCHAR);
        }

        public LPBYTE(int size, AbstractNativeMemory.SetMem setMem) {
            super((AbstractNativeMemory)((OpaqueMemory32)null), 0L, size, setMem);
        }
    }

    public static class HKEY
    extends Winnt.HANDLE {
        public HKEY(long value) {
            super(value);
        }
    }
}

