/*
 * Decompiled with CFR 0.152.
 */
package de.ibapl.jnhw.winapi;

import de.ibapl.jnhw.common.annotation.Define;
import de.ibapl.jnhw.common.annotation.Include;
import de.ibapl.jnhw.common.callback.Callback_IJ_V_Impl;
import de.ibapl.jnhw.common.datatypes.BaseDataType;
import de.ibapl.jnhw.common.memory.AbstractNativeMemory;
import de.ibapl.jnhw.common.memory.OpaqueMemory32;
import de.ibapl.jnhw.util.winapi.LibJnhwWinApiLoader;
import de.ibapl.jnhw.util.winapi.WinApiDataType;
import de.ibapl.jnhw.util.winapi.memory.WinApiStruct32;

@Include(value="winnt.h")
public final class Winnt {
    @Define
    public static final int ACCESS_SYSTEM_SECURITY = 0x1000000;
    @Define
    public static final int COMPRESSION_ENGINE_HIBER = 512;
    @Define
    public static final int COMPRESSION_ENGINE_MAXIMUM = 256;
    @Define
    public static final int COMPRESSION_ENGINE_STANDARD = 0;
    @Define
    public static final int COMPRESSION_FORMAT_DEFAULT = 1;
    @Define
    public static final int COMPRESSION_FORMAT_LZNT1 = 2;
    @Define
    public static final int COMPRESSION_FORMAT_NONE = 0;
    @Define
    public static final int COMPRESSION_FORMAT_XPRESS = 3;
    @Define
    public static final int COMPRESSION_FORMAT_XPRESS_HUFF = 4;
    @Define
    public static final int DELETE = 65536;
    @Define
    public static final int FILE_ATTRIBUTE_ARCHIVE = 32;
    @Define
    public static final int FILE_ATTRIBUTE_ENCRYPTED = 16384;
    @Define
    public static final int FILE_ATTRIBUTE_HIDDEN = 2;
    @Define
    public static final int FILE_ATTRIBUTE_NORMAL = 128;
    @Define
    public static final int FILE_ATTRIBUTE_OFFLINE = 4096;
    @Define
    public static final int FILE_ATTRIBUTE_READONLY = 1;
    @Define
    public static final int FILE_ATTRIBUTE_SYSTEM = 4;
    @Define
    public static final int FILE_ATTRIBUTE_TEMPORARY = 256;
    @Define
    public static final int FILE_SHARE_DELETE = 4;
    @Define
    public static final int FILE_SHARE_READ = 1;
    @Define
    public static final int FILE_SHARE_WRITE = 2;
    @Define
    public static final int GENERIC_ALL = 0x10000000;
    @Define
    public static final int GENERIC_EXECUTE = 0x20000000;
    @Define
    public static final int GENERIC_READ = Integer.MIN_VALUE;
    @Define
    public static final int GENERIC_WRITE = 0x40000000;
    @Define
    public static final int KEY_CREATE_LINK = 32;
    @Define
    public static final int KEY_CREATE_SUB_KEY = 4;
    @Define
    public static final int KEY_ENUMERATE_SUB_KEYS = 8;
    @Define
    public static final int KEY_NOTIFY = 16;
    @Define
    public static final int KEY_QUERY_VALUE = 1;
    @Define
    public static final int KEY_SET_VALUE = 2;
    @Define
    public static final long MAXDWORD = 0xFFFFFFFFL;
    @Define
    public static final int MAXIMUM_ALLOWED = 0x2000000;
    @Define
    public static final int MAXIMUM_WAIT_OBJECTS = 64;
    @Define
    public static final int READ_CONTROL = 131072;
    @Define
    public static final int REG_BINARY = 3;
    @Define
    public static final int REG_CREATED_NEW_KEY = 1;
    @Define
    public static final int REG_DWORD = 4;
    @Define
    public static final int REG_DWORD_BIG_ENDIAN = 5;
    @Define
    public static final int REG_DWORD_LITTLE_ENDIAN = 4;
    @Define
    public static final int REG_EXPAND_SZ = 2;
    @Define
    public static final int REG_FULL_RESOURCE_DESCRIPTOR = 9;
    @Define
    public static final int REG_LINK = 6;
    @Define
    public static final int REG_MULTI_SZ = 7;
    @Define
    public static final int REG_NONE = 0;
    @Define
    public static final int REG_OPENED_EXISTING_KEY = 2;
    @Define
    public static final int REG_OPTION_BACKUP_RESTORE = 4;
    @Define
    public static final int REG_OPTION_CREATE_LINK = 2;
    @Define
    public static final int REG_OPTION_NON_VOLATILE = 0;
    @Define
    public static final int REG_OPTION_OPEN_LINK = 8;
    @Define
    public static final int REG_OPTION_VOLATILE = 1;
    @Define
    public static final int REG_QWORD = 11;
    @Define
    public static final int REG_QWORD_LITTLE_ENDIAN = 11;
    @Define
    public static final int REG_RESOURCE_LIST = 8;
    @Define
    public static final int REG_RESOURCE_REQUIREMENTS_LIST = 10;
    @Define
    public static final int REG_SZ = 1;
    @Define
    public static final int SPECIFIC_RIGHTS_ALL = 65535;
    @Define
    public static final int STANDARD_RIGHTS_ALL = 0x1F0000;
    @Define
    public static final int STANDARD_RIGHTS_EXECUTE = 131072;
    @Define
    public static final int STANDARD_RIGHTS_READ = 131072;
    @Define
    public static final int STANDARD_RIGHTS_REQUIRED = 983040;
    @Define
    public static final int STANDARD_RIGHTS_WRITE = 131072;
    @Define
    public static final int STATUS_ABANDONED_WAIT_0 = 128;
    @Define
    public static final int STATUS_USER_APC = 192;
    @Define
    public static final int STATUS_WAIT_0 = 0;
    @Define
    public static final int SYNCHRONIZE = 0x100000;
    @Define
    public static final int WRITE_DAC = 262144;
    @Define
    public static final int WRITE_OWNER = 524288;
    @Define
    public static final int KEY_ALL_ACCESS = 983103;
    @Define
    public static final int KEY_READ = 131097;
    @Define
    public static final int KEY_EXECUTE = 131097;

    static {
        LibJnhwWinApiLoader.touch();
    }

    public static class PHANDLE
    extends OpaqueMemory32 {
        private static final int SIZE_OF = WinApiDataType.PHANDLE.baseDataType.SIZE_OF;
        HANDLE cachedHandle;

        protected PHANDLE(CreateHandler handler) {
            super((AbstractNativeMemory)((OpaqueMemory32)null), 0L, SIZE_OF, AbstractNativeMemory.SetMem.TO_0x00);
            this.cachedHandle = handler.create(this.getHandleValue());
        }

        protected PHANDLE(HANDLE handle) {
            super((AbstractNativeMemory)((OpaqueMemory32)null), 0L, SIZE_OF, AbstractNativeMemory.SetMem.DO_NOT_SET);
            this.setHandleValue(handle.value);
            this.cachedHandle = handle;
        }

        protected HANDLE createTarget(long value) {
            return new HANDLE(value);
        }

        public HANDLE dereference() {
            long currentValue = MEM_ACCESS.intptr_t((OpaqueMemory32)this, 0L);
            if (this.cachedHandle.value != currentValue) {
                this.cachedHandle = this.createTarget(currentValue);
            }
            return this.cachedHandle;
        }

        public BaseDataType getBaseDataType() {
            return WinApiDataType.PHANDLE.baseDataType;
        }

        private long getHandleValue() {
            return MEM_ACCESS.intptr_t((OpaqueMemory32)this, 0L);
        }

        public String nativeToHexString() {
            return MEM_ACCESS.intptr_t_AsHex((OpaqueMemory32)this, 0L);
        }

        public String nativeToString() {
            return String.format("{value = 0x%08x}", this.getHandleValue());
        }

        public void setFromHANDLE(HANDLE target) {
            this.setHandleValue(target.value);
        }

        private void setHandleValue(long value) {
            MEM_ACCESS.intptr_t((OpaqueMemory32)this, 0L, value);
        }

        @FunctionalInterface
        protected static interface CreateHandler {
            public HANDLE create(long var1);
        }
    }

    public static abstract class PAPCFUNC
    extends Callback_IJ_V_Impl {
        protected abstract void callback(int var1);

        protected abstract void callback(long var1);
    }

    public static class LPWSTR
    extends WinApiStruct32 {
        private static final int SIZE_OF_WCHAR = WinApiDataType.WCHAR.baseDataType.SIZE_OF;

        static int getWCHAR_Length(LPWSTR value) {
            return value.sizeInBytes / SIZE_OF_WCHAR;
        }

        public LPWSTR(int elementLength, AbstractNativeMemory.SetMem setMem) {
            super((AbstractNativeMemory)((OpaqueMemory32)null), 0L, elementLength * SIZE_OF_WCHAR, setMem);
        }

        public void clear() {
            OpaqueMemory32.clear((OpaqueMemory32)this);
        }

        public String getUnicodeString(int elementLength) {
            return MEM_ACCESS.getUnicodeString((OpaqueMemory32)this, 0L, 0, elementLength);
        }
    }

    public static class HANDLE {
        static final long INVALID_HANDLE_VALUE__VALUE = -1L;
        public static final HANDLE INVALID_HANDLE_VALUE = new HANDLE(-1L);
        static final long NULL__VALUE = 0L;
        public static final HANDLE NULL = new HANDLE(0L);
        protected final long value;

        public static long getHandleValue(HANDLE handle) {
            return handle.value;
        }

        public static long getHandleValueOrNULL(HANDLE handle) {
            return handle == null ? 0L : handle.value;
        }

        public static HANDLE of(long value) {
            if (value == 0L) {
                return NULL;
            }
            return new HANDLE(value);
        }

        protected HANDLE(long value) {
            this.value = value;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            HANDLE other = (HANDLE)obj;
            return this.value == other.value;
        }

        public int hashCode() {
            int hash = 5;
            hash = 11 * hash + (int)(this.value ^ this.value >>> 32);
            return hash;
        }

        public boolean is_INVALID_HANDLE_VALUE() {
            return this.value == -1L;
        }

        public boolean is_NULL() {
            return this.value == 0L;
        }

        public boolean isNot_INVALID_HANDLE_VALUE() {
            return this.value != -1L;
        }

        public boolean isNot_NULL() {
            return this.value != 0L;
        }

        public String toString() {
            return String.format("{value = 0x%08x}", this.value);
        }
    }

    public static class ArrayOfHandle
    extends WinApiStruct32 {
        public final int length;

        public ArrayOfHandle(int length, AbstractNativeMemory.SetMem setMem) {
            super((AbstractNativeMemory)((OpaqueMemory32)null), 0L, length * WinApiDataType.HANDLE.baseDataType.SIZE_OF, setMem);
            this.length = length;
        }

        public final HANDLE get(int i) {
            if (i < 0) {
                throw new IllegalArgumentException("i < 0");
            }
            if (i >= this.length) {
                throw new IllegalArgumentException("i >= length");
            }
            return new HANDLE(MEM_ACCESS.intptr_t_AtIndex((OpaqueMemory32)this, 0L, i));
        }

        public String nativeToString() {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            for (int i = 0; i < this.length; ++i) {
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append(this.get(i));
            }
            sb.append("]");
            return sb.toString();
        }

        public void set(int i, HANDLE element) {
            if (i < 0) {
                throw new IllegalArgumentException("i < 0");
            }
            if (i >= this.length) {
                throw new IllegalArgumentException("i >= length");
            }
            MEM_ACCESS.intptr_t_AtIndex((OpaqueMemory32)this, 0L, i, element.value);
        }
    }
}

