/*
 * Decompiled with CFR 0.152.
 */
package de.ibapl.jnhw.syscall.linux.include.uapi.linux.usb;

import de.ibapl.jnhw.common.annotation.Include;
import de.ibapl.jnhw.common.memory.AbstractNativeMemory;
import de.ibapl.jnhw.common.memory.OpaqueMemory32;
import de.ibapl.jnhw.common.memory.Struct32;
import de.ibapl.jnhw.common.memory.layout.Alignment;
import de.ibapl.jnhw.common.memory.layout.StructLayout;
import de.ibapl.jnhw.common.memory.layout.StructLayoutFactory;
import de.ibapl.jnhw.common.memory.layout.StructLayoutFactoryImpl;
import de.ibapl.jnhw.common.util.JsonStringBuilder;
import de.ibapl.jnhw.syscall.linux.annotation.SysFs;
import de.ibapl.jnhw.syscall.linux.include.linux.Hid;
import de.ibapl.jnhw.syscall.linux.include.linux.usb.Uas;
import de.ibapl.jnhw.syscall.linux.include.uapi.linux.usb.AbstractCapabilityDescriptor;
import de.ibapl.jnhw.syscall.linux.include.uapi.linux.usb.AbstractDescriptor;
import de.ibapl.jnhw.syscall.linux.include.uapi.linux.usb.UsbUnknownDescriptor;
import de.ibapl.jnhw.syscall.linux.util.memory.LinuxSyscallStruct32;
import java.io.IOException;

@Include(value="linux/usb/ch9.h")
public interface Ch9 {
    public static final short USB_DIR_OUT = 0;
    public static final short USB_DIR_IN = 128;
    public static final byte USB_TYPE_MASK = 96;
    public static final byte USB_TYPE_STANDARD = 0;
    public static final byte USB_TYPE_CLASS = 32;
    public static final byte USB_TYPE_VENDOR = 64;
    public static final byte USB_TYPE_RESERVED = 96;
    public static final byte USB_RECIP_MASK = 31;
    public static final byte USB_RECIP_DEVICE = 0;
    public static final byte USB_RECIP_INTERFACE = 1;
    public static final byte USB_RECIP_ENDPOINT = 2;
    public static final byte USB_RECIP_OTHER = 3;
    public static final byte USB_RECIP_PORT = 4;
    public static final byte USB_RECIP_RPIPE = 5;
    public static final byte USB_REQ_GET_STATUS = 0;
    public static final byte USB_REQ_CLEAR_FEATURE = 1;
    public static final byte USB_REQ_SET_FEATURE = 3;
    public static final byte USB_REQ_SET_ADDRESS = 5;
    public static final byte USB_REQ_GET_DESCRIPTOR = 6;
    public static final byte USB_REQ_SET_DESCRIPTOR = 7;
    public static final byte USB_REQ_GET_CONFIGURATION = 8;
    public static final byte USB_REQ_SET_CONFIGURATION = 9;
    public static final byte USB_REQ_GET_INTERFACE = 10;
    public static final byte USB_REQ_SET_INTERFACE = 11;
    public static final byte USB_REQ_SYNCH_FRAME = 12;
    public static final byte USB_REQ_SET_SEL = 48;
    public static final byte USB_REQ_SET_ISOCH_DELAY = 49;
    public static final byte USB_REQ_SET_ENCRYPTION = 13;
    public static final byte USB_REQ_GET_ENCRYPTION = 14;
    public static final byte USB_REQ_RPIPE_ABORT = 14;
    public static final byte USB_REQ_SET_HANDSHAKE = 15;
    public static final byte USB_REQ_RPIPE_RESET = 15;
    public static final byte USB_REQ_GET_HANDSHAKE = 16;
    public static final byte USB_REQ_SET_CONNECTION = 17;
    public static final byte USB_REQ_SET_SECURITY_DATA = 18;
    public static final byte USB_REQ_GET_SECURITY_DATA = 19;
    public static final byte USB_REQ_SET_WUSB_DATA = 20;
    public static final byte USB_REQ_LOOPBACK_DATA_WRITE = 21;
    public static final byte USB_REQ_LOOPBACK_DATA_READ = 22;
    public static final byte USB_REQ_SET_INTERFACE_DS = 23;
    public static final byte USB_REQ_GET_PARTNER_PDO = 20;
    public static final byte USB_REQ_GET_BATTERY_STATUS = 21;
    public static final byte USB_REQ_SET_PDO = 22;
    public static final byte USB_REQ_GET_VDM = 23;
    public static final byte USB_REQ_SEND_VDM = 24;
    public static final byte USB_DEVICE_SELF_POWERED = 0;
    public static final byte USB_DEVICE_REMOTE_WAKEUP = 1;
    public static final byte USB_DEVICE_TEST_MODE = 2;
    public static final byte USB_DEVICE_BATTERY = 2;
    public static final byte USB_DEVICE_B_HNP_ENABLE = 3;
    public static final byte USB_DEVICE_WUSB_DEVICE = 3;
    public static final byte USB_DEVICE_A_HNP_SUPPORT = 4;
    public static final byte USB_DEVICE_A_ALT_HNP_SUPPORT = 5;
    public static final byte USB_DEVICE_DEBUG_MODE = 6;
    public static final byte TEST_J = 1;
    public static final byte TEST_K = 2;
    public static final byte TEST_SE0_NAK = 3;
    public static final byte TEST_PACKET = 4;
    public static final byte TEST_FORCE_EN = 5;
    public static final byte USB_STATUS_TYPE_STANDARD = 0;
    public static final byte USB_STATUS_TYPE_PTM = 1;
    public static final byte USB_DEVICE_U1_ENABLE = 48;
    public static final byte USB_DEVICE_U2_ENABLE = 49;
    public static final byte USB_DEVICE_LTM_ENABLE = 50;
    public static final short USB_INTRF_FUNC_SUSPEND = 0;
    public static final short USB_INTR_FUNC_SUSPEND_OPT_MASK = -256;
    public static final byte USB_INTRF_FUNC_SUSPEND_LP = 0;
    public static final byte USB_INTRF_FUNC_SUSPEND_RW = 0;
    public static final byte USB_INTRF_STAT_FUNC_RW_CAP = 1;
    public static final byte USB_INTRF_STAT_FUNC_RW = 2;
    public static final byte USB_ENDPOINT_HALT = 0;
    public static final byte USB_DEV_STAT_U1_ENABLED = 2;
    public static final byte USB_DEV_STAT_U2_ENABLED = 3;
    public static final byte USB_DEV_STAT_LTM_ENABLED = 4;
    public static final byte USB_DEVICE_BATTERY_WAKE_MASK = 40;
    public static final byte USB_DEVICE_OS_IS_PD_AWARE = 41;
    public static final byte USB_DEVICE_POLICY_MODE = 42;
    public static final byte USB_PORT_PR_SWAP = 43;
    public static final byte USB_PORT_GOTO_MIN = 44;
    public static final byte USB_PORT_RETURN_POWER = 45;
    public static final byte USB_PORT_ACCEPT_PD_REQUEST = 46;
    public static final byte USB_PORT_REJECT_PD_REQUEST = 47;
    public static final byte USB_PORT_PORT_PD_RESET = 48;
    public static final byte USB_PORT_C_PORT_PD_CHANGE = 49;
    public static final byte USB_PORT_CABLE_PD_RESET = 50;
    public static final byte USB_DEVICE_CHARGING_POLICY = 54;
    public static final byte USB_DT_DEVICE = 1;
    public static final byte USB_DT_CONFIG = 2;
    public static final byte USB_DT_STRING = 3;
    public static final byte USB_DT_INTERFACE = 4;
    public static final byte USB_DT_ENDPOINT = 5;
    public static final byte USB_DT_DEVICE_QUALIFIER = 6;
    public static final byte USB_DT_OTHER_SPEED_CONFIG = 7;
    public static final byte USB_DT_INTERFACE_POWER = 8;
    public static final byte USB_DT_OTG = 9;
    public static final byte USB_DT_DEBUG = 10;
    public static final byte USB_DT_INTERFACE_ASSOCIATION = 11;
    public static final byte USB_DT_SECURITY = 12;
    public static final byte USB_DT_KEY = 13;
    public static final byte USB_DT_ENCRYPTION_TYPE = 14;
    public static final byte USB_DT_BOS = 15;
    public static final byte USB_DT_DEVICE_CAPABILITY = 16;
    public static final byte USB_DT_WIRELESS_ENDPOINT_COMP = 17;
    public static final byte USB_DT_WIRE_ADAPTER = 33;
    public static final byte USB_DT_RPIPE = 34;
    public static final byte USB_DT_CS_RADIO_CONTROL = 35;
    public static final byte USB_DT_PIPE_USAGE = 36;
    public static final byte USB_DT_SS_ENDPOINT_COMP = 48;
    public static final byte USB_DT_SSP_ISOC_ENDPOINT_COMP = 49;
    public static final byte USB_DT_CS_DEVICE = 33;
    public static final byte USB_DT_CS_CONFIG = 34;
    public static final byte USB_DT_CS_STRING = 35;
    public static final byte USB_DT_CS_INTERFACE = 36;
    public static final byte USB_DT_CS_ENDPOINT = 37;
    public static final byte USB_CLASS_PER_INTERFACE = 0;
    public static final byte USB_CLASS_AUDIO = 1;
    public static final byte USB_CLASS_COMM = 2;
    public static final byte USB_CLASS_HID = 3;
    public static final byte USB_CLASS_PHYSICAL = 5;
    public static final byte USB_CLASS_STILL_IMAGE = 6;
    public static final byte USB_CLASS_PRINTER = 7;
    public static final byte USB_CLASS_MASS_STORAGE = 8;
    public static final byte USB_CLASS_HUB = 9;
    public static final byte USB_CLASS_CDC_DATA = 10;
    public static final byte USB_CLASS_CSCID = 11;
    public static final byte USB_CLASS_CONTENT_SEC = 13;
    public static final byte USB_CLASS_VIDEO = 14;
    public static final byte USB_CLASS_WIRELESS_CONTROLLER = -32;
    public static final byte USB_CLASS_MISC = -17;
    public static final byte USB_CLASS_APP_SPEC = -2;
    public static final byte USB_CLASS_VENDOR_SPEC = -1;
    public static final byte USB_SUBCLASS_VENDOR_SPEC = -1;
    public static final byte USB_CONFIG_ATT_ONE = -128;
    public static final byte USB_CONFIG_ATT_SELFPOWER = 64;
    public static final byte USB_CONFIG_ATT_WAKEUP = 32;
    public static final byte USB_CONFIG_ATT_BATTERY = 16;
    public static final short USB_ENDPOINT_NUMBER_MASK = 15;
    public static final short USB_ENDPOINT_DIR_MASK = 128;
    public static final byte USB_ENDPOINT_XFERTYPE_MASK = 3;
    public static final byte USB_ENDPOINT_XFER_CONTROL = 0;
    public static final byte USB_ENDPOINT_XFER_ISOC = 1;
    public static final byte USB_ENDPOINT_XFER_BULK = 2;
    public static final byte USB_ENDPOINT_XFER_INT = 3;
    public static final byte USB_ENDPOINT_MAX_ADJUSTABLE = -128;
    public static final short USB_ENDPOINT_MAXP_MASK = 2047;
    public static final byte USB_EP_MAXP_MULT_SHIFT = 11;
    public static final short USB_EP_MAXP_MULT_MASK = 6144;
    public static final byte USB_ENDPOINT_INTRTYPE = 48;
    public static final byte USB_ENDPOINT_INTR_PERIODIC = 0;
    public static final byte USB_ENDPOINT_INTR_NOTIFICATION = 16;
    public static final byte USB_ENDPOINT_SYNCTYPE = 12;
    public static final byte USB_ENDPOINT_SYNC_NONE = 0;
    public static final byte USB_ENDPOINT_SYNC_ASYNC = 4;
    public static final byte USB_ENDPOINT_SYNC_ADAPTIVE = 8;
    public static final byte USB_ENDPOINT_SYNC_SYNC = 12;
    public static final byte USB_ENDPOINT_USAGE_MASK = 48;
    public static final byte USB_ENDPOINT_USAGE_DATA = 0;
    public static final byte USB_ENDPOINT_USAGE_FEEDBACK = 16;
    public static final byte USB_ENDPOINT_USAGE_IMPLICIT_FB = 32;
    public static final byte USB_OTG_SRP = 1;
    public static final byte USB_OTG_HNP = 2;
    public static final byte USB_OTG_ADP = 4;
    public static final short OTG_STS_SELECTOR = -4096;
    public static final byte USB_CAP_TYPE_WIRELESS_USB = 1;
    public static final byte USB_DT_USB_WIRELESS_CAP_SIZE = 11;
    public static final byte USB_CAP_TYPE_EXT = 2;
    public static final byte USB_DT_USB_EXT_CAP_SIZE = 7;
    public static final byte USB_SS_CAP_TYPE = 3;
    public static final byte USB_DT_USB_SS_CAP_SIZE = 10;
    public static final byte CONTAINER_ID_TYPE = 4;
    public static final byte USB_DT_USB_SS_CONTN_ID_SIZE = 20;
    public static final byte USB_SSP_CAP_TYPE = 10;
    public static final byte USB_PD_POWER_DELIVERY_CAPABILITY = 6;
    public static final byte USB_PD_BATTERY_INFO_CAPABILITY = 7;
    public static final byte USB_PD_PD_CONSUMER_PORT_CAPABILITY = 8;
    public static final byte USB_PD_PD_PROVIDER_PORT_CAPABILITY = 9;
    public static final byte USB_PTM_CAP_TYPE = 11;
    public static final byte USB_DT_USB_PTM_ID_SIZE = 3;
    public static final byte USB3_LPM_DISABLED = 0;
    public static final byte USB3_LPM_U1_MAX_TIMEOUT = 127;
    public static final byte USB3_LPM_U2_MAX_TIMEOUT = -2;
    public static final byte USB3_LPM_DEVICE_INITIATED = -1;
    public static final short USB3_LPM_MAX_U1_SEL_PEL = 255;
    public static final short USB3_LPM_MAX_U2_SEL_PEL = -1;
    public static final byte USB_SELF_POWER_VBUS_MAX_DRAW = 100;

    public static int USB_EP_MAXP_MULT(int m) {
        return (m & 0x1800) >> 11;
    }

    public static int usb_endpoint_num(Usb_endpoint_descriptor epd) {
        return epd.bEndpointAddress() & 0xF;
    }

    public static int usb_endpoint_type(Usb_endpoint_descriptor epd) {
        return epd.bmAttributes() & 3;
    }

    public static boolean usb_endpoint_dir_in(Usb_endpoint_descriptor epd) {
        return (epd.bEndpointAddress() & 0x80) == 128;
    }

    public static boolean usb_endpoint_dir_out(Usb_endpoint_descriptor epd) {
        return (epd.bEndpointAddress() & 0x80) == 0;
    }

    public static boolean usb_endpoint_xfer_bulk(Usb_endpoint_descriptor epd) {
        return (epd.bmAttributes() & 3) == 2;
    }

    public static boolean usb_endpoint_xfer_control(Usb_endpoint_descriptor epd) {
        return (epd.bmAttributes() & 3) == 0;
    }

    public static boolean usb_endpoint_xfer_int(Usb_endpoint_descriptor epd) {
        return (epd.bmAttributes() & 3) == 3;
    }

    public static boolean usb_endpoint_xfer_isoc(Usb_endpoint_descriptor epd) {
        return (epd.bmAttributes() & 3) == 1;
    }

    public static boolean usb_endpoint_is_bulk_in(Usb_endpoint_descriptor epd) {
        return Ch9.usb_endpoint_xfer_bulk(epd) && Ch9.usb_endpoint_dir_in(epd);
    }

    public static boolean usb_endpoint_is_bulk_out(Usb_endpoint_descriptor epd) {
        return Ch9.usb_endpoint_xfer_bulk(epd) && Ch9.usb_endpoint_dir_out(epd);
    }

    public static boolean usb_endpoint_is_int_in(Usb_endpoint_descriptor epd) {
        return Ch9.usb_endpoint_xfer_int(epd) && Ch9.usb_endpoint_dir_in(epd);
    }

    public static boolean usb_endpoint_is_int_out(Usb_endpoint_descriptor epd) {
        return Ch9.usb_endpoint_xfer_int(epd) && Ch9.usb_endpoint_dir_out(epd);
    }

    public static boolean usb_endpoint_is_isoc_in(Usb_endpoint_descriptor epd) {
        return Ch9.usb_endpoint_xfer_isoc(epd) && Ch9.usb_endpoint_dir_in(epd);
    }

    public static boolean usb_endpoint_is_isoc_out(Usb_endpoint_descriptor epd) {
        return Ch9.usb_endpoint_xfer_isoc(epd) && Ch9.usb_endpoint_dir_out(epd);
    }

    public static short usb_endpoint_maxp(Usb_endpoint_descriptor epd) {
        return (short)(epd.wMaxPacketSize() & 0x7FF);
    }

    public static short usb_endpoint_maxp_mult(Usb_endpoint_descriptor epd) {
        return (short)(Ch9.USB_EP_MAXP_MULT(epd.wMaxPacketSize()) + 1);
    }

    public static byte usb_endpoint_interrupt_type(Usb_endpoint_descriptor epd) {
        return (byte)(epd.bmAttributes() & 0x30);
    }

    public static int usb_ss_max_streams(Usb_ss_ep_comp_descriptor comp) {
        if (comp == null) {
            return 0;
        }
        int max_streams = comp.bmAttributes() & 0x1F;
        if (max_streams == 0) {
            return 0;
        }
        max_streams = 1 << max_streams;
        return max_streams;
    }

    public static long USB_SS_MULT(byte p) {
        return 1 + (p & 3);
    }

    public static long USB_SS_SSP_ISOC_COMP(byte p) {
        return p & 0x80;
    }

    public static long USB_DT_USB_SSP_CAP_SIZE(byte ssac) {
        return 12 + (ssac + 1) * 4;
    }

    public static abstract class Usb_set_sel_req
    extends Struct32 {
        public Usb_set_sel_req(AbstractNativeMemory parent, long offset, AbstractNativeMemory.SetMem setMem) {
            super(parent, offset, -1, setMem);
        }

        public abstract byte u1_sel();

        public abstract byte u1_pel();

        public abstract short u2_sel();

        public abstract short u2_pel();
    }

    public static interface Usb3_link_state {
        public static final int USB3_LPM_U0 = 0;
        public static final int USB3_LPM_U1 = 1;
        public static final int USB3_LPM_U2 = 2;
        public static final int USB3_LPM_U3 = 3;
    }

    public static interface Usb_device_state {
        public static final int USB_STATE_NOTATTACHED = 0;
        public static final int USB_STATE_ATTACHED = 1;
        public static final int USB_STATE_POWERED = 2;
        public static final int USB_STATE_RECONNECTING = 3;
        public static final int USB_STATE_UNAUTHENTICATED = 4;
        public static final int USB_STATE_DEFAULT = 5;
        public static final int USB_STATE_ADDRESS = 6;
        public static final int USB_STATE_CONFIGURED = 7;
        public static final int USB_STATE_SUSPENDED = 8;
    }

    public static interface Usb_device_speed {
        public static final int USB_SPEED_UNKNOWN = 0;
        public static final int USB_SPEED_LOW = 1;
        public static final int USB_SPEED_FULL = 2;
        public static final int USB_SPEED_HIGH = 3;
        public static final int USB_SPEED_WIRELESS = 4;
        public static final int USB_SPEED_SUPER = 5;
        public static final int USB_SPEED_SUPER_PLUS = 6;
    }

    public static abstract class Usb_connection_context
    extends Struct32 {
        public Usb_connection_context(AbstractNativeMemory parent, long offset, AbstractNativeMemory.SetMem setMem) {
            super(parent, offset, 48, setMem);
        }

        public abstract byte[] CHID();

        public abstract byte[] CDID();

        public abstract byte[] CK();

        public final class Layout {
            public static final byte CHID = 0;
            public static final byte sizeof_CHID = 16;
            public static final byte CDID = 16;
            public static final byte sizeof_CDID = 16;
            public static final byte CK = 32;
            public static final byte sizeof_CK = 16;
            public static final byte sizeof = 48;
        }
    }

    public static final class Usb_handshake
    extends LinuxSyscallStruct32 {
        public Usb_handshake(AbstractNativeMemory parent, long offset, AbstractNativeMemory.SetMem setMem) {
            super(parent, offset, 46, setMem);
        }

        public short bMessageNumber() {
            return ACCESSOR___U8.__u8_AsShort((OpaqueMemory32)this, 0L);
        }

        public byte bStatus() {
            return ACCESSOR___U8.__u8((OpaqueMemory32)this, 1L);
        }

        public byte[] tTKID() {
            return ACCESSOR___U8.__u8_Array((OpaqueMemory32)this, 2L, 3);
        }

        public byte bReserved() {
            return ACCESSOR___U8.__u8((OpaqueMemory32)this, 5L);
        }

        public byte[] CDID() {
            return ACCESSOR___U8.__u8_Array((OpaqueMemory32)this, 6L, 16);
        }

        public byte[] nonce() {
            return ACCESSOR___U8.__u8_Array((OpaqueMemory32)this, 22L, 16);
        }

        public byte[] MIC() {
            return ACCESSOR___U8.__u8_Array((OpaqueMemory32)this, 38L, 8);
        }

        public final class Layout {
            public static final byte bMessageNumber = 0;
            public static final byte bStatus = 1;
            public static final byte tTKID = 2;
            public static final byte sizeof_tTKID = 3;
            public static final byte bReserved = 5;
            public static final byte CDID = 6;
            public static final byte sizeof_CDID = 16;
            public static final byte nonce = 22;
            public static final byte sizeof_nonce = 16;
            public static final byte MIC = 38;
            public static final byte sizeof_MIC = 8;
            public static final byte sizeof = 46;
        }
    }

    public static abstract class Usb_wireless_ep_comp_descriptor
    extends AbstractDescriptor {
        protected static final Layout LAYOUT = new Layout();
        public static final byte USB_ENDPOINT_SWITCH_MASK = 3;
        public static final byte USB_ENDPOINT_SWITCH_NO = 0;
        public static final byte USB_ENDPOINT_SWITCH_SWITCH = 1;
        public static final byte USB_ENDPOINT_SWITCH_SCALE = 2;

        public Usb_wireless_ep_comp_descriptor(AbstractNativeMemory parent, long offset, AbstractNativeMemory.SetMem setMem) {
            super(parent, offset, LAYOUT.getSizeof(), setMem);
        }

        public short bMaxBurst() {
            return MEM_ACCESS.uint8_t_AsShort((OpaqueMemory32)this, (long)Usb_wireless_ep_comp_descriptor.LAYOUT.bMaxBurst);
        }

        public short bMaxSequence() {
            return MEM_ACCESS.uint8_t_AsShort((OpaqueMemory32)this, (long)Usb_wireless_ep_comp_descriptor.LAYOUT.bMaxSequence);
        }

        public int wMaxStreamDelay() {
            return MEM_ACCESS.uint16_t_AsInt((OpaqueMemory32)this, (long)Usb_wireless_ep_comp_descriptor.LAYOUT.wMaxStreamDelay);
        }

        public int wOverTheAirPacketSize() {
            return MEM_ACCESS.uint16_t_AsInt((OpaqueMemory32)this, (long)Usb_wireless_ep_comp_descriptor.LAYOUT.wOverTheAirPacketSize);
        }

        public short bOverTheAirInterval() {
            return MEM_ACCESS.uint8_t_AsShort((OpaqueMemory32)this, (long)Usb_wireless_ep_comp_descriptor.LAYOUT.bOverTheAirInterval);
        }

        public byte bmCompAttributes() {
            return MEM_ACCESS.uint8_t((OpaqueMemory32)this, (long)Usb_wireless_ep_comp_descriptor.LAYOUT.bmCompAttributes);
        }

        public static class Layout
        extends AbstractDescriptor.AbstractLayout {
            public final int bMaxBurst;
            public final int bMaxSequence;
            public final int wMaxStreamDelay;
            public final int wOverTheAirPacketSize;
            public final int bOverTheAirInterval;
            public final int bmCompAttributes;

            protected Layout() {
                this.bMaxBurst = (int)this.slf.uint8_t();
                this.bMaxSequence = (int)this.slf.uint8_t();
                this.wMaxStreamDelay = (int)this.slf.uint16_t();
                this.wOverTheAirPacketSize = (int)this.slf.uint16_t();
                this.bOverTheAirInterval = (int)this.slf.uint8_t();
                this.bmCompAttributes = (int)this.slf.uint8_t();
            }
        }
    }

    public static abstract class Usb_ptm_cap_descriptor
    extends AbstractCapabilityDescriptor {
        protected static final Layout LAYOUT = new Layout();

        public Usb_ptm_cap_descriptor(AbstractNativeMemory parent, long offset, AbstractNativeMemory.SetMem setMem) {
            super(parent, offset, LAYOUT.getSizeof(), setMem);
        }

        public static class Layout
        extends AbstractDescriptor.AbstractLayout {
            protected Layout() {
            }
        }
    }

    public static abstract class Usb_pd_cap_provider_port_descriptor
    extends AbstractCapabilityDescriptor {
        protected static final Layout LAYOUT = new Layout();
        public static final byte USB_PD_CAP_PROVIDER_BC = 1;
        public static final byte USB_PD_CAP_PROVIDER_PD = 2;
        public static final byte USB_PD_CAP_PROVIDER_TYPE_C = 4;

        public Usb_pd_cap_provider_port_descriptor(AbstractNativeMemory parent, long offset, AbstractNativeMemory.SetMem setMem) {
            super(parent, offset, LAYOUT.getSizeof(), setMem);
        }

        public byte bReserved1() {
            return MEM_ACCESS.uint8_t((OpaqueMemory32)this, (long)Usb_pd_cap_provider_port_descriptor.LAYOUT.bReserved1);
        }

        public byte bmCapabilities() {
            return MEM_ACCESS.uint8_t((OpaqueMemory32)this, (long)Usb_pd_cap_provider_port_descriptor.LAYOUT.bmCapabilities);
        }

        public short bNumOfPDObjects() {
            return MEM_ACCESS.uint8_t((OpaqueMemory32)this, (long)Usb_pd_cap_provider_port_descriptor.LAYOUT.bNumOfPDObjects);
        }

        public byte bReserved2() {
            return MEM_ACCESS.uint8_t((OpaqueMemory32)this, (long)Usb_pd_cap_provider_port_descriptor.LAYOUT.bReserved2);
        }

        public abstract int[] wPowerDataObject();

        public static class Layout
        extends AbstractDescriptor.AbstractLayout {
            public final int bReserved1;
            public final int bmCapabilities;
            public final int bNumOfPDObjects;
            public final int bReserved2;
            public final int wPowerDataObject;

            protected Layout() {
                this.bReserved1 = (int)this.slf.uint8_t();
                this.bmCapabilities = (int)this.slf.uint8_t();
                this.bNumOfPDObjects = (int)this.slf.uint8_t();
                this.bReserved2 = (int)this.slf.uint8_t();
                this.wPowerDataObject = (int)this.slf.uint32_t();
            }
        }
    }

    public static abstract class Usb_pd_cap_consumer_port_descriptor
    extends AbstractCapabilityDescriptor {
        protected static final Layout LAYOUT = new Layout();
        public static final byte USB_PD_CAP_CONSUMER_BC = 1;
        public static final byte USB_PD_CAP_CONSUMER_PD = 2;
        public static final byte USB_PD_CAP_CONSUMER_TYPE_C = 4;
        public static final int USB_PD_CAP_CONSUMER_UNKNOWN_PEAK_POWER_TIME = 65535;

        public Usb_pd_cap_consumer_port_descriptor(AbstractNativeMemory parent, long offset, AbstractNativeMemory.SetMem setMem) {
            super(parent, offset, LAYOUT.getSizeof(), setMem);
        }

        public byte bReserved() {
            return MEM_ACCESS.uint8_t((OpaqueMemory32)this, (long)Usb_pd_cap_consumer_port_descriptor.LAYOUT.bReserved);
        }

        public byte bmCapabilities() {
            return MEM_ACCESS.uint8_t((OpaqueMemory32)this, (long)Usb_pd_cap_consumer_port_descriptor.LAYOUT.bmCapabilities);
        }

        public int wMinVoltage() {
            return MEM_ACCESS.uint16_t((OpaqueMemory32)this, (long)Usb_pd_cap_consumer_port_descriptor.LAYOUT.wMinVoltage);
        }

        public int wMaxVoltage() {
            return MEM_ACCESS.uint16_t((OpaqueMemory32)this, (long)Usb_pd_cap_consumer_port_descriptor.LAYOUT.wMaxVoltage);
        }

        public short wReserved() {
            return MEM_ACCESS.int16_t((OpaqueMemory32)this, (long)Usb_pd_cap_consumer_port_descriptor.LAYOUT.wReserved);
        }

        public long dwMaxOperatingPower() {
            return MEM_ACCESS.uint32_t((OpaqueMemory32)this, (long)Usb_pd_cap_consumer_port_descriptor.LAYOUT.dwMaxOperatingPower);
        }

        public long dwMaxPeakPower() {
            return MEM_ACCESS.uint32_t((OpaqueMemory32)this, (long)Usb_pd_cap_consumer_port_descriptor.LAYOUT.dwMaxPeakPower);
        }

        public long dwMaxPeakPowerTime() {
            return MEM_ACCESS.uint32_t((OpaqueMemory32)this, (long)Usb_pd_cap_consumer_port_descriptor.LAYOUT.dwMaxPeakPowerTime);
        }

        public static class Layout
        extends AbstractDescriptor.AbstractLayout {
            public final int bReserved;
            public final int bmCapabilities;
            public final int wMinVoltage;
            public final int wMaxVoltage;
            public final int wReserved;
            public final int dwMaxOperatingPower;
            public final int dwMaxPeakPower;
            public final int dwMaxPeakPowerTime;

            protected Layout() {
                this.bReserved = (int)this.slf.uint8_t();
                this.bmCapabilities = (int)this.slf.uint16_t();
                this.wMinVoltage = (int)this.slf.uint16_t();
                this.wMaxVoltage = (int)this.slf.uint16_t();
                this.wReserved = (int)this.slf.uint16_t();
                this.dwMaxOperatingPower = (int)this.slf.uint32_t();
                this.dwMaxPeakPower = (int)this.slf.uint32_t();
                this.dwMaxPeakPowerTime = (int)this.slf.uint32_t();
            }
        }
    }

    public static abstract class Usb_pd_cap_battery_info_descriptor
    extends AbstractCapabilityDescriptor {
        protected static final Layout LAYOUT = new Layout();

        public Usb_pd_cap_battery_info_descriptor(AbstractNativeMemory parent, long offset, AbstractNativeMemory.SetMem setMem) {
            super(parent, offset, LAYOUT.getSizeof(), setMem);
        }

        public byte iBattery() {
            return MEM_ACCESS.uint8_t((OpaqueMemory32)this, (long)Usb_pd_cap_battery_info_descriptor.LAYOUT.iBattery);
        }

        public byte iSerial() {
            return MEM_ACCESS.uint8_t((OpaqueMemory32)this, (long)Usb_pd_cap_battery_info_descriptor.LAYOUT.iSerial);
        }

        public byte iManufacturer() {
            return MEM_ACCESS.uint8_t((OpaqueMemory32)this, (long)Usb_pd_cap_battery_info_descriptor.LAYOUT.iManufacturer);
        }

        public byte bBatteryId() {
            return MEM_ACCESS.uint8_t((OpaqueMemory32)this, (long)Usb_pd_cap_battery_info_descriptor.LAYOUT.bBatteryId);
        }

        public byte bReserved() {
            return MEM_ACCESS.uint8_t((OpaqueMemory32)this, (long)Usb_pd_cap_battery_info_descriptor.LAYOUT.bReserved);
        }

        public int dwChargedThreshold() {
            return MEM_ACCESS.uint32_t((OpaqueMemory32)this, (long)Usb_pd_cap_battery_info_descriptor.LAYOUT.dwChargedThreshold);
        }

        public long dwWeakThreshold() {
            return MEM_ACCESS.uint32_t((OpaqueMemory32)this, (long)Usb_pd_cap_battery_info_descriptor.LAYOUT.dwWeakThreshold);
        }

        public long dwBatteryDesignCapacity() {
            return MEM_ACCESS.uint32_t((OpaqueMemory32)this, (long)Usb_pd_cap_battery_info_descriptor.LAYOUT.dwBatteryDesignCapacity);
        }

        public long dwBatteryLastFullchargeCapacity() {
            return MEM_ACCESS.uint32_t((OpaqueMemory32)this, (long)Usb_pd_cap_battery_info_descriptor.LAYOUT.dwBatteryLastFullchargeCapacity);
        }

        public static class Layout
        extends AbstractDescriptor.AbstractLayout {
            public final int iBattery;
            public final int iSerial;
            public final int iManufacturer;
            public final int bBatteryId;
            public final int bReserved;
            public final int dwChargedThreshold;
            public final int dwWeakThreshold;
            public final int dwBatteryDesignCapacity;
            public final int dwBatteryLastFullchargeCapacity;

            protected Layout() {
                this.iBattery = (int)this.slf.uint8_t();
                this.iSerial = (int)this.slf.uint8_t();
                this.iManufacturer = (int)this.slf.uint8_t();
                this.bBatteryId = (int)this.slf.uint8_t();
                this.bReserved = (int)this.slf.uint8_t();
                this.dwChargedThreshold = (int)this.slf.uint32_t();
                this.dwWeakThreshold = (int)this.slf.uint32_t();
                this.dwBatteryDesignCapacity = (int)this.slf.uint32_t();
                this.dwBatteryLastFullchargeCapacity = (int)this.slf.uint32_t();
            }
        }
    }

    public static abstract class Usb_pd_cap_descriptor
    extends AbstractCapabilityDescriptor {
        protected static final Layout LAYOUT = new Layout();
        public static final byte USB_PD_CAP_BATTERY_CHARGING = 2;
        public static final byte USB_PD_CAP_USB_PD = 4;
        public static final byte USB_PD_CAP_PROVIDER = 8;
        public static final byte USB_PD_CAP_CONSUMER = 16;
        public static final byte USB_PD_CAP_CHARGING_POLICY = 32;
        public static final byte USB_PD_CAP_TYPE_C_CURRENT = 64;
        public static final byte USB_PD_CAP_PWR_AC = 0;
        public static final byte USB_PD_CAP_PWR_BAT = 0;
        public static final byte USB_PD_CAP_PWR_USE_V_BUS = 0;

        public Usb_pd_cap_descriptor(AbstractNativeMemory parent, long offset, AbstractNativeMemory.SetMem setMem) {
            super(parent, offset, LAYOUT.getSizeof(), setMem);
        }

        public byte bReserved() {
            return MEM_ACCESS.uint8_t((OpaqueMemory32)this, (long)Usb_pd_cap_descriptor.LAYOUT.bReserved);
        }

        public int bmAttributes() {
            return MEM_ACCESS.uint32_t((OpaqueMemory32)this, (long)Usb_pd_cap_descriptor.LAYOUT.bmAttributes);
        }

        public int bmProviderPorts() {
            return MEM_ACCESS.uint16_t_AsInt((OpaqueMemory32)this, (long)Usb_pd_cap_descriptor.LAYOUT.bmProviderPorts);
        }

        public int bmConsumerPorts() {
            return MEM_ACCESS.uint16_t_AsInt((OpaqueMemory32)this, (long)Usb_pd_cap_descriptor.LAYOUT.bmConsumerPorts);
        }

        public short bcdBCVersion() {
            return MEM_ACCESS.uint16_t((OpaqueMemory32)this, (long)Usb_pd_cap_descriptor.LAYOUT.bcdBCVersion);
        }

        public short bcdPDVersion() {
            return MEM_ACCESS.uint16_t((OpaqueMemory32)this, (long)Usb_pd_cap_descriptor.LAYOUT.bcdPDVersion);
        }

        public short bcdUSBTypeCVersion() {
            return MEM_ACCESS.uint16_t((OpaqueMemory32)this, (long)Usb_pd_cap_descriptor.LAYOUT.bcdUSBTypeCVersion);
        }

        public static class Layout
        extends AbstractDescriptor.AbstractLayout {
            public final int bReserved;
            public final int bmAttributes;
            public final int bmProviderPorts;
            public final int bmConsumerPorts;
            public final int bcdBCVersion;
            public final int bcdPDVersion;
            public final int bcdUSBTypeCVersion;

            protected Layout() {
                this.bReserved = (int)this.slf.uint8_t();
                this.bmAttributes = (int)this.slf.uint32_t();
                this.bmProviderPorts = (int)this.slf.uint16_t();
                this.bmConsumerPorts = (int)this.slf.uint16_t();
                this.bcdBCVersion = (int)this.slf.uint16_t();
                this.bcdPDVersion = (int)this.slf.uint16_t();
                this.bcdUSBTypeCVersion = (int)this.slf.uint16_t();
            }
        }
    }

    public static abstract class Usb_ssp_cap_descriptor
    extends AbstractCapabilityDescriptor {
        protected static final Layout LAYOUT = new Layout();
        public static final short USB_SSP_SUBLINK_SPEED_ATTRIBS = 31;
        public static final short USB_SSP_SUBLINK_SPEED_IDS = 480;
        public static final short USB_SSP_MIN_SUBLINK_SPEED_ATTRIBUTE_ID = 15;
        public static final short USB_SSP_MIN_RX_LANE_COUNT = 3840;
        public static final short USB_SSP_MIN_TX_LANE_COUNT = -4096;
        public static final byte USB_SSP_SUBLINK_SPEED_SSID = 15;
        public static final byte USB_SSP_SUBLINK_SPEED_LSE = 48;
        public static final short USB_SSP_SUBLINK_SPEED_ST = 192;
        public static final short USB_SSP_SUBLINK_SPEED_RSVD = 16128;
        public static final int USB_SSP_SUBLINK_SPEED_LP = 49152;
        public static final int USB_SSP_SUBLINK_SPEED_LSM = 0xFF0000;

        public Usb_ssp_cap_descriptor(AbstractNativeMemory parent, long offset, AbstractNativeMemory.SetMem setMem) {
            super(parent, offset, LAYOUT.getSizeof(), setMem);
        }

        public byte bReserved() {
            return MEM_ACCESS.uint8_t((OpaqueMemory32)this, (long)Usb_ssp_cap_descriptor.LAYOUT.bReserved);
        }

        public int bmAttributes() {
            return MEM_ACCESS.uint32_t((OpaqueMemory32)this, (long)Usb_ssp_cap_descriptor.LAYOUT.bmAttributes);
        }

        public short wFunctionalitySupport() {
            return MEM_ACCESS.uint16_t((OpaqueMemory32)this, (long)Usb_ssp_cap_descriptor.LAYOUT.wFunctionalitySupport);
        }

        public short wReserved() {
            return MEM_ACCESS.uint16_t((OpaqueMemory32)this, (long)Usb_ssp_cap_descriptor.LAYOUT.wReserved);
        }

        public abstract int[] bmSublinkSpeedAttr();

        public static class Layout
        extends AbstractDescriptor.AbstractLayout {
            public final int bReserved;
            public final int bmAttributes;
            public final int wFunctionalitySupport;
            public final int wReserved;
            public final int bmSublinkSpeedAttr;

            protected Layout() {
                this.bReserved = (int)this.slf.uint8_t();
                this.bmAttributes = (int)this.slf.uint32_t();
                this.wFunctionalitySupport = (int)this.slf.uint16_t();
                this.wReserved = (int)this.slf.uint16_t();
                this.bmSublinkSpeedAttr = (int)this.slf.uint32_t();
            }
        }
    }

    public static abstract class Usb_ss_container_id_descriptor
    extends AbstractCapabilityDescriptor {
        protected static final Layout LAYOUT = new Layout();

        public Usb_ss_container_id_descriptor(AbstractNativeMemory parent, long offset, AbstractNativeMemory.SetMem setMem) {
            super(parent, offset, LAYOUT.getSizeof(), setMem);
        }

        public byte bReserved() {
            return MEM_ACCESS.uint8_t((OpaqueMemory32)this, (long)Usb_ss_container_id_descriptor.LAYOUT.ContainerID);
        }

        public abstract byte[] ContainerID();

        public static class Layout
        extends AbstractDescriptor.AbstractLayout {
            public final int bReserved;
            public final int ContainerID;

            protected Layout() {
                this.bReserved = (int)this.slf.uint8_t();
                this.ContainerID = (int)this.slf.uint8_t();
            }
        }
    }

    public static abstract class Usb_ss_cap_descriptor
    extends AbstractCapabilityDescriptor {
        protected static final Layout LAYOUT = new Layout();
        public static final byte USB_LTM_SUPPORT = 2;
        public static final byte USB_LOW_SPEED_OPERATION = 1;
        public static final byte USB_FULL_SPEED_OPERATION = 2;
        public static final byte USB_HIGH_SPEED_OPERATION = 4;
        public static final byte USB_5GBPS_OPERATION = 8;

        public Usb_ss_cap_descriptor(AbstractNativeMemory parent, long offset, AbstractNativeMemory.SetMem setMem) {
            super(parent, offset, LAYOUT.getSizeof(), setMem);
        }

        public byte bmAttributes() {
            return MEM_ACCESS.uint8_t((OpaqueMemory32)this, (long)Usb_ss_cap_descriptor.LAYOUT.bmAttributes);
        }

        public int wSpeedSupported() {
            return MEM_ACCESS.uint16_t_AsInt((OpaqueMemory32)this, (long)Usb_ss_cap_descriptor.LAYOUT.wSpeedSupported);
        }

        public byte bFunctionalitySupport() {
            return MEM_ACCESS.uint8_t((OpaqueMemory32)this, (long)Usb_ss_cap_descriptor.LAYOUT.bFunctionalitySupport);
        }

        public byte bU1devExitLat() {
            return MEM_ACCESS.uint8_t((OpaqueMemory32)this, (long)Usb_ss_cap_descriptor.LAYOUT.bU1devExitLat);
        }

        public byte bU2DevExitLat() {
            return MEM_ACCESS.uint8_t((OpaqueMemory32)this, (long)Usb_ss_cap_descriptor.LAYOUT.bU2DevExitLat);
        }

        public static class Layout
        extends AbstractDescriptor.AbstractLayout {
            public final int bmAttributes;
            public final int wSpeedSupported;
            public final int bFunctionalitySupport;
            public final int bU1devExitLat;
            public final int bU2DevExitLat;

            protected Layout() {
                this.bmAttributes = (int)this.slf.uint8_t();
                this.wSpeedSupported = (int)this.slf.uint16_t();
                this.bFunctionalitySupport = (int)this.slf.uint8_t();
                this.bU1devExitLat = (int)this.slf.uint8_t();
                this.bU2DevExitLat = (int)this.slf.uint8_t();
            }
        }
    }

    public static abstract class Usb_ext_cap_descriptor
    extends AbstractCapabilityDescriptor {
        protected static final Layout LAYOUT = new Layout();
        public static final byte USB_LPM_SUPPORT = 2;
        public static final byte USB_BESL_SUPPORT = 4;
        public static final byte USB_BESL_BASELINE_VALID = 8;
        public static final byte USB_BESL_DEEP_VALID = 16;

        public Usb_ext_cap_descriptor(AbstractNativeMemory parent, long offset, AbstractNativeMemory.SetMem setMem) {
            super(parent, offset, LAYOUT.getSizeof(), setMem);
        }

        public int bmAttributes() {
            return MEM_ACCESS.uint32_t((OpaqueMemory32)this, (long)Usb_ext_cap_descriptor.LAYOUT.bmAttributes);
        }

        public static long USB_SET_BESL_BASELINE(byte p) {
            return (p & 0xF) << 8;
        }

        public static long USB_SET_BESL_DEEP(byte p) {
            return (p & 0xF) << 12;
        }

        public static long USB_GET_BESL_BASELINE(byte p) {
            return (p & 0xF00) >> 8;
        }

        public static long USB_GET_BESL_DEEP(byte p) {
            return (p & 0xF000) >> 12;
        }

        public static class Layout
        extends AbstractDescriptor.AbstractLayout {
            public final int bmAttributes;

            protected Layout() {
                this.bmAttributes = (int)this.slf.uint32_t();
            }
        }
    }

    public static abstract class Usb_wireless_cap_descriptor
    extends AbstractCapabilityDescriptor {
        protected static final Layout LAYOUT = new Layout();
        public static final byte USB_WIRELESS_P2P_DRD = 2;
        public static final byte USB_WIRELESS_BEACON_MASK = 12;
        public static final byte USB_WIRELESS_BEACON_SELF = 4;
        public static final byte USB_WIRELESS_BEACON_DIRECTED = 8;
        public static final byte USB_WIRELESS_BEACON_NONE = 12;
        public static final byte USB_WIRELESS_PHY_53 = 1;
        public static final byte USB_WIRELESS_PHY_80 = 2;
        public static final byte USB_WIRELESS_PHY_107 = 4;
        public static final byte USB_WIRELESS_PHY_160 = 8;
        public static final byte USB_WIRELESS_PHY_200 = 16;
        public static final byte USB_WIRELESS_PHY_320 = 32;
        public static final byte USB_WIRELESS_PHY_400 = 64;
        public static final byte USB_WIRELESS_PHY_480 = -128;

        public Usb_wireless_cap_descriptor(AbstractNativeMemory parent, long offset, AbstractNativeMemory.SetMem setMem) {
            super(parent, offset, LAYOUT.getSizeof(), setMem);
        }

        public byte bmAttributes() {
            return MEM_ACCESS.uint8_t((OpaqueMemory32)this, (long)Usb_wireless_cap_descriptor.LAYOUT.bmAttributes);
        }

        public short wPHYRates() {
            return MEM_ACCESS.uint8_t_AsShort((OpaqueMemory32)this, (long)Usb_wireless_cap_descriptor.LAYOUT.wPHYRates);
        }

        public byte bmTFITXPowerInfo() {
            return MEM_ACCESS.uint8_t((OpaqueMemory32)this, (long)Usb_wireless_cap_descriptor.LAYOUT.bmTFITXPowerInfo);
        }

        public byte bmFFITXPowerInfo() {
            return MEM_ACCESS.uint8_t((OpaqueMemory32)this, (long)Usb_wireless_cap_descriptor.LAYOUT.bmFFITXPowerInfo);
        }

        public short bmBandGroup() {
            return MEM_ACCESS.uint16_t((OpaqueMemory32)this, (long)Usb_wireless_cap_descriptor.LAYOUT.bmBandGroup);
        }

        public byte bReserved() {
            return MEM_ACCESS.uint8_t((OpaqueMemory32)this, (long)Usb_wireless_cap_descriptor.LAYOUT.bReserved);
        }

        public static class Layout
        extends AbstractDescriptor.AbstractLayout {
            public final int bmAttributes;
            public final int wPHYRates;
            public final int bmTFITXPowerInfo;
            public final int bmFFITXPowerInfo;
            public final int bmBandGroup;
            public final int bReserved;

            protected Layout() {
                this.bmAttributes = (int)this.slf.uint8_t();
                this.wPHYRates = (int)this.slf.uint16_t();
                this.bmTFITXPowerInfo = (int)this.slf.uint8_t();
                this.bmFFITXPowerInfo = (int)this.slf.uint8_t();
                this.bmBandGroup = (int)this.slf.uint16_t();
                this.bReserved = (int)this.slf.uint8_t();
            }
        }
    }

    public static abstract class Usb_dev_cap_header
    extends AbstractCapabilityDescriptor {
        protected static final Layout LAYOUT = new Layout();

        public Usb_dev_cap_header(AbstractNativeMemory parent, long offset, AbstractNativeMemory.SetMem setMem) {
            super(parent, offset, LAYOUT.getSizeof(), setMem);
        }

        public static class Layout
        extends AbstractDescriptor.AbstractLayout {
            protected Layout() {
            }
        }
    }

    public static abstract class Usb_bos_descriptor
    extends AbstractDescriptor {
        public static final byte USB_DT_BOS_SIZE = 5;
        protected static final Layout LAYOUT = new Layout();

        public Usb_bos_descriptor(AbstractNativeMemory parent, long offset, AbstractNativeMemory.SetMem setMem) {
            super(parent, offset, LAYOUT.getSizeof(), setMem);
        }

        public int wTotalLength() {
            return MEM_ACCESS.uint16_t_AsInt((OpaqueMemory32)this, (long)Usb_bos_descriptor.LAYOUT.wTotalLength);
        }

        public byte bNumDeviceCaps() {
            return MEM_ACCESS.uint8_t((OpaqueMemory32)this, (long)Usb_bos_descriptor.LAYOUT.bNumDeviceCaps);
        }

        public static class Layout
        extends AbstractDescriptor.AbstractLayout {
            public final int wTotalLength;
            public final int bNumDeviceCaps;

            protected Layout() {
                this.wTotalLength = (int)this.slf.uint16_t();
                this.bNumDeviceCaps = (int)this.slf.uint8_t();
            }
        }
    }

    public static abstract class Usb_encryption_descriptor
    extends AbstractDescriptor {
        protected static final Layout LAYOUT = new Layout();
        public static final byte USB_ENC_TYPE_UNSECURE = 0;
        public static final byte USB_ENC_TYPE_WIRED = 1;
        public static final byte USB_ENC_TYPE_CCM_1 = 2;
        public static final byte USB_ENC_TYPE_RSA_1 = 3;

        public Usb_encryption_descriptor(AbstractNativeMemory parent, long offset, AbstractNativeMemory.SetMem setMem) {
            super(parent, offset, LAYOUT.getSizeof(), setMem);
        }

        public byte bEncryptionType() {
            return MEM_ACCESS.uint8_t((OpaqueMemory32)this, (long)Usb_encryption_descriptor.LAYOUT.bEncryptionType);
        }

        public byte bEncryptionValue() {
            return MEM_ACCESS.uint8_t((OpaqueMemory32)this, (long)Usb_encryption_descriptor.LAYOUT.bEncryptionValue);
        }

        public byte bAuthKeyIndex() {
            return MEM_ACCESS.uint8_t((OpaqueMemory32)this, (long)Usb_encryption_descriptor.LAYOUT.bAuthKeyIndex);
        }

        public static class Layout
        extends AbstractDescriptor.AbstractLayout {
            public final int bEncryptionType;
            public final int bEncryptionValue;
            public final int bAuthKeyIndex;

            protected Layout() {
                this.bEncryptionType = (int)this.slf.uint8_t();
                this.bEncryptionValue = (int)this.slf.uint8_t();
                this.bAuthKeyIndex = (int)this.slf.uint8_t();
            }
        }
    }

    public static abstract class Usb_key_descriptor
    extends AbstractDescriptor {
        protected static final Layout LAYOUT = new Layout();

        public Usb_key_descriptor(AbstractNativeMemory parent, long offset, AbstractNativeMemory.SetMem setMem) {
            super(parent, offset, LAYOUT.getSizeof(), setMem);
        }

        public abstract byte[] tTKID();

        public abstract byte bReserved();

        public abstract byte[] bKeyData();

        public static class Layout
        extends AbstractDescriptor.AbstractLayout {
            public final int tTKID;
            public final int bReserved;
            public final int bKeyData;

            protected Layout() {
                this.tTKID = (int)this.slf.uint8_t();
                this.bReserved = (int)this.slf.uint8_t();
                this.bKeyData = (int)this.slf.uint8_t();
            }
        }
    }

    public static abstract class Usb_security_descriptor
    extends AbstractDescriptor {
        protected static final Layout LAYOUT = new Layout();

        public Usb_security_descriptor(AbstractNativeMemory parent, long offset, AbstractNativeMemory.SetMem setMem) {
            super(parent, offset, LAYOUT.getSizeof(), setMem);
        }

        public int wTotalLength() {
            return MEM_ACCESS.uint16_t_AsInt((OpaqueMemory32)this, (long)Usb_security_descriptor.LAYOUT.wTotalLength);
        }

        public short bNumEncryptionTypes() {
            return MEM_ACCESS.int8_t((OpaqueMemory32)this, (long)Usb_security_descriptor.LAYOUT.bNumEncryptionTypes);
        }

        public static class Layout
        extends AbstractDescriptor.AbstractLayout {
            public final int wTotalLength;
            public final int bNumEncryptionTypes;

            protected Layout() {
                this.wTotalLength = (int)this.slf.uint8_t();
                this.bNumEncryptionTypes = (int)this.slf.uint8_t();
            }
        }
    }

    public static class Usb_interface_assoc_descriptor
    extends AbstractDescriptor {
        public static final byte USB_DT_INTERFACE_ASSOCIATION_SIZE = 8;

        public Usb_interface_assoc_descriptor(AbstractNativeMemory parent, long offset, AbstractNativeMemory.SetMem setMem) {
            super(parent, offset, 8, setMem);
        }

        public byte bFirstInterface() {
            return ACCESSOR___U8.__u8((OpaqueMemory32)this, 2L);
        }

        public short bInterfaceCount() {
            return ACCESSOR___U8.__u8((OpaqueMemory32)this, 3L);
        }

        public byte bFunctionClass() {
            return ACCESSOR___U8.__u8((OpaqueMemory32)this, 4L);
        }

        public byte bFunctionSubClass() {
            return ACCESSOR___U8.__u8((OpaqueMemory32)this, 5L);
        }

        public byte bFunctionProtocol() {
            return ACCESSOR___U8.__u8((OpaqueMemory32)this, 6L);
        }

        public byte iFunction() {
            return ACCESSOR___U8.__u8((OpaqueMemory32)this, 7L);
        }

        @Override
        protected void nativeToString(JsonStringBuilder jsb, String indentPrefix, String indent) throws IOException {
            jsb.appendByteMember("bFirstInterface", this.bFirstInterface());
            jsb.appendShortMember("bInterfaceCount", this.bInterfaceCount());
            jsb.appendByteMember("bFunctionClass", this.bFunctionClass());
            jsb.appendByteMember("bFunctionSubClass", this.bFunctionSubClass());
            jsb.appendByteMember("bFunctionProtocol", this.bFunctionProtocol());
            jsb.appendByteMember("iFunction", this.iFunction());
        }

        public static class Layout
        extends AbstractDescriptor.Layout {
            public static final byte bFirstInterface = 2;
            public static final byte bInterfaceCount = 3;
            public static final byte bFunctionClass = 4;
            public static final byte bFunctionSubClass = 5;
            public static final byte bFunctionProtocol = 6;
            public static final byte iFunction = 7;
            public static final byte sizeof = 8;
        }
    }

    public static abstract class Usb_debug_descriptor
    extends AbstractDescriptor {
        protected static final Layout LAYOUT = new Layout();

        public Usb_debug_descriptor(AbstractNativeMemory parent, long offset, AbstractNativeMemory.SetMem setMem) {
            super(parent, offset, LAYOUT.getSizeof(), setMem);
        }

        public byte bDebugInEndpoint() {
            return MEM_ACCESS.uint8_t((OpaqueMemory32)this, (long)Usb_debug_descriptor.LAYOUT.bDebugInEndpoint);
        }

        public byte bDebugOutEndpoint() {
            return MEM_ACCESS.uint8_t((OpaqueMemory32)this, (long)Usb_debug_descriptor.LAYOUT.bDebugOutEndpoint);
        }

        public static class Layout
        extends AbstractDescriptor.AbstractLayout {
            public final int bDebugInEndpoint;
            public final int bDebugOutEndpoint;

            protected Layout() {
                this.bDebugInEndpoint = (int)this.slf.uint8_t();
                this.bDebugOutEndpoint = (int)this.slf.uint8_t();
            }
        }
    }

    public static abstract class Usb_otg20_descriptor
    extends AbstractDescriptor {
        protected static final Layout LAYOUT = new Layout();

        public Usb_otg20_descriptor(AbstractNativeMemory parent, long offset, AbstractNativeMemory.SetMem setMem) {
            super(parent, offset, LAYOUT.getSizeof(), setMem);
        }

        public byte bmAttributes() {
            return MEM_ACCESS.uint8_t((OpaqueMemory32)this, (long)Usb_otg20_descriptor.LAYOUT.bmAttributes);
        }

        public short bcdOTG() {
            return MEM_ACCESS.int16_t((OpaqueMemory32)this, (long)Usb_otg20_descriptor.LAYOUT.bcdOTG);
        }

        public static class Layout
        extends AbstractDescriptor.AbstractLayout {
            public final int bmAttributes;
            public final int bcdOTG;

            protected Layout() {
                this.bmAttributes = (int)this.slf.uint8_t();
                this.bcdOTG = (int)this.slf.uint8_t();
            }
        }
    }

    public static abstract class Usb_otg_descriptor
    extends AbstractDescriptor {
        protected static final Layout LAYOUT = new Layout();

        public Usb_otg_descriptor(AbstractNativeMemory parent, long offset, AbstractNativeMemory.SetMem setMem) {
            super(parent, offset, LAYOUT.getSizeof(), setMem);
        }

        public byte bmAttributes() {
            return MEM_ACCESS.uint8_t((OpaqueMemory32)this, (long)Usb_otg_descriptor.LAYOUT.bmAttributes);
        }

        public static class Layout
        extends AbstractDescriptor.AbstractLayout {
            public final int bmAttributes;

            protected Layout() {
                this.bmAttributes = (int)this.slf.uint8_t();
            }
        }
    }

    public static abstract class Usb_qualifier_descriptor
    extends AbstractDescriptor {
        protected static final Layout LAYOUT = new Layout();

        public Usb_qualifier_descriptor(AbstractNativeMemory parent, long offset, AbstractNativeMemory.SetMem setMem) {
            super(parent, offset, LAYOUT.getSizeof(), setMem);
        }

        public short bcdUSB() {
            return MEM_ACCESS.uint16_t((OpaqueMemory32)this, (long)Usb_qualifier_descriptor.LAYOUT.bcdUSB);
        }

        public byte bDeviceClass() {
            return MEM_ACCESS.uint8_t((OpaqueMemory32)this, (long)Usb_qualifier_descriptor.LAYOUT.bDeviceClass);
        }

        public byte bDeviceSubClass() {
            return MEM_ACCESS.uint8_t((OpaqueMemory32)this, (long)Usb_qualifier_descriptor.LAYOUT.bDeviceSubClass);
        }

        public byte bDeviceProtocol() {
            return MEM_ACCESS.uint8_t((OpaqueMemory32)this, (long)Usb_qualifier_descriptor.LAYOUT.bDeviceProtocol);
        }

        public short bMaxPacketSize0() {
            return MEM_ACCESS.uint8_t_AsShort((OpaqueMemory32)this, (long)Usb_qualifier_descriptor.LAYOUT.bMaxPacketSize0);
        }

        public short bNumConfigurations() {
            return MEM_ACCESS.uint8_t((OpaqueMemory32)this, (long)Usb_qualifier_descriptor.LAYOUT.bNumConfigurations);
        }

        public byte bRESERVED() {
            return MEM_ACCESS.uint8_t((OpaqueMemory32)this, (long)Usb_qualifier_descriptor.LAYOUT.bRESERVED);
        }

        public static class Layout
        extends AbstractDescriptor.AbstractLayout {
            public final int bcdUSB;
            public final int bDeviceClass;
            public final int bDeviceSubClass;
            public final int bDeviceProtocol;
            public final int bMaxPacketSize0;
            public final int bNumConfigurations;
            public final int bRESERVED;

            protected Layout() {
                this.bcdUSB = (int)this.slf.uint16_t();
                this.bDeviceClass = (int)this.slf.uint8_t();
                this.bDeviceSubClass = (int)this.slf.uint8_t();
                this.bDeviceProtocol = (int)this.slf.uint8_t();
                this.bMaxPacketSize0 = (int)this.slf.uint8_t();
                this.bNumConfigurations = (int)this.slf.uint8_t();
                this.bRESERVED = (int)this.slf.uint8_t();
            }
        }
    }

    public static final class Usb_ss_ep_comp_descriptor
    extends AbstractDescriptor {
        public static final byte USB_DT_SS_EP_COMP_SIZE = 6;

        public Usb_ss_ep_comp_descriptor(AbstractNativeMemory parent, long offset, AbstractNativeMemory.SetMem setMem) {
            super(parent, offset, 6, setMem);
        }

        public short bMaxBurst() {
            return ACCESSOR___U8.__u8_AsShort((OpaqueMemory32)this, 2L);
        }

        public byte bmAttributes() {
            return ACCESSOR___U8.__u8((OpaqueMemory32)this, 3L);
        }

        public int wBytesPerInterval() {
            return ACCESSOR___LE16.__le16_AsInt((OpaqueMemory32)this, 4L);
        }

        @Override
        protected void nativeToString(JsonStringBuilder jsb, String indentPrefix, String indent) throws IOException {
            jsb.appendShortMember("bMaxBurst", this.bMaxBurst());
            jsb.appendByteMember("bmAttributes", this.bmAttributes());
            jsb.appendIntMember("wBytesPerInterval", this.wBytesPerInterval());
        }

        public static final class Layout
        extends AbstractDescriptor.Layout {
            public static final byte bMaxBurst = 2;
            public static final byte bmAttributes = 3;
            public static final byte wBytesPerInterval = 4;
            public static final byte sizeof = 6;
        }
    }

    public static abstract class Usb_ssp_isoc_ep_comp_descriptor
    extends AbstractDescriptor {
        public Usb_ssp_isoc_ep_comp_descriptor(AbstractNativeMemory parent, long offset, int sizeInBytes, AbstractNativeMemory.SetMem setMem) {
            super(parent, offset, sizeInBytes, setMem);
        }
    }

    public static final class Usb_endpoint_descriptor
    extends AbstractDescriptor {
        public static final byte USB_DT_ENDPOINT_SIZE = 7;
        public static final byte USB_DT_ENDPOINT_AUDIO_SIZE = 9;

        public Usb_endpoint_descriptor(AbstractNativeMemory parent, long offset, int size, AbstractNativeMemory.SetMem setMem) {
            super(parent, offset, size, setMem);
            if (size != 7 && size != 9) {
                throw new IllegalArgumentException("size must be USB_DT_ENDPOINT_SIZE or  USB_DT_ENDPOINT_AUDIO_SIZE");
            }
        }

        public short bEndpointAddress() {
            return ACCESSOR___U8.__u8_AsShort((OpaqueMemory32)this, 2L);
        }

        public byte bmAttributes() {
            return ACCESSOR___U8.__u8((OpaqueMemory32)this, 3L);
        }

        public int wMaxPacketSize() {
            return ACCESSOR___LE16.__le16_AsInt((OpaqueMemory32)this, 4L);
        }

        public short bInterval() {
            return ACCESSOR___U8.__u8_AsShort((OpaqueMemory32)this, 6L);
        }

        public byte bRefresh() {
            if (this.sizeInBytes == 9) {
                return ACCESSOR___U8.__u8((OpaqueMemory32)this, 7L);
            }
            throw new IllegalStateException("Not an audio endpoint");
        }

        public byte bSynchAddress() {
            if (this.sizeInBytes == 9) {
                return ACCESSOR___U8.__u8((OpaqueMemory32)this, 8L);
            }
            throw new IllegalStateException("Not an audio endpoint");
        }

        @Override
        protected void nativeToString(JsonStringBuilder jsb, String indentPrefix, String indent) throws IOException {
            jsb.appendShortMember("bEndpointAddress", this.bEndpointAddress());
            jsb.appendByteMember("bmAttributes", this.bmAttributes());
            jsb.appendIntMember("wMaxPacketSize", this.wMaxPacketSize());
            jsb.appendShortMember("bInterval", this.bInterval());
            if (this.sizeInBytes == 9) {
                jsb.appendByteMember("bRefresh", this.bRefresh());
                jsb.appendByteMember("bSynchAddress", this.bSynchAddress());
            }
        }

        public static final class Layout
        extends AbstractDescriptor.Layout {
            public static final byte bEndpointAddress = 2;
            public static final byte bmAttributes = 3;
            public static final byte wMaxPacketSize = 4;
            public static final byte bInterval = 6;
            public static final byte bRefresh = 7;
            public static final byte bSynchAddress = 8;
            public static final byte sizeof = 9;
        }
    }

    public static final class Usb_interface_descriptor
    extends AbstractDescriptor {
        public static final byte USB_DT_INTERFACE_SIZE = 9;

        public Usb_interface_descriptor(AbstractNativeMemory parent, long offset, AbstractNativeMemory.SetMem setMem) {
            super(parent, offset, 9, setMem);
        }

        public short bInterfaceNumber() {
            return ACCESSOR___U8.__u8_AsShort((OpaqueMemory32)this, 2L);
        }

        public byte bAlternateSetting() {
            return ACCESSOR___U8.__u8((OpaqueMemory32)this, 3L);
        }

        public short bNumEndpoints() {
            return ACCESSOR___U8.__u8_AsShort((OpaqueMemory32)this, 4L);
        }

        public short bInterfaceClass() {
            return ACCESSOR___U8.__u8_AsShort((OpaqueMemory32)this, 5L);
        }

        public short bInterfaceSubClass() {
            return ACCESSOR___U8.__u8_AsShort((OpaqueMemory32)this, 5L);
        }

        public short bInterfaceProtocol() {
            return ACCESSOR___U8.__u8_AsShort((OpaqueMemory32)this, 7L);
        }

        public byte iInterface() {
            return ACCESSOR___U8.__u8((OpaqueMemory32)this, 8L);
        }

        @Override
        protected void nativeToString(JsonStringBuilder jsb, String indentPrefix, String indent) throws IOException {
            jsb.appendShortMember("bInterfaceNumber", this.bInterfaceNumber());
            jsb.appendByteMember("bAlternateSetting", this.bAlternateSetting());
            jsb.appendShortMember("bNumEndpoints", this.bNumEndpoints());
            jsb.appendShortMember("bInterfaceClass", this.bInterfaceClass());
            jsb.appendShortMember("bInterfaceSubClass", this.bInterfaceSubClass());
            jsb.appendShortMember("bInterfaceProtocol", this.bInterfaceProtocol());
            jsb.appendByteMember("iInterface", this.iInterface());
        }

        public static final class Layout
        extends AbstractDescriptor.Layout {
            public static final byte bInterfaceNumber = 2;
            public static final byte bAlternateSetting = 3;
            public static final byte bNumEndpoints = 4;
            public static final byte bInterfaceClass = 5;
            public static final byte bInterfaceSubClass = 6;
            public static final byte bInterfaceProtocol = 7;
            public static final byte iInterface = 8;
            public static final byte sizeof = 9;
        }
    }

    public static abstract class Usb_string_descriptor
    extends AbstractDescriptor {
        protected static final Layout LAYOUT = new Layout();

        public Usb_string_descriptor(AbstractNativeMemory parent, long offset, AbstractNativeMemory.SetMem setMem) {
            super(parent, offset, LAYOUT.getSizeof(), setMem);
        }

        public String wData() {
            throw new RuntimeException("IMPLEMENT ME!");
        }

        public static class Layout
        extends AbstractDescriptor.AbstractLayout {
            public final int wData;

            protected Layout() {
                this.wData = (int)this.slf.uint16_t();
            }
        }
    }

    public static final class Usb_config_descriptor
    extends AbstractDescriptor {
        public static final byte USB_DT_CONFIG_SIZE = 9;

        public Usb_config_descriptor(AbstractNativeMemory parent, long offset, AbstractNativeMemory.SetMem setMem) {
            super(parent, offset, 9, setMem);
        }

        public int wTotalLength() {
            return ACCESSOR___LE16.__le16_AsInt((OpaqueMemory32)this, 2L);
        }

        public short bNumInterfaces() {
            return ACCESSOR___U8.__u8_AsShort((OpaqueMemory32)this, 4L);
        }

        public byte bConfigurationValue() {
            return ACCESSOR___U8.__u8((OpaqueMemory32)this, 5L);
        }

        public byte iConfiguration() {
            return ACCESSOR___U8.__u8((OpaqueMemory32)this, 6L);
        }

        public byte bmAttributes() {
            return ACCESSOR___U8.__u8((OpaqueMemory32)this, 7L);
        }

        public short bMaxPower() {
            return ACCESSOR___U8.__u8((OpaqueMemory32)this, 8L);
        }

        @Override
        protected void nativeToString(JsonStringBuilder jsb, String indentPrefix, String indent) throws IOException {
            jsb.appendIntMember("wTotalLength", this.wTotalLength());
            jsb.appendShortMember("bNumInterfaces", this.bNumInterfaces());
            jsb.appendByteMember("bConfigurationValue", this.bConfigurationValue());
            jsb.appendByteMember("iConfiguration", this.iConfiguration());
            jsb.appendHexByteMember("bmAttributes", this.bmAttributes());
            jsb.appendShortMember("bMaxPower", this.bMaxPower());
        }

        public static final class Layout
        extends AbstractDescriptor.Layout {
            public static final byte wTotalLength = 2;
            public static final byte bNumInterfaces = 4;
            public static final byte bConfigurationValue = 5;
            public static final byte iConfiguration = 6;
            public static final byte bmAttributes = 7;
            public static final byte bMaxPower = 8;
            public static final byte sizeof = 9;
        }
    }

    @SysFs(value="/sys/bus/usb/devices/*/descriptors")
    public static final class Usb_device_descriptor
    extends AbstractDescriptor {
        public static final byte USB_DT_DEVICE_SIZE = 18;

        public Usb_device_descriptor(AbstractNativeMemory parent, long offset, AbstractNativeMemory.SetMem setMem) {
            super(parent, offset, 18, setMem);
        }

        public short bcdUSB() {
            return ACCESSOR___LE16.__le16((OpaqueMemory32)this, 2L);
        }

        public byte bDeviceClass() {
            return ACCESSOR___U8.__u8((OpaqueMemory32)this, 4L);
        }

        public byte bDeviceSubClass() {
            return ACCESSOR___U8.__u8((OpaqueMemory32)this, 5L);
        }

        public byte bDeviceProtocol() {
            return ACCESSOR___U8.__u8((OpaqueMemory32)this, 6L);
        }

        public byte bMaxPacketSize0() {
            return ACCESSOR___U8.__u8((OpaqueMemory32)this, 7L);
        }

        public short idVendor() {
            return ACCESSOR___LE16.__le16((OpaqueMemory32)this, 8L);
        }

        public short idProduct() {
            return ACCESSOR___LE16.__le16((OpaqueMemory32)this, 10L);
        }

        public short bcdDevice() {
            return ACCESSOR___LE16.__le16((OpaqueMemory32)this, 12L);
        }

        public byte iManufacturer() {
            return ACCESSOR___U8.__u8((OpaqueMemory32)this, 14L);
        }

        public byte iProduct() {
            return ACCESSOR___U8.__u8((OpaqueMemory32)this, 15L);
        }

        public byte iSerialNumber() {
            return ACCESSOR___U8.__u8((OpaqueMemory32)this, 16L);
        }

        public short bNumConfigurations() {
            return ACCESSOR___U8.__u8((OpaqueMemory32)this, 17L);
        }

        @Override
        public void nativeToString(JsonStringBuilder jsb, String indentPrefix, String indent) throws IOException {
            jsb.appendStringMember("bcdUSB", Usb_device_descriptor.bcd2String(this.bcdUSB()));
            jsb.appendByteMember("bDeviceClass", this.bDeviceClass());
            jsb.appendByteMember("bDeviceSubClass", this.bDeviceSubClass());
            jsb.appendByteMember("bDeviceProtocol", this.bDeviceProtocol());
            jsb.appendByteMember("bMaxPacketSize0", this.bMaxPacketSize0());
            jsb.appendHexShortMember("idVendor", this.idVendor());
            jsb.appendHexShortMember("idProduct", this.idProduct());
            jsb.appendStringMember("bcdDevice", Usb_device_descriptor.bcd2String(this.bcdDevice()));
            jsb.appendByteMember("iManufacturer", this.iManufacturer());
            jsb.appendByteMember("iProduct", this.iProduct());
            jsb.appendByteMember("iSerialNumber", this.iSerialNumber());
            jsb.appendShortMember("bNumConfigurations", this.bNumConfigurations());
        }

        public static final class Layout
        extends AbstractDescriptor.Layout {
            public static final byte bcdUSB = 2;
            public static final byte bDeviceClass = 4;
            public static final byte bDeviceSubClass = 5;
            public static final byte bDeviceProtocol = 6;
            public static final byte bMaxPacketSize0 = 7;
            public static final byte idVendor = 8;
            public static final byte idProduct = 10;
            public static final byte bcdDevice = 12;
            public static final byte iManufacturer = 14;
            public static final byte iProduct = 15;
            public static final byte iSerialNumber = 16;
            public static final byte bNumConfigurations = 17;
            public static final byte sizeof = 18;
        }
    }

    public static final class Usb_descriptor_header
    extends AbstractDescriptor {
        public Usb_descriptor_header(AbstractNativeMemory parent, long offset, AbstractNativeMemory.SetMem setMem) {
            super(parent, offset, 2, setMem);
        }

        @Override
        protected void nativeToString(JsonStringBuilder jsb, String indentPrefix, String indent) throws IOException {
        }

        public AbstractDescriptor toDescriptor() {
            AbstractDescriptor result;
            if (!(this.parent instanceof OpaqueMemory32)) {
                throw new IllegalArgumentException("memoryOwner must be OpaqueMemory32, but was: " + this.parent);
            }
            switch (this.bDescriptorType()) {
                case 1: {
                    result = new Usb_device_descriptor(this.parent, this.getOffset(), AbstractNativeMemory.SetMem.DO_NOT_SET);
                    break;
                }
                case 2: {
                    result = new Usb_config_descriptor(this.parent, this.getOffset(), AbstractNativeMemory.SetMem.DO_NOT_SET);
                    break;
                }
                case 4: {
                    result = new Usb_interface_descriptor(this.parent, this.getOffset(), AbstractNativeMemory.SetMem.DO_NOT_SET);
                    break;
                }
                case 5: {
                    result = new Usb_endpoint_descriptor(this.parent, this.getOffset(), this.bLength(), AbstractNativeMemory.SetMem.DO_NOT_SET);
                    break;
                }
                case 33: {
                    result = new Hid.Hid_descriptor(this.parent, this.getOffset(), this.bLength(), AbstractNativeMemory.SetMem.DO_NOT_SET);
                    break;
                }
                case 48: {
                    result = new Usb_ss_ep_comp_descriptor(this.parent, this.getOffset(), AbstractNativeMemory.SetMem.DO_NOT_SET);
                    break;
                }
                case 36: {
                    result = new Uas.Usb_pipe_usage_descriptor(this.parent, this.getOffset(), this.bLength(), AbstractNativeMemory.SetMem.DO_NOT_SET);
                    break;
                }
                case 11: {
                    result = new Usb_interface_assoc_descriptor(this.parent, this.getOffset(), AbstractNativeMemory.SetMem.DO_NOT_SET);
                    break;
                }
                default: {
                    result = new UsbUnknownDescriptor(this.parent, this.getOffset(), this.bLength(), AbstractNativeMemory.SetMem.DO_NOT_SET);
                }
            }
            if (result.sizeInBytes != this.bLength()) {
                throw new RuntimeException("bLength mismatch");
            }
            return result;
        }

        public static final class Layout
        extends AbstractDescriptor.Layout {
            public static final byte sizeof = 2;
        }
    }

    public static abstract class Usb_ctrlrequest
    extends Struct32 {
        protected static final Layout LAYOUT = new Layout();

        public Usb_ctrlrequest(AbstractNativeMemory parent, long offset, AbstractNativeMemory.SetMem setMem) {
            super(parent, offset, LAYOUT.getSizeof(), setMem);
        }

        public byte bRequestType() {
            return MEM_ACCESS.uint8_t((OpaqueMemory32)this, (long)Usb_ctrlrequest.LAYOUT.bRequestType);
        }

        public byte bRequest() {
            return MEM_ACCESS.uint8_t((OpaqueMemory32)this, (long)Usb_ctrlrequest.LAYOUT.bRequest);
        }

        public short wValue() {
            return MEM_ACCESS.uint16_t((OpaqueMemory32)this, (long)Usb_ctrlrequest.LAYOUT.wValue);
        }

        public int wIndex() {
            return MEM_ACCESS.uint16_t_AsInt((OpaqueMemory32)this, (long)Usb_ctrlrequest.LAYOUT.wIndex);
        }

        public int wLength() {
            return MEM_ACCESS.uint16_t_AsInt((OpaqueMemory32)this, (long)Usb_ctrlrequest.LAYOUT.wLength);
        }

        public static final class Layout
        extends StructLayout {
            protected final StructLayoutFactory slf = new StructLayoutFactoryImpl(StructLayoutFactory.Type.STRUCT, Alignment.AT_1);
            public final int bRequestType = (int)this.slf.uint8_t();
            public final int bRequest = (int)this.slf.uint8_t();
            public final int wValue = (int)this.slf.uint8_t();
            public final int wIndex = (int)this.slf.uint8_t();
            public final int wLength = (int)this.slf.uint8_t();

            protected Layout() {
            }

            public int getSizeof() {
                return (int)this.slf.getSizeof();
            }

            public Alignment getAlignment() {
                return this.slf.getAlignment();
            }
        }
    }
}

