/*
 * Decompiled with CFR 0.152.
 */
package de.ibapl.jnhw.syscall.linux.sysfs;

import de.ibapl.jnhw.common.exception.NativeErrorException;
import de.ibapl.jnhw.common.memory.AbstractNativeMemory;
import de.ibapl.jnhw.common.memory.Memory32Heap;
import de.ibapl.jnhw.common.memory.OpaqueMemory32;
import de.ibapl.jnhw.posix.Fcntl;
import de.ibapl.jnhw.posix.Unistd;
import de.ibapl.jnhw.syscall.linux.annotation.Path;
import de.ibapl.jnhw.syscall.linux.annotation.PathRegex;
import de.ibapl.jnhw.syscall.linux.include.uapi.linux.usb.AbstractDescriptor;
import de.ibapl.jnhw.syscall.linux.include.uapi.linux.usb.Ch9;
import de.ibapl.jnhw.syscall.linux.include.uapi.linux.usb.UsbUnknownDescriptor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

@Path(value="/sys/bus/usb/devices/*")
@PathRegex(value="/sys/bus/usb/devices/*/idProduct")
public class UsbDevice {
    private final File sysFsDir;

    static boolean isDeviceDir(File f) {
        File idProcuct = new File(f, "idProduct");
        return idProcuct.exists();
    }

    public byte busnum() {
        return Byte.parseByte(this.readFile(new File(this.sysFsDir, "busnum")));
    }

    public short devnum() {
        return Short.parseShort(this.readFile(new File(this.sysFsDir, "devnum")));
    }

    public short idVendor() {
        return (short)Integer.parseInt(this.readFile(new File(this.sysFsDir, "idVendor")), 16);
    }

    public final short idProduct() {
        return (short)Integer.parseInt(this.readFile(new File(this.sysFsDir, "idProduct")), 16);
    }

    public final String product() {
        try {
            return this.readFile(new File(this.sysFsDir, "product"));
        }
        catch (Exception e) {
            return null;
        }
    }

    public final String vendorName() {
        return "UNKNOWN";
    }

    private UsbDevice(File sysFsDir) {
        this.sysFsDir = sysFsDir;
    }

    public static UsbDevice toUsbDevice(File sysFsDir) {
        if (UsbDevice.isDeviceDir(sysFsDir)) {
            return new UsbDevice(sysFsDir);
        }
        throw new IllegalArgumentException(sysFsDir.getAbsolutePath() + " is not an sysfs usb bus device directory!");
    }

    public String toShortString() {
        return String.format("Bus %03d Device %03d: ID %04x:%04x %s %s", this.busnum(), this.devnum(), this.idVendor(), this.idProduct(), this.vendorName(), this.product());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String readFile(File f) {
        try (FileReader r = new FileReader(f);){
            String string;
            BufferedReader br = new BufferedReader(r);
            try {
                string = br.readLine();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        br.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
            br.close();
            return string;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public Iterable<AbstractDescriptor> descriptors() {
        return () -> new DeviceIterator();
    }

    public File getSysDir() {
        return this.sysFsDir;
    }

    private class DeviceIterator
    implements Iterator<AbstractDescriptor> {
        private final OpaqueMemory32 mem = new Memory32Heap(null, 0L, 65536, AbstractNativeMemory.SetMem.DO_NOT_SET);
        private int currentPos = 0;
        private int length;

        protected DeviceIterator() {
            try {
                int fd = Fcntl.open((String)new File(UsbDevice.this.sysFsDir, "descriptors").getAbsolutePath(), (int)Fcntl.O_RDONLY);
                try {
                    this.length = Unistd.read((int)fd, (OpaqueMemory32)this.mem);
                    if (this.length < 2) {
                        throw new RuntimeException("read not the minimum length!");
                    }
                }
                finally {
                    Unistd.close((int)fd);
                }
            }
            catch (NativeErrorException nee) {
                throw new RuntimeException(nee);
            }
        }

        @Override
        public boolean hasNext() {
            return this.currentPos < this.length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AbstractDescriptor next() {
            Ch9.Usb_descriptor_header header = new Ch9.Usb_descriptor_header((AbstractNativeMemory)this.mem, this.currentPos, AbstractNativeMemory.SetMem.DO_NOT_SET);
            try {
                AbstractDescriptor abstractDescriptor = header.toDescriptor();
                return abstractDescriptor;
            }
            catch (Exception ex) {
                Logger.getLogger("d.i.j.s.l.UsbDevice").log(Level.SEVERE, "Decode USB descriptor", ex);
                UsbUnknownDescriptor usbUnknownDescriptor = new UsbUnknownDescriptor((AbstractNativeMemory)this.mem, this.currentPos, header.bLength(), AbstractNativeMemory.SetMem.DO_NOT_SET);
                return usbUnknownDescriptor;
            }
            finally {
                this.currentPos += header.bLength();
            }
        }
    }
}

