/*
 * Decompiled with CFR 0.152.
 */
package de.ibapl.jnhw.syscall.linux.util.memory;

import de.ibapl.jnhw.common.memory.AbstractNativeMemory;
import de.ibapl.jnhw.common.memory.NativeAddressHolder;
import de.ibapl.jnhw.common.memory.OpaqueMemory32;
import de.ibapl.jnhw.common.memory.Struct32;
import de.ibapl.jnhw.libloader.MultiarchTupelBuilder;
import de.ibapl.jnhw.syscall.linux.util.memory.Accessor___le16;
import de.ibapl.jnhw.syscall.linux.util.memory.Accessor___u8;

public class LinuxSyscallStruct32
extends Struct32 {
    protected static final Accessor___u8 ACCESSOR___U8 = new Accessor___u8_As_uint8_t();
    protected static final Accessor___le16 ACCESSOR___LE16;

    public LinuxSyscallStruct32(AbstractNativeMemory owner, long offset, int sizeInBytes, AbstractNativeMemory.SetMem setMem) {
        super(owner, offset, sizeInBytes, setMem);
    }

    public LinuxSyscallStruct32(NativeAddressHolder nativeAddressHolder, int sizeInBytes) {
        super(nativeAddressHolder, sizeInBytes);
    }

    static {
        switch (new MultiarchTupelBuilder().getEndianess()) {
            case LITTLE: {
                ACCESSOR___LE16 = new LitteleEndianAccessor___le16_As_uint16_t();
                break;
            }
            case BIG: {
                ACCESSOR___LE16 = new BigEndianAccessor___le16_As_uint16_t();
                break;
            }
            default: {
                ACCESSOR___LE16 = null;
                throw new RuntimeException("Unknown Endianess : " + new MultiarchTupelBuilder().getEndianess());
            }
        }
    }

    protected static class LitteleEndianAccessor___le16_As_uint16_t
    implements Accessor___le16 {
        protected LitteleEndianAccessor___le16_As_uint16_t() {
        }

        @Override
        public short __le16(OpaqueMemory32 mem, long offset) {
            return MEM_ACCESS.uint16_t(mem, offset);
        }

        @Override
        public int __le16_AsInt(OpaqueMemory32 mem, long offset) {
            return MEM_ACCESS.uint16_t_AsInt(mem, offset);
        }

        @Override
        public void __le16(OpaqueMemory32 mem, long offset, short value) {
            MEM_ACCESS.uint16_t(mem, offset, value);
        }

        @Override
        public void __le16_FromInt(OpaqueMemory32 mem, long offset, int value) {
            MEM_ACCESS.uint16_t_FromInt(mem, offset, value);
        }

        @Override
        public short[] __le16_Array(OpaqueMemory32 mem, long offset, int lenght) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    protected static class BigEndianAccessor___le16_As_uint16_t
    implements Accessor___le16 {
        protected BigEndianAccessor___le16_As_uint16_t() {
        }

        @Override
        public short __le16(OpaqueMemory32 mem, long offset) {
            return Short.reverseBytes(MEM_ACCESS.uint16_t(mem, offset));
        }

        @Override
        public int __le16_AsInt(OpaqueMemory32 mem, long offset) {
            return this.__le16(mem, offset) & 0xFFFF;
        }

        @Override
        public void __le16(OpaqueMemory32 mem, long offset, short value) {
            MEM_ACCESS.uint16_t(mem, offset, Short.reverseBytes(value));
        }

        @Override
        public void __le16_FromInt(OpaqueMemory32 mem, long offset, int value) {
            if (value < 0) {
                throw new IllegalArgumentException("value must not be negative: " + value);
            }
            if (value > 65535) {
                throw new IllegalArgumentException("value must not be bigger than  65535 (0xffff): " + value);
            }
            this.__le16(mem, offset, (short)value);
        }

        @Override
        public short[] __le16_Array(OpaqueMemory32 mem, long offset, int lenght) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    protected static class Accessor___u8_As_uint8_t
    implements Accessor___u8 {
        protected Accessor___u8_As_uint8_t() {
        }

        @Override
        public byte __u8(OpaqueMemory32 mem, long offset) {
            return MEM_ACCESS.uint8_t(mem, offset);
        }

        @Override
        public short __u8_AsShort(OpaqueMemory32 mem, long offset) {
            return MEM_ACCESS.uint8_t_AsShort(mem, offset);
        }

        @Override
        public void __u8(OpaqueMemory32 mem, long offset, byte value) {
            MEM_ACCESS.uint8_t(mem, offset, value);
        }

        @Override
        public void __u8_FromShort(OpaqueMemory32 mem, long offset, short value) {
            MEM_ACCESS.uint8_t_FromShort(mem, offset, value);
        }

        @Override
        public byte[] __u8_Array(OpaqueMemory32 mem, long offset, int lenght) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

