/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.connectors.aas;

import de.iip_ecosphere.platform.connectors.AbstractConnector;
import de.iip_ecosphere.platform.connectors.AdapterSelector;
import de.iip_ecosphere.platform.connectors.ConnectorDescriptor;
import de.iip_ecosphere.platform.connectors.ConnectorParameter;
import de.iip_ecosphere.platform.connectors.MachineConnector;
import de.iip_ecosphere.platform.connectors.model.AbstractModelAccess;
import de.iip_ecosphere.platform.connectors.model.ModelAccess;
import de.iip_ecosphere.platform.connectors.types.ProtocolAdapter;
import de.iip_ecosphere.platform.support.Endpoint;
import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasFactory;
import de.iip_ecosphere.platform.support.aas.Operation;
import de.iip_ecosphere.platform.support.aas.Property;
import de.iip_ecosphere.platform.support.aas.Submodel;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MachineConnector(hasModel=true, supportsModelStructs=false, supportsEvents=false)
public class AasConnector<CO, CI>
extends AbstractConnector<Object, Object, CO, CI> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AasConnector.class);
    private static final Object DUMMY = new Object();
    private Aas connectedAAS;
    private AasFactory factory;

    @SafeVarargs
    public AasConnector(ProtocolAdapter<Object, Object, CO, CI> ... adapter) {
        this((AasFactory)null, (AdapterSelector<Object, Object, CO, CI>)null, adapter);
    }

    @SafeVarargs
    public AasConnector(AasFactory factory, ProtocolAdapter<Object, Object, CO, CI> ... adapter) {
        this(factory, (AdapterSelector<Object, Object, CO, CI>)null, adapter);
    }

    @SafeVarargs
    public AasConnector(AasFactory factory, AdapterSelector<Object, Object, CO, CI> selector, ProtocolAdapter<Object, Object, CO, CI> ... adapter) {
        super(selector, adapter);
        this.factory = null == factory ? AasFactory.getInstance() : factory;
        this.configureModelAccess((ModelAccess)new AasModelAccess());
    }

    protected void connectImpl(ConnectorParameter params) throws IOException {
        if (null == this.connectedAAS) {
            Endpoint regEp = new Endpoint(Schema.HTTP, params.getHost(), params.getPort(), params.getEndpointPath());
            this.connectedAAS = this.factory.obtainRegistry(regEp).retrieveAas(params.getApplicationId());
            if (null == this.connectedAAS) {
                throw new IOException("No AAS retrieved!");
            }
        }
    }

    protected void disconnectImpl() throws IOException {
        this.connectedAAS = null;
    }

    public void dispose() {
    }

    public String getName() {
        return "AAS via factory " + this.factory.getName();
    }

    protected void writeImpl(Object data) throws IOException {
    }

    protected Object read() throws IOException {
        return DUMMY;
    }

    protected void error(String message, Throwable th) {
        LOGGER.error(message, th);
    }

    private class AasModelAccess
    extends AbstractModelAccess {
        private static final char SEPARATOR_CHAR = '/';
        private static final String SEPARATOR_STRING = "/";

        protected AasModelAccess() {
            super((AbstractModelAccess.NotificationChangedListener)AasConnector.this);
        }

        public String getQSeparator() {
            return SEPARATOR_STRING;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Property findProperty(String qName) throws IOException {
            Property result = null;
            int pos = qName.indexOf(47);
            if (pos <= 1) throw new IOException("No qualification/submodel given in " + qName);
            String subModelName = qName.substring(0, pos);
            String elementName = qName.substring(pos + 1);
            Submodel subModel = AasConnector.this.connectedAAS.getSubmodel(subModelName);
            if (null == subModel) throw new IOException("Submodel " + subModelName + "in " + qName + " does not exist");
            Property prop = subModel.getProperty(elementName);
            if (null != prop) return prop;
            throw new IOException("Property " + elementName + " in " + qName + " does not exist");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Object call(String qName, Object ... args) throws IOException {
            Object result = null;
            int pos = qName.indexOf(47);
            if (pos <= 1) throw new IOException("No qualification/submodel given in " + qName);
            String subModelName = qName.substring(0, pos);
            String operationName = qName.substring(pos + 1);
            Submodel subModel = AasConnector.this.connectedAAS.getSubmodel(subModelName);
            if (null == subModel) throw new IOException("Submodel " + subModelName + "in " + qName + " does not exist");
            Operation operation = subModel.getOperation(operationName);
            if (null == operation) throw new IOException("Operation " + operationName + " in " + qName + " does not exist");
            try {
                return operation.invoke(args);
            }
            catch (Exception e) {
                throw new IOException("While calling " + operationName + ": " + e.getMessage(), e);
            }
        }

        public Object get(String qName) throws IOException {
            try {
                return this.findProperty(qName).getValue();
            }
            catch (Exception e) {
                throw new IOException("Accessing " + qName + ": " + e.getMessage(), e);
            }
        }

        public void set(String qName, Object value) throws IOException {
            try {
                this.findProperty(qName).setValue(value);
            }
            catch (Exception e) {
                throw new IOException("Accessing " + qName + ": " + e.getMessage(), e);
            }
        }

        public <T> T getStruct(String qName, Class<T> type) throws IOException {
            throw new IOException("Structs are not implemented in AAS");
        }

        public void setStruct(String qName, Object value) throws IOException {
            throw new IOException("Structs are not implemented in AAS");
        }

        public void registerCustomType(Class<?> cls) throws IOException {
            throw new IOException("Structs are not implemented in AAS");
        }

        public void monitor(String ... qName) throws IOException {
            throw new IOException("Event-based monitoring is not supported. Please use polling.");
        }
    }

    public static class Descriptor
    implements ConnectorDescriptor {
        public String getName() {
            return "Generic AAS connector";
        }

        public Class<?> getType() {
            return AasConnector.class;
        }
    }
}

