/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.connectors.aas;

import de.iip_ecosphere.platform.connectors.AbstractConnector;
import de.iip_ecosphere.platform.connectors.AdapterSelector;
import de.iip_ecosphere.platform.connectors.ConnectorDescriptor;
import de.iip_ecosphere.platform.connectors.ConnectorParameter;
import de.iip_ecosphere.platform.connectors.MachineConnector;
import de.iip_ecosphere.platform.connectors.model.AbstractModelAccess;
import de.iip_ecosphere.platform.connectors.model.ModelAccess;
import de.iip_ecosphere.platform.connectors.types.ProtocolAdapter;
import de.iip_ecosphere.platform.support.Endpoint;
import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasFactory;
import de.iip_ecosphere.platform.support.aas.ElementsAccess;
import de.iip_ecosphere.platform.support.aas.Operation;
import de.iip_ecosphere.platform.support.aas.Property;
import de.iip_ecosphere.platform.support.aas.Registry;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.aas.SubmodelElementCollection;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MachineConnector(hasModel=true, supportsModelStructs=false, supportsEvents=false)
public class AasConnector<CO, CI>
extends AbstractConnector<Object, Object, CO, CI> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AasConnector.class);
    private static final Object DUMMY = new Object();
    private Map<String, Aas> connectedAAS = new HashMap<String, Aas>();
    private AasFactory factory;
    private ConnectorParameter params;
    private Pattern pattern;
    private Registry registry;
    private AtomicBoolean inPolling = new AtomicBoolean(false);
    private transient String pollingAas = "";
    private transient Thread pollingThread;
    private String nonPollingAas = "";

    @SafeVarargs
    public AasConnector(ProtocolAdapter<Object, Object, CO, CI> ... adapter) {
        this((AasFactory)null, (AdapterSelector<Object, Object, CO, CI>)null, adapter);
    }

    @SafeVarargs
    public AasConnector(AasFactory factory, ProtocolAdapter<Object, Object, CO, CI> ... adapter) {
        this(factory, (AdapterSelector<Object, Object, CO, CI>)null, adapter);
    }

    @SafeVarargs
    public AasConnector(AasFactory factory, AdapterSelector<Object, Object, CO, CI> selector, ProtocolAdapter<Object, Object, CO, CI> ... adapter) {
        super(selector, adapter);
        this.factory = null == factory ? AasFactory.getInstance() : factory;
        this.configureModelAccess((ModelAccess)new AasModelAccess());
    }

    protected void connectImpl(ConnectorParameter params) throws IOException {
        if (this.connectedAAS.isEmpty()) {
            this.params = params;
            Schema schema = params.getSchema();
            String epPath = params.getEndpointPath();
            int pos = epPath.indexOf(58);
            if (pos > 0 && pos < epPath.length()) {
                String tmp = epPath.substring(0, pos);
                epPath = epPath.substring(pos + 1);
                try {
                    schema = Schema.valueOf((String)tmp);
                }
                catch (IllegalArgumentException e) {
                    LOGGER.warn("Implicit schema in endpoint path '" + tmp + "' unknown. Ignored. Using " + schema);
                }
            }
            Endpoint regEp = null;
            try {
                Schema regSchema;
                URL url = new URL(params.getEndpointPath());
                try {
                    regSchema = Schema.valueOf((String)url.getProtocol());
                }
                catch (IllegalArgumentException e1) {
                    regSchema = Schema.HTTP;
                }
                if (url.getHost().length() > 0 && url.getPort() > 0) {
                    regEp = new Endpoint(regSchema, url.getHost(), url.getPort(), url.getPath());
                }
            }
            catch (MalformedURLException regSchema) {
                // empty catch block
            }
            if (null == regEp) {
                regEp = new Endpoint(Schema.HTTP, params.getHost(), params.getPort(), epPath);
            }
            this.registry = this.factory.obtainRegistry(regEp, schema);
            String name = params.getApplicationId();
            if (name.indexOf(63) > 0 || name.indexOf(42) > 0) {
                try {
                    this.pattern = Pattern.compile(name);
                }
                catch (PatternSyntaxException e) {
                    LOGGER.error("ApplicationName/AAS pattern not valid: {}", (Object)e.getMessage());
                }
                this.updateAas();
            } else {
                Aas aas = this.registry.retrieveAas(name);
                if (null != aas) {
                    this.nonPollingAas = aas.getIdShort();
                    this.connectedAAS.put(this.nonPollingAas, aas);
                }
            }
        }
    }

    private boolean updateAas() {
        boolean foundNew = false;
        if (null != this.pattern && null != this.registry) {
            String name = this.params.getApplicationId();
            List ids = name.startsWith("iri:") ? this.registry.getAasIdentifiers() : this.registry.getAasIdShorts();
            for (String id : ids) {
                if (this.connectedAAS.containsKey(id) || !this.pattern.matcher(id).matches()) continue;
                try {
                    Aas aas = this.registry.retrieveAas(id);
                    if (null == aas) continue;
                    this.connectedAAS.put(aas.getIdShort(), aas);
                    if (this.nonPollingAas.length() == 0) {
                        this.nonPollingAas = aas.getIdShort();
                    }
                    foundNew = true;
                }
                catch (IOException e) {
                    LOGGER.warn("Cannot retrieve AAS '{}': {}. Ignoring.", (Object)id, (Object)e.getMessage());
                }
            }
        }
        return foundNew;
    }

    protected void doPolling() {
        if (!this.inPolling.getAndSet(true)) {
            this.pollingThread = Thread.currentThread();
            this.updateAas();
            Iterator<String> iterator = this.connectedAAS.keySet().iterator();
            while (iterator.hasNext()) {
                String key;
                this.pollingAas = key = iterator.next();
                try {
                    Object data = this.read();
                    if (null == data) continue;
                    this.received(data);
                }
                catch (IOException e) {
                    this.error("While polling. Data discarded.", e);
                }
            }
            this.pollingAas = "";
            this.pollingThread = null;
            this.inPolling.set(false);
        }
    }

    protected void disconnectImpl() throws IOException {
        this.connectedAAS.clear();
        this.nonPollingAas = "";
        this.registry = null;
    }

    public void dispose() {
    }

    public String getName() {
        return "AAS via factory " + this.factory.getName();
    }

    protected void writeImpl(Object data) throws IOException {
    }

    protected Object read() throws IOException {
        return DUMMY;
    }

    protected void error(String message, Throwable th) {
        LOGGER.error(message + ": " + th.getMessage());
    }

    public String supportedEncryption() {
        return null;
    }

    public String enabledEncryption() {
        return null;
    }

    private class AasModelAccess
    extends AbstractModelAccess {
        private static final char SEPARATOR_CHAR = '/';
        private static final String SEPARATOR_STRING = "/";
        private ElementsAccess base;
        private AasModelAccess parent;
        private Map<String, Map<String, ElementsAccess>> elements;

        protected AasModelAccess() {
            super((AbstractModelAccess.NotificationChangedListener)AasConnector.this);
            this.elements = new HashMap<String, Map<String, ElementsAccess>>();
        }

        protected AasModelAccess(ElementsAccess base, AasModelAccess parent) {
            this();
            this.base = base;
            this.parent = parent;
        }

        public String topInstancesQName() {
            return "";
        }

        public String getQSeparator() {
            return SEPARATOR_STRING;
        }

        private Property findProperty(String qName) throws IOException {
            ElementsAccess element;
            Property result = null;
            int pos = qName.lastIndexOf(47);
            String propName = qName;
            if (pos > 1) {
                element = this.retrieveElement(qName.substring(0, pos));
                propName = qName.substring(pos + 1);
            } else {
                element = this.base;
            }
            if (element != null) {
                result = element.getProperty(propName);
            }
            if (null == result) {
                throw new IOException("Cannot find property " + qName);
            }
            return result;
        }

        private ElementsAccess retrieveElement(String qName) throws IOException {
            ElementsAccess result;
            String aasId = AasConnector.this.pollingThread == Thread.currentThread() ? AasConnector.this.pollingAas : AasConnector.this.nonPollingAas;
            Map<String, ElementsAccess> cache = this.elements.get(aasId);
            ElementsAccess elementsAccess = result = null == cache ? null : cache.get(qName);
            if (null == result) {
                result = this.base;
                String path = qName;
                if (null == result) {
                    int pos = qName.indexOf(47);
                    Aas aas = (Aas)AasConnector.this.connectedAAS.get(aasId);
                    if (null != aas) {
                        if (pos > 0) {
                            result = aas.getSubmodel(qName.substring(0, pos));
                            path = qName.substring(pos + 1);
                        } else {
                            result = aas.getSubmodel(qName);
                            path = null;
                        }
                    }
                }
                if (path != null && result != null) {
                    result = this.retrieveElement(result, path);
                }
                if (null == result) {
                    throw new IOException("No element found for " + qName);
                }
                if (null == cache) {
                    cache = new HashMap<String, ElementsAccess>();
                    this.elements.put(aasId, cache);
                }
                cache.put(qName, result);
            }
            return result;
        }

        private ElementsAccess retrieveElement(ElementsAccess current, String qName) {
            SubmodelElementCollection tmp;
            String nodeName;
            Object result = null;
            int pos = qName.indexOf(47);
            String remainder = null;
            if (pos > 0) {
                nodeName = qName.substring(0, pos);
                if (pos + 1 < qName.length()) {
                    remainder = qName.substring(pos + 1);
                }
            } else {
                nodeName = qName;
            }
            if (null != (tmp = current.getSubmodelElementCollection(nodeName))) {
                result = null == remainder ? tmp : this.retrieveElement((ElementsAccess)tmp, remainder);
            }
            return result;
        }

        public Object call(String qName, Object ... args) throws IOException {
            ElementsAccess element;
            Object result = null;
            Operation operation = null;
            int pos = qName.lastIndexOf(47);
            String opName = qName;
            if (pos > 1) {
                element = this.retrieveElement(qName.substring(0, pos));
                opName = qName.substring(pos + 1);
            } else {
                element = this.base;
            }
            if (element != null) {
                operation = element.getOperation(opName);
            }
            if (operation != null) {
                try {
                    result = operation.invoke(args);
                }
                catch (Exception e) {
                    throw new IOException("While calling " + qName + ": " + e.getMessage());
                }
            } else {
                throw new IOException("Cannot find operation " + qName);
            }
            return result;
        }

        public Object get(String qName) throws IOException {
            try {
                return this.findProperty(qName).getValue();
            }
            catch (Exception e) {
                throw new IOException("Accessing " + qName + ": " + e.getMessage());
            }
        }

        public void set(String qName, Object value) throws IOException {
            try {
                this.findProperty(qName).setValue(value);
            }
            catch (Exception e) {
                throw new IOException("Accessing " + qName + ": " + e.getMessage());
            }
        }

        public <T> T getStruct(String qName, Class<T> type) throws IOException {
            throw new IOException("Structs are not implemented in AAS");
        }

        public void setStruct(String qName, Object value) throws IOException {
            throw new IOException("Structs are not implemented in AAS");
        }

        public void registerCustomType(Class<?> cls) throws IOException {
            throw new IOException("Structs are not implemented in AAS");
        }

        public void monitor(int notificationInterval, String ... qName) throws IOException {
            throw new IOException("Event-based monitoring is not supported. Please use polling.");
        }

        public void monitorModelChanges(int notificationInterval) throws IOException {
            throw new IOException("Event-based monitoring is not supported. Please use polling.");
        }

        protected ConnectorParameter getConnectorParameter() {
            return AasConnector.this.params;
        }

        public AasModelAccess stepInto(String name) throws IOException {
            AasModelAccess result = null;
            if (null == this.base) {
                Aas aas = (Aas)AasConnector.this.connectedAAS.get(AasConnector.this.pollingThread == Thread.currentThread() ? AasConnector.this.pollingAas : AasConnector.this.nonPollingAas);
                if (null == aas) {
                    throw new IOException("AAS " + AasConnector.this.pollingAas + " not found. Cannot resolve further.");
                }
                Submodel submodel = aas.getSubmodel(name);
                if (null == submodel) {
                    throw new IOException("Submodel " + name + " not found. Cannot resolve further.");
                }
                result = new AasModelAccess((ElementsAccess)submodel, this);
            } else {
                SubmodelElementCollection coll = this.base.getSubmodelElementCollection(name);
                if (null == coll) {
                    throw new IOException("Collection " + name + " not found. Cannot resolve further.");
                }
                result = new AasModelAccess((ElementsAccess)coll, this);
            }
            return result;
        }

        public AasModelAccess stepOut() {
            return this.parent;
        }
    }

    public static class Descriptor
    implements ConnectorDescriptor {
        public String getName() {
            return "Generic AAS connector";
        }

        public Class<?> getType() {
            return AasConnector.class;
        }
    }
}

