/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.connectors.aas;

import de.iip_ecosphere.platform.connectors.Connector;
import de.iip_ecosphere.platform.connectors.ConnectorDescriptor;
import de.iip_ecosphere.platform.connectors.ConnectorParameter;
import de.iip_ecosphere.platform.connectors.ConnectorRegistry;
import de.iip_ecosphere.platform.connectors.aas.AasConnector;
import de.iip_ecosphere.platform.connectors.model.ModelAccess;
import de.iip_ecosphere.platform.connectors.types.ProtocolAdapter;
import de.iip_ecosphere.platform.support.Endpoint;
import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.Server;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasFactory;
import de.iip_ecosphere.platform.support.aas.DeploymentRecipe;
import de.iip_ecosphere.platform.support.aas.Registry;
import de.iip_ecosphere.platform.support.aas.ServerRecipe;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.aas.SubmodelElementContainerBuilder;
import de.iip_ecosphere.platform.support.iip_aas.AasContributor;
import de.iip_ecosphere.platform.support.iip_aas.AasPartRegistry;
import de.iip_ecosphere.platform.support.iip_aas.ActiveAasBase;
import de.iip_ecosphere.platform.support.net.KeyStoreDescriptor;
import java.io.IOException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.List;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import test.de.iip_ecosphere.platform.connectors.AbstractInformationModelConnectorTest;
import test.de.iip_ecosphere.platform.connectors.MachineCommand;
import test.de.iip_ecosphere.platform.connectors.MachineData;
import test.de.iip_ecosphere.platform.support.aas.AasTest;
import test.de.iip_ecosphere.platform.support.aas.TestMachine;

public class AasConnectorTest
extends AbstractInformationModelConnectorTest<Object> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AasConnectorTest.class);
    private static final String AAS_URN = "urn:::AAS:::testMachines#";
    private static ServerAddress aasServer = new ServerAddress(Schema.HTTP);
    private static final ServerAddress VAB_SERVER = new ServerAddress(Schema.HTTP);
    private static final Endpoint REGISTRY = new Endpoint(aasServer, "registry");
    private static KeyStoreDescriptor keyDesc;
    private static Server platformAasServer;
    private static Server httpServer;
    private static Server ccServer;
    private static Server repository;
    private static ActiveAasBase.NotificationMode oldNotificationMode;
    private static AasPartRegistry.AasSetup oldSetup;

    public AasConnectorTest() {
        super(Object.class);
    }

    protected static void setKeystoreDescriptor(KeyStoreDescriptor desc) {
        keyDesc = desc;
    }

    @BeforeClass
    public static void init() throws SocketException, UnknownHostException {
        oldNotificationMode = ActiveAasBase.setNotificationMode((ActiveAasBase.NotificationMode)ActiveAasBase.NotificationMode.SYNCHRONOUS);
        ConnectorRegistry.getRegisteredConnectorDescriptorsLoader().reload();
        oldSetup = AasPartRegistry.setAasSetup((AasPartRegistry.AasSetup)AasPartRegistry.AasSetup.createLocalEphemeralSetup());
        AasPartRegistry.AasBuildResult bResult = AasPartRegistry.build(d -> d.getKind() != AasContributor.Kind.ACTIVE);
        Server implServer = (Server)bResult.getProtocolServerBuilder().build();
        platformAasServer = AasPartRegistry.deploy((List)bResult.getAas(), (String[])new String[0]).start();
        LOGGER.info("Platform AAS server started");
        TestMachine machine = new TestMachine();
        ccServer = AasTest.createOperationsServer((int)VAB_SERVER.getPort(), (TestMachine)machine, (String)"", null).start();
        Aas aas = AasConnectorTest.createAAS(machine);
        if (null != keyDesc) {
            aasServer = new ServerAddress(Schema.HTTPS);
            ServerRecipe sRecipe = AasFactory.getInstance().createServerRecipe();
            repository = sRecipe.createRegistryServer(REGISTRY, (ServerRecipe.PersistenceType)ServerRecipe.LocalPersistenceType.INMEMORY, new String[0]).start();
            try {
                Endpoint sEndpoint = new Endpoint(aasServer, "");
                DeploymentRecipe.RegistryDeploymentRecipe drcp = AasFactory.getInstance().createDeploymentRecipe(sEndpoint, keyDesc).setRegistryUrl(REGISTRY);
                Registry reg = drcp.obtainRegistry();
                httpServer = drcp.createServer(new String[0]).start();
                reg.createAas(aas, sEndpoint.toUri());
                for (Submodel sm : aas.submodels()) {
                    reg.createSubmodel(aas, sm);
                }
            }
            catch (IOException e) {
                Assert.fail((String)("Exception: " + e.getMessage()));
            }
        } else {
            DeploymentRecipe dBuilder = AasFactory.getInstance().createDeploymentRecipe(new Endpoint(aasServer, ""));
            httpServer = dBuilder.addInMemoryRegistry(REGISTRY.getEndpoint()).deploy(aas).createServer(new String[0]);
            httpServer.start();
        }
        implServer.start();
        LOGGER.info("AAS server started");
    }

    @AfterClass
    public static void shutdown() {
        if (null != repository) {
            repository.stop(true);
        }
        httpServer.stop(true);
        ccServer.stop(true);
        LOGGER.info("Platform/AAS server stopped");
        platformAasServer.stop(true);
        AasPartRegistry.setAasSetup((AasPartRegistry.AasSetup)oldSetup);
        ActiveAasBase.setNotificationMode((ActiveAasBase.NotificationMode)oldNotificationMode);
    }

    public static Aas createAAS(TestMachine machine) throws SocketException, UnknownHostException {
        AasFactory factory = AasFactory.getInstance();
        Aas.AasBuilder aasBuilder = factory.createAasBuilder("aasTest", AAS_URN);
        Submodel.SubmodelBuilder subModelBuilder = aasBuilder.createSubmodelBuilder("machine", null);
        AasTest test = new AasTest();
        test.createAasOperationsElements((SubmodelElementContainerBuilder)subModelBuilder, VAB_SERVER, "");
        subModelBuilder.build();
        return (Aas)aasBuilder.build();
    }

    @Test
    public void testWithPolling() throws IOException {
        this.testConnector(false);
    }

    protected Class<? extends ConnectorDescriptor> getConnectorDescriptor() {
        return AasConnector.Descriptor.class;
    }

    protected Connector<Object, Object, MachineData, MachineCommand> createConnector(ProtocolAdapter<Object, Object, MachineData, MachineCommand> adapter) {
        return new AasConnector(new ProtocolAdapter[]{adapter});
    }

    protected ConnectorParameter getConnectorParameter() {
        return ConnectorParameter.ConnectorParameterBuilder.newBuilder((ServerAddress)REGISTRY).setApplicationInformation(AAS_URN, "").setEndpointPath(aasServer.getSchema() + ":" + REGISTRY.getEndpoint()).build();
    }

    public String getQNameOperationStartMachine() {
        return AasTest.QNAME_OP_STARTMACHINE;
    }

    public String getQNameOperationStopMachine() {
        return AasTest.QNAME_OP_STOPMACHINE;
    }

    public String getQNameVarLotSize() {
        return AasTest.QNAME_VAR_LOTSIZE;
    }

    public String getTopLevelModelPartName() {
        return "machine";
    }

    public void additionalFromActions(ModelAccess access, MachineCommand data) throws IOException {
        try {
            access.setStruct("machine" + access.getQSeparator() + "struct", null);
            Assert.fail((String)"No exception raised");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void initializeModelAccess(ModelAccess access, boolean withNotifications) throws IOException {
        if (withNotifications) {
            try {
                access.monitor(new String[]{""});
                Assert.fail((String)"No exception raised");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            access.registerCustomType(Object.class);
            Assert.fail((String)"No exception raised");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getVendor(ModelAccess access) throws IOException {
        try {
            access.getStruct("machine" + access.getQSeparator() + "struct", Object.class);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return (String)access.get(AasTest.QNAME_VAR_VENDOR);
    }

    public String getQNameVarPowerConsumption() {
        return AasTest.QNAME_VAR_POWCONSUMPTION;
    }

    public void assertAdditionalProperties(AbstractInformationModelConnectorTest.Step step, MachineData received) {
    }

    public void afterActions(Connector<Object, Object, MachineData, MachineCommand> connector) {
    }
}

