/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.connectors.opcuav1;

import de.iip_ecosphere.platform.connectors.ConnectorParameter;
import java.io.File;
import java.io.IOException;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.util.concurrent.ExecutionException;
import org.apache.commons.io.FileUtils;
import org.eclipse.milo.opcua.sdk.server.api.config.OpcUaServerConfig;
import org.eclipse.milo.opcua.sdk.server.api.config.OpcUaServerConfigBuilder;
import org.eclipse.milo.opcua.sdk.server.identity.CompositeValidator;
import org.eclipse.milo.opcua.sdk.server.identity.IdentityValidator;
import org.eclipse.milo.opcua.sdk.server.identity.UsernameIdentityValidator;
import org.eclipse.milo.opcua.sdk.server.identity.X509IdentityValidator;
import org.eclipse.milo.opcua.sdk.server.util.HostnameUtil;
import org.eclipse.milo.opcua.stack.core.UaRuntimeException;
import org.eclipse.milo.opcua.stack.core.security.CertificateManager;
import org.eclipse.milo.opcua.stack.core.security.DefaultCertificateManager;
import org.eclipse.milo.opcua.stack.core.security.DefaultTrustListManager;
import org.eclipse.milo.opcua.stack.core.security.SecurityPolicy;
import org.eclipse.milo.opcua.stack.core.security.TrustListManager;
import org.eclipse.milo.opcua.stack.core.types.enumerated.MessageSecurityMode;
import org.eclipse.milo.opcua.stack.core.types.structured.UserTokenPolicy;
import org.eclipse.milo.opcua.stack.core.util.CertificateUtil;
import org.eclipse.milo.opcua.stack.core.util.SelfSignedCertificateGenerator;
import org.eclipse.milo.opcua.stack.core.util.SelfSignedHttpsCertificateBuilder;
import org.eclipse.milo.opcua.stack.server.EndpointConfiguration;
import org.eclipse.milo.opcua.stack.server.security.DefaultServerCertificateValidator;
import org.eclipse.milo.opcua.stack.server.security.ServerCertificateValidator;
import org.slf4j.LoggerFactory;
import test.de.iip_ecosphere.platform.connectors.opcuav1.ClientKeystoreLoader;
import test.de.iip_ecosphere.platform.connectors.opcuav1.ServerKeystoreLoader;
import test.de.iip_ecosphere.platform.connectors.opcuav1.ServerSetup;

public class SecureSetup
extends ServerSetup {
    private File securityTempDir;
    private X509Certificate certificate;
    private DefaultCertificateManager certificateManager;
    private DefaultTrustListManager trustListManager;
    private DefaultServerCertificateValidator certificateValidator;
    private KeyPair httpsKeyPair;
    private X509Certificate httpsCertificate;
    private X509IdentityValidator x509IdentityValidator;
    private String applicationUri;
    private IdentityValidator<String> identityValidator = new UsernameIdentityValidator(true, authChallenge -> {
        String username = authChallenge.getUsername();
        String password = authChallenge.getPassword();
        boolean userOk = "user".equals(username) && "password1".equals(password);
        boolean adminOk = "admin".equals(username) && "password2".equals(password);
        return userOk || adminOk;
    });
    private X509Certificate clientCertificate;
    private KeyPair clientKeyPair;

    public SecureSetup(String path, int tcpPort, int httpsPort) {
        super(path, tcpPort, httpsPort);
    }

    @Override
    public String initializeApplication() throws ExecutionException {
        try {
            File securityTempDir = new File(System.getProperty("java.io.tmpdir"), "security");
            FileUtils.deleteDirectory((File)securityTempDir);
            if (!securityTempDir.exists() && !securityTempDir.mkdirs()) {
                throw new IOException("unable to create security temp dir: " + securityTempDir);
            }
            LoggerFactory.getLogger(this.getClass()).info("security temp dir: {}", (Object)securityTempDir.getAbsolutePath());
        }
        catch (IOException e) {
            throw new ExecutionException(e);
        }
        this.setupServer();
        this.setupClient();
        return this.applicationUri;
    }

    private void setupServer() throws ExecutionException {
        try {
            File securityTempDir = new File(System.getProperty("java.io.tmpdir"), "security");
            FileUtils.deleteDirectory((File)securityTempDir);
            if (!securityTempDir.exists() && !securityTempDir.mkdirs()) {
                throw new Exception("unable to create security temp dir: " + securityTempDir);
            }
            LoggerFactory.getLogger(this.getClass()).info("security temp dir: {}", (Object)securityTempDir.getAbsolutePath());
            ServerKeystoreLoader loader = new ServerKeystoreLoader().load(securityTempDir);
            this.certificateManager = new DefaultCertificateManager(loader.getServerKeyPair(), loader.getServerCertificateChain());
            File pkiDir = securityTempDir.toPath().resolve("pki").toFile();
            this.trustListManager = new DefaultTrustListManager(pkiDir);
            LoggerFactory.getLogger(this.getClass()).info("pki dir: {}", (Object)pkiDir.getAbsolutePath());
            this.certificateValidator = new DefaultServerCertificateValidator((TrustListManager)this.trustListManager);
            this.httpsKeyPair = SelfSignedCertificateGenerator.generateRsaKeyPair((int)2048);
            SelfSignedHttpsCertificateBuilder httpsCertificateBuilder = new SelfSignedHttpsCertificateBuilder(this.httpsKeyPair);
            httpsCertificateBuilder.setCommonName(HostnameUtil.getHostname());
            HostnameUtil.getHostnames((String)"0.0.0.0").forEach(arg_0 -> ((SelfSignedHttpsCertificateBuilder)httpsCertificateBuilder).addDnsName(arg_0));
            this.httpsCertificate = httpsCertificateBuilder.build();
            this.x509IdentityValidator = new X509IdentityValidator(c -> true);
            this.certificate = (X509Certificate)this.certificateManager.getCertificates().stream().findFirst().orElseThrow(() -> new UaRuntimeException(0x80890000L, "no certificate found"));
            this.applicationUri = (String)CertificateUtil.getSanUri((X509Certificate)this.certificate).orElseThrow(() -> new UaRuntimeException(0x80890000L, "certificate is missing the application URI"));
        }
        catch (Exception e) {
            throw new ExecutionException(e);
        }
    }

    private void setupClient() throws ExecutionException {
        ClientKeystoreLoader loader = new ClientKeystoreLoader().load(this.securityTempDir);
        this.clientCertificate = loader.getClientCertificate();
        this.clientKeyPair = loader.getClientKeyPair();
    }

    @Override
    public void shutdownApplication() throws ExecutionException {
        try {
            FileUtils.deleteDirectory((File)this.securityTempDir);
        }
        catch (IOException e) {
            throw new ExecutionException(e);
        }
    }

    @Override
    public void configureCommonEndpointBuilder(EndpointConfiguration.Builder builder) {
        builder.setCertificate(this.certificate).addTokenPolicies(new UserTokenPolicy[]{OpcUaServerConfig.USER_TOKEN_POLICY_ANONYMOUS, OpcUaServerConfig.USER_TOKEN_POLICY_USERNAME, OpcUaServerConfig.USER_TOKEN_POLICY_X509});
    }

    @Override
    public EndpointConfiguration.Builder configureNoSecurityBuilder(EndpointConfiguration.Builder builder) {
        return builder.setSecurityPolicy(SecurityPolicy.None).setSecurityMode(MessageSecurityMode.None);
    }

    @Override
    public EndpointConfiguration.Builder configureTcpEndpointBuilder(EndpointConfiguration.Builder builder) {
        return builder.setSecurityPolicy(SecurityPolicy.Basic256Sha256).setSecurityMode(MessageSecurityMode.SignAndEncrypt);
    }

    @Override
    public EndpointConfiguration.Builder configureHttpsEndpointBuilder(EndpointConfiguration.Builder builder) {
        return builder.setSecurityPolicy(SecurityPolicy.Basic256Sha256).setSecurityMode(MessageSecurityMode.Sign);
    }

    @Override
    public void configureServerBuilder(OpcUaServerConfigBuilder builder) {
        builder.setCertificateManager((CertificateManager)this.certificateManager).setTrustListManager((TrustListManager)this.trustListManager).setCertificateValidator((ServerCertificateValidator)this.certificateValidator).setHttpsKeyPair(this.httpsKeyPair).setHttpsCertificate(this.httpsCertificate).setIdentityValidator((IdentityValidator)new CompositeValidator(new IdentityValidator[]{this.identityValidator, this.x509IdentityValidator}));
    }

    @Override
    public ConnectorParameter getConnectorParameter() {
        return ConnectorParameter.ConnectorParameterBuilder.newBuilder((String)"localhost", (int)this.getHttpsPort()).setEndpointPath(this.getPath()).setApplicationInformation("urn:eclipse:milo:examples:client", "eclipse milo opc-ua client").setSecurityInformation(this.clientCertificate, this.clientKeyPair).setNotificationInterval(1000).build();
    }
}

