/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.connectors.opcuav1;

import de.iip_ecosphere.platform.connectors.AbstractConnector;
import de.iip_ecosphere.platform.connectors.ConnectorDescriptor;
import de.iip_ecosphere.platform.connectors.ConnectorParameter;
import de.iip_ecosphere.platform.connectors.IdentityToken;
import de.iip_ecosphere.platform.connectors.MachineConnector;
import de.iip_ecosphere.platform.connectors.model.AbstractModelAccess;
import de.iip_ecosphere.platform.connectors.model.ModelAccess;
import de.iip_ecosphere.platform.connectors.opcuav1.DataItem;
import de.iip_ecosphere.platform.connectors.types.ProtocolAdapter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.api.config.OpcUaClientConfigBuilder;
import org.eclipse.milo.opcua.sdk.client.api.identity.AnonymousProvider;
import org.eclipse.milo.opcua.sdk.client.api.identity.IdentityProvider;
import org.eclipse.milo.opcua.sdk.client.api.identity.SignedIdentityToken;
import org.eclipse.milo.opcua.sdk.client.api.subscriptions.UaMonitoredItem;
import org.eclipse.milo.opcua.sdk.client.api.subscriptions.UaSubscription;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaVariableNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.Stack;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.DataTypeCodec;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.DataTypeEncoding;
import org.eclipse.milo.opcua.stack.core.types.OpcUaDefaultBinaryEncoding;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.MonitoringMode;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;
import org.eclipse.milo.opcua.stack.core.types.structured.AnonymousIdentityToken;
import org.eclipse.milo.opcua.stack.core.types.structured.CallMethodRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.EndpointDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.IssuedIdentityToken;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoredItemCreateRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoringParameters;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadValueId;
import org.eclipse.milo.opcua.stack.core.types.structured.SignatureData;
import org.eclipse.milo.opcua.stack.core.types.structured.UserIdentityToken;
import org.eclipse.milo.opcua.stack.core.types.structured.UserNameIdentityToken;
import org.eclipse.milo.opcua.stack.core.types.structured.X509IdentityToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MachineConnector
public class OpcUaConnector<CO, CI>
extends AbstractConnector<DataItem, Object, CO, CI> {
    public static final String NAME = "OPC UA v1";
    private static final Logger LOGGER = LoggerFactory.getLogger(OpcUaConnector.class);
    private static final DataItem DUMMY = new DataItem(null, null);
    private static final String FIELD_BINARY_ENCODING_ID = "BINARY_ENCODING_ID";
    private OpcUaClient client;
    private ConnectorParameter params;

    public OpcUaConnector(ProtocolAdapter<DataItem, Object, CO, CI> adapter) {
        super(adapter);
        adapter.setModelAccess((ModelAccess)new OpcUaModelAccess());
    }

    protected void connectImpl(ConnectorParameter params) throws IOException {
        if (null == this.client) {
            this.params = params;
            String endpointURL = "opc." + params.getSchema().toUri() + params.getHost() + ":" + params.getPort() + "/" + params.getEndpointPath();
            try {
                this.client = OpcUaClient.create((String)endpointURL, endpoints -> endpoints.stream().filter(this.endpointFilter(params)).findFirst(), configBuilder -> this.configure((OpcUaClientConfigBuilder)configBuilder).build());
                this.client.connect().get();
            }
            catch (InterruptedException | ExecutionException | UaException e) {
                this.client = null;
                throw new IOException(e);
            }
        }
    }

    protected Predicate<EndpointDescription> endpointFilter(ConnectorParameter params) {
        return e -> params.isFeasibleEndpoint(e.getEndpointUrl(), e.getSecurityLevel().byteValue());
    }

    private OpcUaClientConfigBuilder configure(OpcUaClientConfigBuilder configBuilder) {
        configBuilder.setApplicationName(LocalizedText.english((String)this.params.getApplicationDescription())).setApplicationUri(this.params.getApplicationId()).setIdentityProvider(this.getIdentityProvider(this.params)).setRequestTimeout(Unsigned.uint((int)this.params.getRequestTimeout()));
        if (null != this.params.getClientCertificate()) {
            configBuilder.setCertificate(this.params.getClientCertificate());
        }
        if (null != this.params.getClientKeyPair()) {
            configBuilder.setKeyPair(this.params.getClientKeyPair());
        }
        return configBuilder;
    }

    protected IdentityProvider getIdentityProvider(final ConnectorParameter params) {
        Object identityProvider = params.isAnonymousIdentity() ? new AnonymousProvider() : new IdentityProvider(){

            public SignedIdentityToken getIdentityToken(EndpointDescription endpoint, ByteString serverNonce) throws Exception {
                AnonymousIdentityToken uiToken;
                IdentityToken idToken = params.getIdentityToken(endpoint.getEndpointUrl());
                SignedIdentityToken token = null;
                if (null != idToken) {
                    switch (idToken.getType()) {
                        case ISSUED: {
                            uiToken = new IssuedIdentityToken(idToken.getTokenPolicyId(), new ByteString(idToken.getTokenData()), idToken.getTokenEncryptionAlgorithm());
                            break;
                        }
                        case USERNAME: {
                            uiToken = new UserNameIdentityToken(idToken.getTokenPolicyId(), idToken.getUserName(), new ByteString(idToken.getTokenData()), idToken.getTokenEncryptionAlgorithm());
                            break;
                        }
                        case X509: {
                            uiToken = new X509IdentityToken(idToken.getTokenPolicyId(), new ByteString(idToken.getTokenData()));
                            break;
                        }
                        default: {
                            uiToken = new AnonymousIdentityToken(idToken.getTokenPolicyId());
                        }
                    }
                } else {
                    throw new Exception("No token information configured");
                }
                token = new SignedIdentityToken((UserIdentityToken)uiToken, new SignatureData(idToken.getSignatureAlgorithm(), new ByteString(idToken.getSignature())));
                return token;
            }
        };
        return identityProvider;
    }

    protected void disconnectImpl() throws IOException {
        if (null != this.client) {
            try {
                this.client.disconnect().get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new IOException(e);
            }
        }
    }

    public String getName() {
        return NAME;
    }

    public void dispose() {
        Stack.releaseSharedResources();
    }

    protected void writeImpl(Object data) throws IOException {
    }

    protected DataItem read() throws IOException {
        return DUMMY;
    }

    protected void error(String message, Throwable th) {
        LOGGER.error(message, th);
    }

    protected class OpcUaModelAccess
    extends AbstractModelAccess {
        private static final char SEPARATOR_CHAR = '/';
        private static final String SEPARATOR_STRING = "/";

        protected OpcUaModelAccess() {
            super((AbstractModelAccess.NotificationChangedListener)OpcUaConnector.this);
        }

        public String getQSeparator() {
            return SEPARATOR_STRING;
        }

        public Object call(String qName, Object ... args) throws IOException {
            Object callResult;
            int pos = qName.lastIndexOf(47);
            if (pos > 1) {
                Variant[] a = new Variant[args.length];
                for (int i = 0; i < args.length; ++i) {
                    a[i] = new Variant(args[i]);
                }
                CallMethodRequest request = new CallMethodRequest(new NodeId(2, qName.substring(0, pos)), new NodeId(2, qName), a);
                try {
                    Variant cr = (Variant)((CompletableFuture)OpcUaConnector.this.client.call(request).thenCompose(result -> {
                        StatusCode statusCode = result.getStatusCode();
                        if (statusCode.isGood()) {
                            Variant[] results = result.getOutputArguments();
                            Variant res = 0 == results.length ? null : result.getOutputArguments()[0];
                            return CompletableFuture.completedFuture(res);
                        }
                        CompletableFuture f = new CompletableFuture();
                        f.completeExceptionally(new UaException(statusCode));
                        return f;
                    })).get();
                    if (null != cr) {
                        callResult = cr.getValue();
                    }
                    callResult = null;
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new IOException(e);
                }
            } else {
                throw new IOException("Cannot access top level operation '" + qName + "'");
            }
            return callResult;
        }

        public Object get(String qName) throws IOException {
            Object result;
            try {
                UaVariableNode node = OpcUaConnector.this.client.getAddressSpace().getVariableNode(new NodeId(2, qName));
                DataValue value = node.readValue();
                Variant r = value.getValue();
                result = null != r ? r.getValue() : null;
            }
            catch (UaException e) {
                throw new IOException(e);
            }
            return result;
        }

        public void set(String qName, Object value) throws IOException {
            try {
                UaVariableNode node = OpcUaConnector.this.client.getAddressSpace().getVariableNode(new NodeId(2, qName));
                node.writeValue(new DataValue(new Variant(value)));
            }
            catch (UaException e) {
                throw new IOException(e);
            }
        }

        public <T> T getStruct(String qName, Class<T> type) throws IOException {
            try {
                UaVariableNode node = OpcUaConnector.this.client.getAddressSpace().getVariableNode(new NodeId(2, qName));
                DataValue value = node.readValue();
                Variant variant = value.getValue();
                ExtensionObject xo = (ExtensionObject)variant.getValue();
                T decoded = type.cast(xo.decode(OpcUaConnector.this.client.getSerializationContext()));
                return decoded;
            }
            catch (UaException e) {
                throw new IOException(e);
            }
        }

        public void setStruct(String qName, Object value) throws IOException {
            try {
                ExpandedNodeId encodingId = this.getEncodingId(value.getClass());
                UaVariableNode node = OpcUaConnector.this.client.getAddressSpace().getVariableNode(new NodeId(2, qName));
                ExtensionObject modifiedXo = ExtensionObject.encode((SerializationContext)OpcUaConnector.this.client.getSerializationContext(), (Object)value, (ExpandedNodeId)encodingId, (DataTypeEncoding)OpcUaDefaultBinaryEncoding.getInstance());
                node.writeValue(new DataValue(new Variant((Object)modifiedXo)));
            }
            catch (UaException e) {
                throw new IOException(e);
            }
        }

        private ExpandedNodeId getEncodingId(Class<?> cls) throws IOException {
            ExpandedNodeId encodingId;
            try {
                Field bei = cls.getField(OpcUaConnector.FIELD_BINARY_ENCODING_ID);
                encodingId = (ExpandedNodeId)bei.get(null);
            }
            catch (ClassCastException e) {
                throw new IOException("Field BINARY_ENCODING_ID in class " + cls.getName() + " is not of type " + ExpandedNodeId.class);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new IOException("Class " + cls.getName() + " does not declare a publicly accessible static field BINARY_ENCODING_ID providing the encoding id.");
            }
            return encodingId;
        }

        public void registerCustomType(Class<?> cls) throws IOException {
            Class<?>[] declared;
            ExpandedNodeId encodingId = this.getEncodingId(cls);
            NodeId binaryEncodingId = (NodeId)encodingId.toNodeId(OpcUaConnector.this.client.getNamespaceTable()).orElseThrow(() -> new IOException("Client namespace not found"));
            GenericDataTypeCodec codec = null;
            for (Class<?> cl : declared = cls.getDeclaredClasses()) {
                if (!cl.getSimpleName().equals("Codec") || !GenericDataTypeCodec.class.isAssignableFrom(cl)) continue;
                try {
                    codec = (GenericDataTypeCodec)cl.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (NoSuchMethodException e) {
                    throw new IOException("Cannot instantiate codec in " + cls.getName() + ": No accessible no-arg constructor declared");
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    throw new IOException("Cannot instantiate codec in " + cls.getName() + ": " + e.getMessage(), e);
                }
            }
            if (null == codec) {
                throw new IOException("No inner class Codec extending " + GenericDataTypeCodec.class + " found in " + cls.getName());
            }
            OpcUaConnector.this.client.getDataTypeManager().registerCodec(binaryEncodingId, (DataTypeCodec)codec.asBinaryCodec());
        }

        public void monitor(String ... qName) throws IOException {
            try {
                UaSubscription subscription = (UaSubscription)OpcUaConnector.this.client.getSubscriptionManager().createSubscription((double)OpcUaConnector.this.params.getNotificationInterval()).get();
                UInteger clientHandle = subscription.nextClientHandle();
                MonitoringParameters parameters = new MonitoringParameters(clientHandle, Double.valueOf(OpcUaConnector.this.params.getNotificationInterval()), null, Unsigned.uint((int)10), Boolean.valueOf(true));
                ArrayList<MonitoredItemCreateRequest> requests = new ArrayList<MonitoredItemCreateRequest>();
                for (String n : qName) {
                    UaNode node = OpcUaConnector.this.client.getAddressSpace().getNode(new NodeId(2, n));
                    ReadValueId readValueId = new ReadValueId(node.getNodeId(), AttributeId.Value.uid(), null, QualifiedName.NULL_VALUE);
                    MonitoredItemCreateRequest request = new MonitoredItemCreateRequest(readValueId, MonitoringMode.Reporting, parameters);
                    requests.add(request);
                }
                BiConsumer<UaMonitoredItem, Integer> onItemCreated = (item, id) -> item.setValueConsumer(this::onSubscriptionValue);
                List items = (List)subscription.createMonitoredItems(TimestampsToReturn.Both, requests, onItemCreated).get();
                for (UaMonitoredItem item2 : items) {
                    if (item2.getStatusCode().isGood()) {
                        LOGGER.info("Monitoring for nodeId={} activated", (Object)item2.getReadValueId().getNodeId());
                        continue;
                    }
                    LOGGER.warn("failed to create item for nodeId={} (status={})", (Object)item2.getReadValueId().getNodeId(), (Object)item2.getStatusCode());
                }
            }
            catch (InterruptedException | ExecutionException | UaException e) {
                throw new IOException(e);
            }
        }

        private void onSubscriptionValue(UaMonitoredItem item, DataValue value) {
            try {
                DataItem details;
                if (this.isDetailNotifiedItemEnabled()) {
                    Object nodeId = item.getReadValueId().getNodeId().getIdentifier();
                    details = new DataItem(nodeId, value.getValue());
                } else {
                    details = null;
                }
                OpcUaConnector.this.received(details);
            }
            catch (IOException e) {
                LOGGER.info("While triggering reception", (Throwable)e);
            }
        }
    }

    public static class Descriptor
    implements ConnectorDescriptor {
        public String getName() {
            return OpcUaConnector.NAME;
        }

        public Class<?> getType() {
            return OpcUaConnector.class;
        }
    }
}

