/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.connectors.opcuav1;

import de.iip_ecosphere.platform.connectors.Connector;
import de.iip_ecosphere.platform.connectors.ConnectorDescriptor;
import de.iip_ecosphere.platform.connectors.ConnectorParameter;
import de.iip_ecosphere.platform.connectors.model.ModelAccess;
import de.iip_ecosphere.platform.connectors.opcuav1.DataItem;
import de.iip_ecosphere.platform.connectors.opcuav1.OpcUaConnector;
import de.iip_ecosphere.platform.connectors.types.ProtocolAdapter;
import java.io.IOException;
import org.junit.Assert;
import test.de.iip_ecosphere.platform.connectors.AbstractInformationModelConnectorTest;
import test.de.iip_ecosphere.platform.connectors.MachineCommand;
import test.de.iip_ecosphere.platform.connectors.MachineData;
import test.de.iip_ecosphere.platform.connectors.opcuav1.ServerSetup;
import test.de.iip_ecosphere.platform.connectors.opcuav1.simpleMachineNamespace.Namespace;
import test.de.iip_ecosphere.platform.connectors.opcuav1.simpleMachineNamespace.VendorStruct;

public class AbstractOpcUaConnectorTest
extends AbstractInformationModelConnectorTest<DataItem> {
    public static final String VENDOR_NAME2 = "PhoenixContact";
    private static ServerSetup setup;
    private static Connector<DataItem, Object, MachineData, MachineCommand> lastConnector;

    public AbstractOpcUaConnectorTest() {
        super(DataItem.class);
    }

    protected static void setSetup(ServerSetup instance) {
        setup = instance;
    }

    protected static ServerSetup getSetup() {
        return setup;
    }

    static void dispose() {
        if (null != lastConnector) {
            lastConnector.dispose();
        }
    }

    protected Class<? extends ConnectorDescriptor> getConnectorDescriptor() {
        return OpcUaConnector.Descriptor.class;
    }

    protected Connector<DataItem, Object, MachineData, MachineCommand> createConnector(ProtocolAdapter<DataItem, Object, MachineData, MachineCommand> adapter) {
        return new OpcUaConnector(new ProtocolAdapter[]{adapter});
    }

    protected ConnectorParameter getConnectorParameter() {
        return setup.getConnectorParameter();
    }

    public String getQNameOperationStartMachine() {
        return Namespace.QNAME_METHOD_START;
    }

    public String getQNameOperationStopMachine() {
        return Namespace.QNAME_METHOD_END;
    }

    public String getQNameVarLotSize() {
        return Namespace.QNAME_VAR_LOT_SIZE;
    }

    public String getTopLevelModelPartName() {
        return Namespace.QNAME_TOP_FOLDER;
    }

    public void additionalFromActions(ModelAccess access, MachineCommand data) throws IOException {
        if (data.isStop()) {
            access.setStruct(Namespace.QNAME_VAR_STRUCT, (Object)new VendorStruct("Phoenix Contact", 2020, true));
        }
        if (data.getLotSize() > 0) {
            access.setStruct(Namespace.QNAME_VAR_STRUCT, (Object)new VendorStruct(VENDOR_NAME2, 2020, true));
        }
    }

    public void initializeModelAccess(ModelAccess access, boolean withNotifications) throws IOException {
        if (withNotifications) {
            access.monitor(new String[]{Namespace.QNAME_VAR_LOT_SIZE, Namespace.QNAME_VAR_POWER_CONSUMPTION});
        }
        access.registerCustomType(VendorStruct.class);
    }

    public String getVendor(ModelAccess access) throws IOException {
        return ((VendorStruct)access.getStruct(Namespace.QNAME_VAR_STRUCT, VendorStruct.class)).getVendor();
    }

    public String getQNameVarPowerConsumption() {
        return Namespace.QNAME_VAR_POWER_CONSUMPTION;
    }

    public void assertAdditionalProperties(AbstractInformationModelConnectorTest.Step step, MachineData received) {
        switch (step) {
            case MACHINE_DATA_SENT: {
                Assert.assertEquals((Object)"Phoenix Contact", (Object)received.getVendor());
                break;
            }
            case START_COMMAND_SENT: {
                Assert.assertEquals((Object)"Phoenix Contact", (Object)received.getVendor());
                break;
            }
            case LOT_SIZE_CHANGED: {
                Assert.assertEquals((Object)VENDOR_NAME2, (Object)received.getVendor());
                break;
            }
            case STOP_COMMAND_SENT: {
                Assert.assertEquals((Object)"Phoenix Contact", (Object)received.getVendor());
                break;
            }
        }
    }

    public void afterActions(Connector<DataItem, Object, MachineData, MachineCommand> connector) {
        lastConnector = connector;
    }
}

