/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.connectors.opcuav1.simpleMachineNamespace;

import com.google.common.collect.ImmutableSet;
import de.iip_ecosphere.platform.support.TimeUtils;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.eclipse.milo.opcua.sdk.core.AccessLevel;
import org.eclipse.milo.opcua.sdk.core.Reference;
import org.eclipse.milo.opcua.sdk.core.nodes.Node;
import org.eclipse.milo.opcua.sdk.server.Lifecycle;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.api.DataItem;
import org.eclipse.milo.opcua.sdk.server.api.ManagedNamespaceWithLifecycle;
import org.eclipse.milo.opcua.sdk.server.api.MonitoredItem;
import org.eclipse.milo.opcua.sdk.server.api.methods.AbstractMethodInvocationHandler;
import org.eclipse.milo.opcua.sdk.server.api.services.AttributeServices;
import org.eclipse.milo.opcua.sdk.server.model.nodes.objects.BaseEventTypeNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.objects.ServerTypeNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaFolderNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaMethodNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNodeContext;
import org.eclipse.milo.opcua.sdk.server.nodes.UaVariableNode;
import org.eclipse.milo.opcua.sdk.server.util.SubscriptionModel;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.structured.Argument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import test.de.iip_ecosphere.platform.connectors.opcuav1.DataTypeDictionaryManager;
import test.de.iip_ecosphere.platform.connectors.opcuav1.simpleMachineNamespace.MethodCreator;
import test.de.iip_ecosphere.platform.connectors.opcuav1.simpleMachineNamespace.VendorStruct;

public class Namespace
extends ManagedNamespaceWithLifecycle {
    public static final String NAMESPACE_URI = "urn:eclipse:milo:hello-world";
    public static final String QNAME_TOP_FOLDER = "HelloWorld";
    public static final String QNAME_VAR_LOT_SIZE = QNAME_TOP_FOLDER + "/" + "lotSize";
    public static final String QNAME_VAR_POWER_CONSUMPTION = QNAME_TOP_FOLDER + "/" + "powerConsumption";
    public static final String QNAME_VAR_STRUCT = QNAME_TOP_FOLDER + "/" + "vendor";
    public static final String QNAME_EVENT_NODE = "events";
    public static final String QNAME_METHOD_START = QNAME_TOP_FOLDER + "/" + "startMachine";
    public static final String QNAME_METHOD_END = QNAME_TOP_FOLDER + "/" + "endMachine";
    public static final String VENDOR_NAME = "Phoenix Contact";
    private static final String NAME_TOP_FOLDER = "HelloWorld";
    private static final String NAME_VAR_LOT_SIZE = "lotSize";
    private static final String NAME_VAR_POWER_CONSUMPTION = "powerConsumption";
    private static final String NAME_VAR_STRUCT = "vendor";
    private static final String NAME_EVENT_NODE = "events";
    private static final String NAME_METHOD_START = "startMachine";
    private static final String NAME_METHOD_END = "endMachine";
    private static final Argument LOT_SIZE = new Argument("x", Identifiers.Integer, Integer.valueOf(-1), null, new LocalizedText("The new lot size."));
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final SubscriptionModel subscriptionModel;
    private final DataTypeDictionaryManager dictionaryManager;
    private volatile Thread eventThread;
    private volatile boolean keepPostingEvents = true;
    private UaVariableNode lotSize;
    private UaVariableNode powConsumption;

    public Namespace(OpcUaServer server) {
        super(server, NAMESPACE_URI);
        this.subscriptionModel = new SubscriptionModel(server, (AttributeServices)this);
        this.dictionaryManager = new DataTypeDictionaryManager(this.getNodeContext(), NAMESPACE_URI);
        this.getLifecycleManager().addLifecycle((Lifecycle)this.dictionaryManager);
        this.getLifecycleManager().addLifecycle((Lifecycle)this.subscriptionModel);
        this.getLifecycleManager().addStartupTask(this::createAndAddNodes);
        this.getLifecycleManager().addLifecycle(new Lifecycle(){

            public void startup() {
                Namespace.this.startBogusEventNotifier();
            }

            public void shutdown() {
                try {
                    Namespace.this.keepPostingEvents = false;
                    Namespace.this.eventThread.interrupt();
                    Namespace.this.eventThread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
    }

    private void createAndAddNodes() {
        UaFolderNode folderNode = this.createFolder(null, NAME_TOP_FOLDER);
        this.lotSize = this.createVariable(folderNode, NAME_VAR_LOT_SIZE, Identifiers.Integer, new Variant((Object)1), (ImmutableSet<AccessLevel>)AccessLevel.READ_WRITE);
        this.powConsumption = this.createVariable(folderNode, NAME_VAR_POWER_CONSUMPTION, Identifiers.Double, new Variant((Object)0.1), (ImmutableSet<AccessLevel>)AccessLevel.READ_ONLY);
        this.addMethod(folderNode, NAME_METHOD_START, "Starts the machine.", n -> new StartProcessingMethod(n));
        this.addMethod(folderNode, NAME_METHOD_END, "Stops the machine.", n -> new StopProcessingMethod(n));
        try {
            VendorStruct.registerType(this.getServer(), this.getNamespaceIndex(), this.dictionaryManager);
            VendorStruct value = new VendorStruct(VENDOR_NAME, 2020, true);
            this.addCustomStructTypeVariable(folderNode, NAME_VAR_STRUCT, VendorStruct.TYPE_ID, VendorStruct.BINARY_ENCODING_ID, value);
        }
        catch (Exception e) {
            this.logger.warn("Failed to register custom struct type", (Throwable)e);
        }
    }

    private UaFolderNode createFolder(UaFolderNode parent, String name) {
        UaFolderNode result = new UaFolderNode(this.getNodeContext(), this.newNodeId(name), this.newQualifiedName(name), LocalizedText.english((String)name));
        this.getNodeManager().addNode((Node)result);
        if (null != parent) {
            parent.addOrganizes((UaNode)result);
        } else {
            result.addReference(new Reference(result.getNodeId(), Identifiers.Organizes, Identifiers.ObjectsFolder.expanded(), false));
        }
        return result;
    }

    private UaVariableNode createVariable(UaFolderNode parent, String name, NodeId type, Variant value, ImmutableSet<AccessLevel> access) {
        UaVariableNode result = new UaVariableNode.UaVariableNodeBuilder(this.getNodeContext()).setNodeId(this.newNodeId(parent.getBrowseName().getName() + "/" + name)).setAccessLevel(access).setUserAccessLevel(access).setBrowseName(this.newQualifiedName(name)).setDisplayName(LocalizedText.english((String)name)).setDataType(type).setTypeDefinition(Identifiers.BaseDataVariableType).build();
        result.setValue(new DataValue(value));
        this.getNodeManager().addNode((Node)result);
        parent.addOrganizes((UaNode)result);
        return result;
    }

    private void addMethod(UaFolderNode parent, String name, String description, MethodCreator<?> creator) {
        UaMethodNode methodNode = UaMethodNode.builder((UaNodeContext)this.getNodeContext()).setNodeId(this.newNodeId(parent.getBrowseName().getName() + "/" + name)).setBrowseName(this.newQualifiedName(name)).setDisplayName(new LocalizedText(null, name)).setDescription(LocalizedText.english((String)description)).build();
        Object method = creator.create(methodNode);
        methodNode.setInputArguments(method.getInputArguments());
        methodNode.setOutputArguments(method.getOutputArguments());
        methodNode.setInvocationHandler(method);
        this.getNodeManager().addNode((Node)methodNode);
        methodNode.addReference(new Reference(methodNode.getNodeId(), Identifiers.HasComponent, parent.getNodeId().expanded(), false));
    }

    private void addCustomStructTypeVariable(UaFolderNode parent, String name, ExpandedNodeId type, ExpandedNodeId encoding, Object value) throws Exception {
        NodeId dataTypeId = type.toNodeIdOrThrow(this.getServer().getNamespaceTable());
        NodeId binaryEncodingId = encoding.toNodeIdOrThrow(this.getServer().getNamespaceTable());
        UaVariableNode customStructTypeVariable = UaVariableNode.builder((UaNodeContext)this.getNodeContext()).setNodeId(this.newNodeId(parent.getBrowseName().getName() + "/" + name)).setAccessLevel((Set)AccessLevel.READ_WRITE).setUserAccessLevel((Set)AccessLevel.READ_WRITE).setBrowseName(this.newQualifiedName(name)).setDisplayName(LocalizedText.english((String)name)).setDataType(dataTypeId).setTypeDefinition(Identifiers.BaseDataVariableType).build();
        ExtensionObject xo = ExtensionObject.encodeDefaultBinary((SerializationContext)this.getServer().getSerializationContext(), (Object)value, (NodeId)binaryEncodingId);
        customStructTypeVariable.setValue(new DataValue(new Variant((Object)xo)));
        this.getNodeManager().addNode((Node)customStructTypeVariable);
        customStructTypeVariable.addReference(new Reference(customStructTypeVariable.getNodeId(), Identifiers.Organizes, parent.getNodeId().expanded(), false));
    }

    private void startBogusEventNotifier() {
        UaNode serverNode = this.getServer().getAddressSpaceManager().getManagedNode(Identifiers.Server).orElse(null);
        if (serverNode instanceof ServerTypeNode) {
            ((ServerTypeNode)serverNode).setEventNotifier(Unsigned.ubyte((int)1));
            this.eventThread = new Thread(() -> {
                while (this.keepPostingEvents) {
                    try {
                        BaseEventTypeNode eventNode = this.getServer().getEventFactory().createEvent(this.newNodeId(UUID.randomUUID()), Identifiers.BaseEventType);
                        eventNode.setBrowseName(new QualifiedName(1, NAME_EVENT_NODE));
                        eventNode.setDisplayName(LocalizedText.english((String)NAME_EVENT_NODE));
                        eventNode.setEventId(ByteString.of((byte[])new byte[]{0, 1, 2, 3}));
                        eventNode.setEventType(Identifiers.BaseEventType);
                        eventNode.setSourceNode(serverNode.getNodeId());
                        eventNode.setSourceName(serverNode.getDisplayName().getText());
                        eventNode.setTime(DateTime.now());
                        eventNode.setReceiveTime(DateTime.NULL_VALUE);
                        eventNode.setMessage(LocalizedText.english((String)"event message!"));
                        eventNode.setSeverity(Unsigned.ushort((int)2));
                        this.getServer().getEventBus().post((Object)eventNode);
                        eventNode.delete();
                    }
                    catch (UaException e) {
                        this.logger.error("Error creating EventNode: {}", (Object)e.getMessage(), (Object)e);
                    }
                    TimeUtils.sleep((int)500);
                }
            }, "bogus-event-poster");
            this.eventThread.start();
        }
    }

    public void onDataItemsCreated(List<DataItem> dataItems) {
        this.subscriptionModel.onDataItemsCreated(dataItems);
    }

    public void onDataItemsModified(List<DataItem> dataItems) {
        this.subscriptionModel.onDataItemsModified(dataItems);
    }

    public void onDataItemsDeleted(List<DataItem> dataItems) {
        this.subscriptionModel.onDataItemsDeleted(dataItems);
    }

    public void onMonitoringModeChanged(List<MonitoredItem> monitoredItems) {
        this.subscriptionModel.onMonitoringModeChanged(monitoredItems);
    }

    public class ReconfigureMethod
    extends AbstractMethodInvocationHandler {
        public ReconfigureMethod(UaMethodNode node) {
            super(node);
        }

        public Argument[] getInputArguments() {
            return new Argument[]{LOT_SIZE};
        }

        public Argument[] getOutputArguments() {
            return new Argument[0];
        }

        protected Variant[] invoke(AbstractMethodInvocationHandler.InvocationContext invocationContext, Variant[] inputValues) {
            Namespace.this.lotSize.setValue(new DataValue(inputValues[0]));
            Namespace.this.logger.info("Machine reconfigured, lot size changed");
            return new Variant[0];
        }
    }

    public class StopProcessingMethod
    extends AbstractMethodInvocationHandler {
        public StopProcessingMethod(UaMethodNode node) {
            super(node);
        }

        public Argument[] getInputArguments() {
            return new Argument[0];
        }

        public Argument[] getOutputArguments() {
            return new Argument[0];
        }

        protected Variant[] invoke(AbstractMethodInvocationHandler.InvocationContext invocationContext, Variant[] inputValues) {
            Namespace.this.powConsumption.setValue(new DataValue(new Variant((Object)0.1)));
            Namespace.this.lotSize.setValue(new DataValue(new Variant((Object)1)));
            Namespace.this.logger.info("Machine stopped, power consumption changed to 0.1, lot size to 1");
            return new Variant[0];
        }
    }

    public class StartProcessingMethod
    extends AbstractMethodInvocationHandler {
        public StartProcessingMethod(UaMethodNode node) {
            super(node);
        }

        public Argument[] getInputArguments() {
            return new Argument[0];
        }

        public Argument[] getOutputArguments() {
            return new Argument[0];
        }

        protected Variant[] invoke(AbstractMethodInvocationHandler.InvocationContext invocationContext, Variant[] inputValues) {
            Namespace.this.powConsumption.setValue(new DataValue(new Variant((Object)10.1)));
            Namespace.this.logger.info("Machine started, power consumption changed to 10.1");
            return new Variant[0];
        }
    }
}

