/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.connectors.opcuav1;

import com.google.common.collect.Lists;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.api.ManagedNamespaceWithLifecycle;
import org.eclipse.milo.opcua.sdk.server.api.config.OpcUaServerConfig;
import org.eclipse.milo.opcua.sdk.server.api.config.OpcUaServerConfigBuilder;
import org.eclipse.milo.opcua.sdk.server.util.HostnameUtil;
import org.eclipse.milo.opcua.stack.core.security.SecurityPolicy;
import org.eclipse.milo.opcua.stack.core.transport.TransportProfile;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.enumerated.MessageSecurityMode;
import org.eclipse.milo.opcua.stack.core.types.structured.BuildInfo;
import org.eclipse.milo.opcua.stack.server.EndpointConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import test.de.iip_ecosphere.platform.connectors.opcuav1.NamespaceCreator;
import test.de.iip_ecosphere.platform.connectors.opcuav1.ServerSetup;

public class TestServer {
    protected static final boolean SECURE = false;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final OpcUaServer server;
    private final ManagedNamespaceWithLifecycle exampleNamespace;
    private final ServerSetup setup;

    public TestServer(NamespaceCreator namespaceCreator, ServerSetup setup) throws ExecutionException {
        this.setup = setup;
        String applicationUri = setup.initializeApplication();
        Set<EndpointConfiguration> endpointConfigurations = this.createEndpointConfigurations();
        OpcUaServerConfigBuilder builder = OpcUaServerConfig.builder().setApplicationUri(applicationUri).setApplicationName(LocalizedText.english((String)"Eclipse Milo OPC UA Example Server")).setEndpoints(endpointConfigurations).setBuildInfo(new BuildInfo("urn:eclipse:milo:example-server", "eclipse", "eclipse milo example server", OpcUaServer.SDK_VERSION, "", DateTime.now()));
        setup.configureServerBuilder(builder);
        OpcUaServerConfig serverConfig = builder.setProductUri("urn:eclipse:milo:example-server").build();
        this.server = new OpcUaServer(serverConfig);
        this.exampleNamespace = namespaceCreator.createNamespace(this.server);
        this.exampleNamespace.startup();
        this.logger.info("Namespace set up " + this.exampleNamespace.getNamespaceUri());
    }

    private Set<EndpointConfiguration> createEndpointConfigurations() {
        LinkedHashSet<EndpointConfiguration> endpointConfigurations = new LinkedHashSet<EndpointConfiguration>();
        ArrayList bindAddresses = Lists.newArrayList();
        bindAddresses.add("0.0.0.0");
        LinkedHashSet<String> hostnames = new LinkedHashSet<String>();
        hostnames.add(HostnameUtil.getHostname());
        hostnames.addAll(HostnameUtil.getHostnames((String)"0.0.0.0"));
        for (String bindAddress : bindAddresses) {
            for (String hostname : hostnames) {
                EndpointConfiguration.Builder builder = EndpointConfiguration.newBuilder().setBindAddress(bindAddress).setHostname(hostname).setPath("/" + this.setup.getPath());
                this.setup.configureCommonEndpointBuilder(builder);
                EndpointConfiguration.Builder tmp = this.setup.configureNoSecurityBuilder(builder.copy());
                if (null != tmp) {
                    endpointConfigurations.add(this.buildTcpEndpoint(tmp));
                    endpointConfigurations.add(this.buildHttpsEndpoint(tmp));
                }
                if (null != (tmp = this.setup.configureTcpEndpointBuilder(builder.copy()))) {
                    endpointConfigurations.add(this.buildTcpEndpoint(tmp));
                }
                if (null != (tmp = this.setup.configureHttpsEndpointBuilder(builder.copy()))) {
                    endpointConfigurations.add(this.buildHttpsEndpoint(tmp));
                }
                EndpointConfiguration.Builder discoveryBuilder = builder.copy().setPath(this.setup.getPath() + "/discovery").setSecurityPolicy(SecurityPolicy.None).setSecurityMode(MessageSecurityMode.None);
                endpointConfigurations.add(this.buildTcpEndpoint(discoveryBuilder));
                endpointConfigurations.add(this.buildHttpsEndpoint(discoveryBuilder));
            }
        }
        return endpointConfigurations;
    }

    private EndpointConfiguration buildTcpEndpoint(EndpointConfiguration.Builder base) {
        return base.copy().setTransportProfile(TransportProfile.TCP_UASC_UABINARY).setBindPort(this.setup.getTcpPort()).build();
    }

    private EndpointConfiguration buildHttpsEndpoint(EndpointConfiguration.Builder base) {
        return base.copy().setTransportProfile(TransportProfile.HTTPS_UABINARY).setBindPort(this.setup.getHttpsPort()).build();
    }

    public CompletableFuture<OpcUaServer> startup() {
        return this.server.startup();
    }

    public CompletableFuture<OpcUaServer> shutdown() {
        this.exampleNamespace.shutdown();
        return this.server.shutdown();
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

