/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.connectors.opcuav1;

import de.iip_ecosphere.platform.support.NetUtils;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import test.de.iip_ecosphere.platform.connectors.opcuav1.AbstractOpcUaConnectorTest;
import test.de.iip_ecosphere.platform.connectors.opcuav1.SecureSetup;
import test.de.iip_ecosphere.platform.connectors.opcuav1.TestServer;
import test.de.iip_ecosphere.platform.connectors.opcuav1.simpleMachineNamespace.Namespace;

public class OpcUaTlsConnectorTest
extends AbstractOpcUaConnectorTest {
    private static TestServer testServer;
    private static final Logger LOGGER;

    @BeforeClass
    public static void init() throws ExecutionException, InterruptedException {
        OpcUaTlsConnectorTest.setSetup(new SecureSetup("milo", NetUtils.getEphemeralPort(), NetUtils.getEphemeralPort()));
        testServer = new TestServer(server -> new Namespace(server), OpcUaTlsConnectorTest.getSetup());
        testServer.startup().get();
        LOGGER.info("OPC UA server started");
    }

    @AfterClass
    public static void shutdown() throws ExecutionException, InterruptedException {
        if (null != testServer) {
            testServer.shutdown().get();
            LOGGER.info("OPC UA server stopped");
            testServer = null;
        }
        AbstractOpcUaConnectorTest.dispose();
    }

    @Test
    public void testWithPolling() throws IOException {
        this.testConnector(false);
    }

    @Test
    public void testWithNotifications() throws IOException {
        this.testConnector(true);
    }

    static {
        LOGGER = LoggerFactory.getLogger(OpcUaTlsConnectorTest.class);
    }
}

