/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.connectors;

import de.iip_ecosphere.platform.connectors.ConnectorParameter;
import de.iip_ecosphere.platform.connectors.DefaultCachingStrategy;
import java.lang.reflect.InvocationTargetException;
import org.slf4j.LoggerFactory;

public interface CachingStrategy {
    public void setCacheMode(ConnectorParameter.CacheMode var1);

    public boolean checkCache(Object var1);

    public boolean checkCache(String var1, Object var2);

    public void clearCache();

    public static CachingStrategy createInstance(Class<? extends CachingStrategy> cls) {
        CachingStrategy result = null;
        if (cls != null) {
            try {
                result = cls.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                LoggerFactory.getLogger(CachingStrategy.class).warn("Creating caching strategy for {}: {}", (Object)cls.getName(), (Object)e.getMessage());
            }
        }
        if (null == result) {
            result = new DefaultCachingStrategy();
        }
        return result;
    }
}

