/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.connectors;

import de.iip_ecosphere.platform.connectors.Connector;
import de.iip_ecosphere.platform.connectors.ConnectorParameter;
import de.iip_ecosphere.platform.connectors.types.ProtocolAdapter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.function.Supplier;
import org.slf4j.LoggerFactory;

public interface ConnectorFactory<O, I, CO, CI, A extends ProtocolAdapter<O, I, CO, CI>> {
    public Connector<O, I, CO, CI> createConnector(ConnectorParameter var1, A ... var2);

    public static boolean hasService(ConnectorParameter params) {
        return null != params && params.getService() != null;
    }

    public static boolean hasVersion(ConnectorParameter params) {
        return ConnectorFactory.hasService(params) && params.getService().getVersion() != null && params.getService().getVersion().getSegmentCount() > 0;
    }

    @SafeVarargs
    public static <O, I, CO, CI, A extends ProtocolAdapter<O, I, CO, CI>> Connector<O, I, CO, CI> createConnector(String cls, Supplier<ConnectorParameter> params, A ... adapter) {
        Connector result = null;
        try {
            Class<?> fClass = Class.forName(cls);
            if (ConnectorFactory.class.isAssignableFrom(fClass)) {
                ConnectorFactory factory = (ConnectorFactory)fClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                result = factory.createConnector(params.get(), (ProtocolAdapter[])adapter);
            } else if (Connector.class.isAssignableFrom(fClass)) {
                Constructor<?> cons = null;
                for (Constructor<?> c : fClass.getDeclaredConstructors()) {
                    Class<?> p;
                    if (1 != c.getParameterCount() || !(p = c.getParameters()[0].getType()).isArray()) continue;
                    cons = c;
                }
                if (null == cons) {
                    throw new NoSuchMethodException();
                }
                result = (Connector)cons.newInstance(new Object[]{adapter});
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            LoggerFactory.getLogger(ConnectorFactory.class).error("Cannot create connector/factory {}: {}", (Object)cls, (Object)e.getMessage());
        }
        return result;
    }
}

