/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.connectors;

import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.identities.IdentityToken;
import de.iip_ecosphere.platform.support.iip_aas.NameplateSetup;
import java.util.Map;

public class ConnectorParameter {
    public static final String ANY_ENDPOINT = "";
    public static final Schema DEFAULT_SCHEMA = Schema.TCP;
    public static final int DEFAULT_REQUEST_TIMEOUT = 5000;
    public static final int DEFAULT_NOTIFICATION_INTERVAL = 1000;
    public static final int DEFAULT_KEEP_ALIVE = 2000;
    private Map<String, IdentityToken> identityToken;
    private Schema schema = DEFAULT_SCHEMA;
    private int port;
    private String host;
    private int requestTimeout = 5000;
    private String endpointPath = "";
    private String applicationId = "";
    private boolean autoApplicationId = true;
    private String applicationDescription = "";
    private int notificationInterval = 1000;
    private int keepAlive = 2000;
    private String keystoreKey;
    private String keyAlias;
    private boolean hostnameVerification = false;
    private CacheMode cacheMode = CacheMode.NONE;
    private NameplateSetup.Service service;

    private ConnectorParameter(String host, int port) {
        this.port = port;
        this.host = host;
    }

    public IdentityToken getIdentityToken(String endpointUrl) {
        IdentityToken token = null;
        if (null != this.identityToken && null == (token = this.identityToken.get(endpointUrl))) {
            token = this.identityToken.get(ANY_ENDPOINT);
        }
        return token;
    }

    public boolean isAnonymousIdentity() {
        return null == this.identityToken;
    }

    public boolean isFeasibleEndpoint(String endpointUrl, byte securityLevel) {
        return true;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public int getPort() {
        return this.port;
    }

    public String getHost() {
        return this.host;
    }

    public String getEndpointPath() {
        return this.endpointPath;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public String getApplicationDescription() {
        return this.applicationDescription;
    }

    public int getRequestTimeout() {
        return this.requestTimeout;
    }

    public int getNotificationInterval() {
        return this.notificationInterval;
    }

    public int getKeepAlive() {
        return this.keepAlive;
    }

    public boolean getAutoApplicationId() {
        return this.autoApplicationId;
    }

    public String getKeystoreKey() {
        return this.keystoreKey;
    }

    public String getKeyAlias() {
        return this.keyAlias;
    }

    public boolean getHostnameVerification() {
        return this.hostnameVerification;
    }

    public CacheMode getCacheMode() {
        return this.cacheMode;
    }

    public NameplateSetup.Service getService() {
        return this.service;
    }

    public static class ConnectorParameterBuilder {
        private ConnectorParameter instance;

        private ConnectorParameterBuilder() {
        }

        public static ConnectorParameterBuilder newBuilder(String host, int port) {
            return ConnectorParameterBuilder.newBuilder(host, port, null);
        }

        public static ConnectorParameterBuilder newBuilder(String host, int port, Schema schema) {
            ConnectorParameterBuilder builder = new ConnectorParameterBuilder();
            builder.instance = new ConnectorParameter(host, port);
            if (null != schema) {
                builder.instance.schema = schema;
            }
            return builder;
        }

        public static ConnectorParameterBuilder newBuilder(ServerAddress addr) {
            return ConnectorParameterBuilder.newBuilder(addr.getHost(), addr.getPort(), addr.getSchema());
        }

        public ConnectorParameterBuilder setService(NameplateSetup.Service service) {
            this.instance.service = service;
            return this;
        }

        public ConnectorParameterBuilder setEndpointPath(String endpointPath) {
            this.instance.endpointPath = endpointPath;
            return this;
        }

        public ConnectorParameterBuilder setRequestTimeout(int requestTimeout) {
            this.instance.requestTimeout = requestTimeout;
            return this;
        }

        public ConnectorParameterBuilder setKeepAlive(int keepAlive) {
            this.instance.keepAlive = keepAlive;
            return this;
        }

        public ConnectorParameterBuilder setNotificationInterval(int notificationInterval) {
            this.instance.notificationInterval = notificationInterval;
            return this;
        }

        public ConnectorParameterBuilder setApplicationInformation(String applicationId, String applicationDescription) {
            this.instance.applicationId = applicationId;
            this.instance.applicationDescription = applicationDescription;
            return this;
        }

        public ConnectorParameterBuilder setAutoApplicationId(boolean autoApplicationId) {
            this.instance.autoApplicationId = autoApplicationId;
            return this;
        }

        public ConnectorParameterBuilder setIdentities(Map<String, IdentityToken> identityToken) {
            this.instance.identityToken = identityToken;
            return this;
        }

        public ConnectorParameterBuilder setKeystoreKey(String keystoreKey) {
            this.instance.keystoreKey = keystoreKey;
            return this;
        }

        public ConnectorParameterBuilder setKeyAlias(String alias) {
            this.instance.keyAlias = alias;
            return this;
        }

        public ConnectorParameterBuilder setHostnameVerification(boolean hostnameVerification) {
            this.instance.hostnameVerification = hostnameVerification;
            return this;
        }

        public ConnectorParameterBuilder setCacheMode(CacheMode cacheMode) {
            if (null != cacheMode) {
                this.instance.cacheMode = cacheMode;
            }
            return this;
        }

        public ConnectorParameter build() {
            return this.instance;
        }
    }

    public static enum CacheMode {
        NONE,
        HASH,
        EQUALS;

    }
}

