/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.connectors;

import de.iip_ecosphere.platform.connectors.CachingStrategy;
import de.iip_ecosphere.platform.connectors.ConnectorParameter;
import java.util.Map;

public class DefaultCachingStrategy
implements CachingStrategy {
    private Object singleCache;
    private Map<String, Object> cache;
    private ConnectorParameter.CacheMode mode = ConnectorParameter.CacheMode.NONE;

    @Override
    public void setCacheMode(ConnectorParameter.CacheMode mode) {
        if (null != mode) {
            this.mode = mode;
        }
    }

    @Override
    public boolean checkCache(Object data) {
        boolean send;
        block7: {
            block6: {
                send = false;
                if (null == data) break block6;
                switch (this.mode) {
                    case HASH: {
                        if (null == this.singleCache || this.singleCache.hashCode() != data.hashCode()) {
                            send = true;
                            this.singleCache = data;
                            break;
                        }
                        break block7;
                    }
                    case EQUALS: {
                        if (null == this.singleCache || !this.singleCache.equals(data)) {
                            send = true;
                            this.singleCache = data;
                            break;
                        }
                        break block7;
                    }
                    default: {
                        send = true;
                        break;
                    }
                }
                break block7;
            }
            send = true;
        }
        return send;
    }

    @Override
    public boolean checkCache(String key, Object data) {
        boolean send = false;
        switch (this.mode) {
            case HASH: {
                send = this.checkCache(key, data, (o1, o2) -> o1.hashCode() == o2.hashCode());
                break;
            }
            case EQUALS: {
                send = this.checkCache(key, data, (o1, o2) -> o1.equals(o2));
                break;
            }
            default: {
                send = true;
            }
        }
        return send;
    }

    private boolean checkCache(String key, Object data, ConsideredSame same) {
        boolean send = true;
        Object o = this.cache.get(key);
        if (null != o) {
            if (!same.isSame(data, o)) {
                this.cache.put(key, data);
            } else {
                send = false;
            }
        } else {
            this.cache.put(key, data);
        }
        return send;
    }

    @Override
    public void clearCache() {
        this.singleCache = null;
        this.cache.clear();
    }

    protected static interface ConsideredSame {
        public boolean isSame(Object var1, Object var2);
    }
}

