/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.connectors.formatter;

import de.iip_ecosphere.platform.connectors.formatter.DummyFormatter;
import de.iip_ecosphere.platform.connectors.formatter.OutputFormatter;
import de.iip_ecosphere.platform.support.ClassLoaderUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.slf4j.LoggerFactory;

public class FormatterUtils {
    public static OutputFormatter<?> createInstance(ClassLoader loader, String className, String charset) {
        OutputFormatter result = null;
        try {
            Class<?> parserClass = loader.loadClass(className);
            Object instance = null;
            try {
                Constructor<?> cons = parserClass.getConstructor(String.class);
                instance = cons.newInstance(charset);
            }
            catch (NoSuchMethodException cons) {
            }
            catch (InvocationTargetException e) {
                LoggerFactory.getLogger(FormatterUtils.class).error("While instantiating " + className + ": " + e.getMessage() + ", falling back to default constructor");
            }
            if (null == instance) {
                instance = parserClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            result = instance;
        }
        catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            String loaders = ClassLoaderUtils.hierarchyToString((ClassLoader)loader);
            LoggerFactory.getLogger(FormatterUtils.class).error("Cannot instantiate formatter of type '" + className + " via " + loaders + "': " + e.getClass().getSimpleName() + " " + e.getMessage());
        }
        if (null == result) {
            LoggerFactory.getLogger(FormatterUtils.class).warn("No formatter instance created. Using " + DummyFormatter.class.getName() + " as fallback");
            result = new DummyFormatter();
        }
        return result;
    }
}

