/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.connectors.parser;

import de.iip_ecosphere.platform.connectors.parser.ArrayParseResult;
import de.iip_ecosphere.platform.connectors.parser.ConverterFromString;
import de.iip_ecosphere.platform.connectors.parser.InputParser;
import de.iip_ecosphere.platform.connectors.parser.MachineParser;
import java.io.IOException;

@MachineParser(supportsHierarchicalNames=false)
public class TextLineParser
implements InputParser<String> {
    public static final TextLineParserConverter CONVERTER = new TextLineParserConverter();
    private String charset;
    private String separator;

    public TextLineParser(String charset, String separator) {
        this.charset = charset;
        this.separator = separator;
    }

    public TextLineParseResult parse(byte[] data) throws IOException {
        String s = new String(data, this.charset);
        return new TextLineParseResult(s.split(this.separator));
    }

    public TextLineParserConverter getConverter() {
        return CONVERTER;
    }

    public static class TextLineParseResult
    extends ArrayParseResult {
        protected TextLineParseResult(String[] data) {
            super(data);
        }

        protected TextLineParseResult(String[] data, int baseIndex, ArrayParseResult parent) {
            super(data, baseIndex, parent);
        }

        @Override
        public TextLineParseResult stepInto(String name, int index) {
            return new TextLineParseResult(this.getData(), index, this);
        }

        @Override
        public TextLineParseResult stepOut() {
            return (TextLineParseResult)super.stepOut();
        }
    }

    public static class TextLineParserConverter
    extends ConverterFromString {
    }
}

