/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.deviceMgt.minio;

import de.iip_ecosphere.platform.deviceMgt.minio.S3PackageStorage;
import io.minio.GetPresignedObjectUrlArgs;
import io.minio.ListObjectsArgs;
import io.minio.MinioClient;
import io.minio.Result;
import io.minio.http.Method;
import io.minio.messages.Contents;
import io.minio.messages.Item;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class S3PackageStorageTest {
    public static final String A_BUCKET = "abucket";
    public static final String PREFIX = "prefix/";
    public static final String A_PATH = "prefix/A_PATH";
    private static final String PACKAGE_NAME = "packageName.zip";
    public static final String PACKAGE_PATH = "prefix/A_PATH/packageName.zip";
    private static final String PACKAGE_DESCRIPTOR = "packageDescriptor.yml";

    @Test
    public void getPrefix_shouldBeSetToPrefix() {
        S3PackageStorage storage = new S3PackageStorage(null, null, PREFIX, null, null);
        Assert.assertEquals((Object)PREFIX, (Object)storage.getPrefix());
    }

    @Test
    public void list_withMixedContent_onlyListsPackages() {
        Set<String> listing = this.validPackageListing();
        listing.add("prefix/jkl/wrong-file.yml");
        MinioClient mc = (MinioClient)Mockito.mock(MinioClient.class);
        Mockito.when((Object)mc.listObjects((ListObjectsArgs)ArgumentMatchers.any())).thenReturn(this.setToResultIterable(listing));
        S3PackageStorage storage = new S3PackageStorage(mc, A_BUCKET, PREFIX, PACKAGE_DESCRIPTOR, PACKAGE_NAME);
        Assert.assertEquals(this.validPackageReducedListing(), (Object)storage.list());
    }

    @Test
    public void getDownloadUrl_withValidUrl_returnsUrl() throws Exception {
        MinioClient mc = (MinioClient)Mockito.mock(MinioClient.class);
        ArgumentCaptor requestCaptor = ArgumentCaptor.forClass(GetPresignedObjectUrlArgs.class);
        Mockito.when((Object)mc.getPresignedObjectUrl((GetPresignedObjectUrlArgs)ArgumentMatchers.any())).thenReturn((Object)PACKAGE_PATH);
        S3PackageStorage storage = new S3PackageStorage(mc, A_BUCKET, PREFIX, PACKAGE_DESCRIPTOR, PACKAGE_NAME);
        String downloadUrl = storage.generateDownloadUrl("A_PATH");
        ((MinioClient)Mockito.verify((Object)mc)).getPresignedObjectUrl((GetPresignedObjectUrlArgs)requestCaptor.capture());
        GetPresignedObjectUrlArgs request = (GetPresignedObjectUrlArgs)requestCaptor.getValue();
        Assert.assertEquals((Object)PACKAGE_PATH, (Object)request.object());
        Assert.assertEquals((Object)Method.GET, (Object)request.method());
        Assert.assertEquals((Object)PACKAGE_PATH, (Object)downloadUrl);
    }

    private Iterable<Result<Item>> setToResultIterable(Set<String> objects) {
        return objects.stream().map(o -> new Result((Object)new Contents(o))).collect(Collectors.toSet());
    }

    private Set<String> validPackageListing() {
        HashSet<String> listing = new HashSet<String>();
        listing.add("prefix/abc/packageDescriptor.yml");
        listing.add("prefix/abc/packageName.zip");
        listing.add("prefix/def/packageDescriptor.yml");
        listing.add("prefix/def/packageName.zip");
        listing.add("prefix/ghi/packageDescriptor.yml");
        listing.add("prefix/ghi/packageName.zip");
        return listing;
    }

    private Set<String> validPackageReducedListing() {
        HashSet<String> listing = new HashSet<String>();
        listing.add("prefix/abc");
        listing.add("prefix/def");
        listing.add("prefix/ghi");
        return listing;
    }
}

