/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.deviceMgt.minio;

import de.iip_ecosphere.platform.deviceMgt.minio.S3Storage;
import io.minio.GetPresignedObjectUrlArgs;
import io.minio.ListObjectsArgs;
import io.minio.MinioClient;
import io.minio.ObjectWriteResponse;
import io.minio.Result;
import io.minio.UploadObjectArgs;
import io.minio.errors.ErrorResponseException;
import io.minio.errors.InsufficientDataException;
import io.minio.errors.InternalException;
import io.minio.errors.InvalidResponseException;
import io.minio.errors.ServerException;
import io.minio.errors.XmlParserException;
import io.minio.http.Method;
import io.minio.messages.Contents;
import java.io.File;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class S3StorageTest {
    public static final String A_BUCKET = "abucket";
    public static final String A_PREFIX = "A_PREFIX";
    public static final String A_PATH = "A_PREFIX/A_PATH";
    public static final String AN_URL = "AN_URL";
    public static final String AN_INVALID_PATH = "AN_INVALID_PATH";
    private static final int EXPIRE_TIME = 60;

    @Test
    public void list_shouldAskMinio() {
        MinioClient minioMock = (MinioClient)Mockito.mock(MinioClient.class);
        S3Storage storage = new S3Storage(A_PREFIX, minioMock, A_BUCKET);
        ListObjectsArgs listObjectsArgs = (ListObjectsArgs)((ListObjectsArgs.Builder)ListObjectsArgs.builder().bucket(A_BUCKET)).prefix(A_PREFIX).recursive(true).build();
        Result result = new Result((Object)new Contents(A_PATH));
        Mockito.when((Object)minioMock.listObjects((ListObjectsArgs)ArgumentMatchers.eq((Object)listObjectsArgs))).thenReturn(Collections.singleton(result));
        Set listing = storage.list();
        Assert.assertEquals((long)1L, (long)listing.size());
        Assert.assertEquals((Object)A_PATH, listing.stream().findFirst().get());
    }

    @Test
    public void generateDownloadUrl_shouldAskMinio() throws Exception {
        MinioClient minioMock = (MinioClient)Mockito.mock(MinioClient.class);
        S3Storage storage = new S3Storage(A_PREFIX, minioMock, A_BUCKET);
        GetPresignedObjectUrlArgs getPresignedObjectUrlArgs = (GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().bucket(A_BUCKET)).object(A_PATH)).expiry(60).method(Method.GET).build();
        Mockito.when((Object)minioMock.getPresignedObjectUrl((GetPresignedObjectUrlArgs)ArgumentMatchers.eq((Object)getPresignedObjectUrlArgs))).thenReturn((Object)AN_URL);
        Assert.assertEquals((Object)AN_URL, (Object)storage.generateDownloadUrl(A_PATH));
    }

    @Test
    public void generateDownloadUrl_forInvalidKey_returnsNull() throws Exception {
        MinioClient minioMock = (MinioClient)Mockito.mock(MinioClient.class);
        S3Storage storage = new S3Storage(A_PREFIX, minioMock, A_BUCKET);
        Mockito.when((Object)minioMock.getPresignedObjectUrl((GetPresignedObjectUrlArgs)ArgumentMatchers.any())).thenThrow(new Throwable[]{new InvalidKeyException()});
        Assert.assertNull((Object)storage.generateDownloadUrl(AN_INVALID_PATH));
    }

    @Test
    public void getPrefix_isSet() {
        S3Storage storage = new S3Storage(A_PREFIX, null, null);
        Assert.assertEquals((Object)A_PREFIX, (Object)storage.getPrefix());
    }

    @Test
    public void uploadFile_successful() throws IOException, XmlParserException, ServerException, NoSuchAlgorithmException, IOException, InvalidResponseException, InvalidKeyException, InternalException, InsufficientDataException, ErrorResponseException {
        MinioClient minioMock = (MinioClient)Mockito.mock(MinioClient.class);
        ObjectWriteResponse resp = new ObjectWriteResponse(null, A_BUCKET, "", "", "", "");
        Mockito.when((Object)minioMock.uploadObject((UploadObjectArgs)ArgumentMatchers.any())).thenReturn((Object)resp);
        S3Storage storage = new S3Storage(A_PREFIX, minioMock, A_BUCKET);
        storage.storeFile("upload", new File("./src/test/resources/ExampleUpload.txt"));
    }

    @Test
    public void uploadFile_fileNotFound() throws XmlParserException, ServerException, NoSuchAlgorithmException, IOException, InvalidResponseException, InvalidKeyException, InternalException, InsufficientDataException, ErrorResponseException {
        MinioClient minioMock = (MinioClient)Mockito.mock(MinioClient.class);
        try {
            S3Storage storage = new S3Storage(A_PREFIX, minioMock, A_BUCKET);
            storage.storeFile("uploadFnf", new File("./src/test/resources/ExampleUpload1.txt"));
            Assert.fail((String)"There shall be an IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

