/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.deviceMgt.minio;

import de.iip_ecosphere.platform.deviceMgt.DeviceMgtSetup;
import de.iip_ecosphere.platform.deviceMgt.minio.S3Storage;
import de.iip_ecosphere.platform.deviceMgt.minio.S3StorageFactoryDescriptor;
import de.iip_ecosphere.platform.deviceMgt.storage.PackageStorageSetup;
import de.iip_ecosphere.platform.deviceMgt.storage.Storage;
import de.iip_ecosphere.platform.deviceMgt.storage.StorageFactory;
import de.iip_ecosphere.platform.deviceMgt.storage.StorageFactoryDescriptor;
import de.iip_ecosphere.platform.support.jsl.ServiceLoaderUtils;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

public class StorageFactoryDescriptorTest {
    private DeviceMgtSetup configuration;

    @Before
    public void setUp() {
        this.configuration = new DeviceMgtSetup();
        PackageStorageSetup packageStorageSetup = new PackageStorageSetup();
        packageStorageSetup.setEndpoint("endpoint");
        packageStorageSetup.setRegion("us-west-2");
        packageStorageSetup.setBucket("bucket");
        packageStorageSetup.setAccessKey("access_key");
        packageStorageSetup.setSecretAccessKey("secret_access_key");
        packageStorageSetup.setPackageDescriptor("runtime.yml");
        packageStorageSetup.setPackageFilename("runtime.zip");
        packageStorageSetup.setPrefix("runtimes/");
        this.configuration.setRuntimeStorage(packageStorageSetup);
        PackageStorageSetup configsStorageSetup = new PackageStorageSetup();
        configsStorageSetup.setEndpoint("endpoint");
        configsStorageSetup.setRegion("us-west-2");
        configsStorageSetup.setBucket("bucket");
        configsStorageSetup.setAccessKey("access_key");
        configsStorageSetup.setSecretAccessKey("secret_access_key");
        configsStorageSetup.setPackageDescriptor("config.yml");
        configsStorageSetup.setPackageFilename("config.zip");
        configsStorageSetup.setPrefix("configs/");
        this.configuration.setConfigStorage(configsStorageSetup);
    }

    @Test
    public void createRuntimeStorage_withConfiguration_createsStorage() {
        S3StorageFactoryDescriptor s3StorageFactoryDescriptor = new S3StorageFactoryDescriptor();
        Storage storage = s3StorageFactoryDescriptor.createRuntimeStorage(this.configuration);
        Assert.assertNotNull((Object)storage);
    }

    @Test
    public void createRuntimeStorage_withInvalidConfiguration_returnsNull() {
        S3StorageFactoryDescriptor s3StorageFactoryDescriptor = new S3StorageFactoryDescriptor();
        Storage storage = s3StorageFactoryDescriptor.createRuntimeStorage(null);
        Assert.assertNull((Object)storage);
    }

    @Test
    public void createRuntimeStorage_withServiceProvider_usesServiceProvider() {
        MockedStatic serviceLoaderMock = Mockito.mockStatic(ServiceLoaderUtils.class);
        StorageFactoryDescriptor storageFactoryDescriptor = (StorageFactoryDescriptor)Mockito.mock(StorageFactoryDescriptor.class);
        S3Storage storage = new S3Storage(null, null, null);
        Mockito.when((Object)storageFactoryDescriptor.createPackageStorage((PackageStorageSetup)ArgumentMatchers.any())).thenReturn((Object)storage);
        serviceLoaderMock.when(() -> ServiceLoaderUtils.findFirst(StorageFactoryDescriptor.class)).thenReturn(Optional.of(storageFactoryDescriptor));
        StorageFactory storageFactory = new StorageFactory();
        Storage runtimeStorage = storageFactory.createRuntimeStorage();
        Assert.assertEquals((Object)storage, (Object)runtimeStorage);
        serviceLoaderMock.close();
    }

    @Test
    public void createStorages_withoutServiceProvider_isJSL() {
        StorageFactory storageFactory = new StorageFactory();
        storageFactory.setSetup(this.configuration);
        Storage runtimeStorage = storageFactory.createRuntimeStorage();
        Storage configStorage = storageFactory.createConfigStorage();
        Assert.assertTrue((boolean)(runtimeStorage instanceof S3Storage));
        Assert.assertTrue((boolean)(configStorage instanceof S3Storage));
    }
}

