/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.deviceMgt.minio;

import de.iip_ecosphere.platform.deviceMgt.minio.S3Storage;
import io.minio.MinioClient;
import java.util.Set;
import java.util.stream.Collectors;

public class S3PackageStorage
extends S3Storage {
    private final String packageDescriptor;
    private final String packageFilename;

    public S3PackageStorage(MinioClient minioClient, String bucket, String prefix, String packageDescriptor, String packageFilename) {
        super(prefix, minioClient, bucket);
        this.packageDescriptor = packageDescriptor;
        this.packageFilename = packageFilename;
    }

    @Override
    public Set<String> list() {
        return super.list().stream().filter(key -> key.endsWith(this.packageDescriptor)).map(key -> key.replace("/" + this.packageDescriptor, "")).collect(Collectors.toSet());
    }

    @Override
    public String generateDownloadUrl(String packageName) {
        String key = this.getPrefix() + packageName + "/" + this.packageFilename;
        return super.generateDownloadUrl(key);
    }
}

