/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.deviceMgt.minio;

import de.iip_ecosphere.platform.deviceMgt.storage.Storage;
import io.minio.GetPresignedObjectUrlArgs;
import io.minio.ListObjectsArgs;
import io.minio.MinioClient;
import io.minio.UploadObjectArgs;
import io.minio.errors.ErrorResponseException;
import io.minio.errors.InsufficientDataException;
import io.minio.errors.InternalException;
import io.minio.errors.InvalidResponseException;
import io.minio.errors.ServerException;
import io.minio.errors.XmlParserException;
import io.minio.http.Method;
import io.minio.messages.Item;
import java.io.File;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.slf4j.LoggerFactory;

public class S3Storage
implements Storage {
    private String prefix;
    private MinioClient minioClient;
    private String bucket;

    public S3Storage(String prefix, MinioClient minioClient, String bucket) {
        this.prefix = prefix;
        this.minioClient = minioClient;
        this.bucket = bucket;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public Set<String> list() {
        return StreamSupport.stream(this.minioClient.listObjects((ListObjectsArgs)((ListObjectsArgs.Builder)ListObjectsArgs.builder().bucket(this.bucket)).prefix(this.prefix).recursive(true).build()).spliterator(), false).map(r -> {
            try {
                return ((Item)r.get()).objectName();
            }
            catch (ErrorResponseException | InsufficientDataException | InternalException | InvalidResponseException | ServerException | XmlParserException | IOException | InvalidKeyException | NoSuchAlgorithmException e) {
                e.printStackTrace();
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public String generateDownloadUrl(String key) {
        try {
            return this.minioClient.getPresignedObjectUrl((GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().object(key)).bucket(this.bucket)).method(Method.GET).expiry(60).build());
        }
        catch (ErrorResponseException | InsufficientDataException | InternalException | InvalidResponseException | ServerException | XmlParserException | IOException | InvalidKeyException | NoSuchAlgorithmException e) {
            LoggerFactory.getLogger(this.getClass()).error(e.getClass().getSimpleName() + " " + e.getMessage());
            return null;
        }
    }

    public void storeFile(String key, File file) throws IOException {
        try {
            this.minioClient.uploadObject((UploadObjectArgs)((UploadObjectArgs.Builder)((UploadObjectArgs.Builder)UploadObjectArgs.builder().object(key)).bucket(this.bucket)).filename(file.getAbsolutePath()).build());
        }
        catch (ErrorResponseException | InsufficientDataException | InternalException | InvalidResponseException | ServerException | XmlParserException | IllegalArgumentException | InvalidKeyException | NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
    }
}

