/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.deviceMgt.minio;

import de.iip_ecosphere.platform.deviceMgt.DeviceMgtSetup;
import de.iip_ecosphere.platform.deviceMgt.minio.S3PackageStorage;
import de.iip_ecosphere.platform.deviceMgt.storage.PackageStorageSetup;
import de.iip_ecosphere.platform.deviceMgt.storage.Storage;
import de.iip_ecosphere.platform.deviceMgt.storage.StorageFactoryDescriptor;
import io.minio.MinioClient;

public class S3StorageFactoryDescriptor
implements StorageFactoryDescriptor {
    public Storage createRuntimeStorage(DeviceMgtSetup configuration) {
        if (null == configuration) {
            return null;
        }
        return this.createPackageStorage(configuration.getRuntimeStorage());
    }

    public Storage createConfigStorage(DeviceMgtSetup configuration) {
        if (null == configuration) {
            return null;
        }
        return this.createPackageStorage(configuration.getConfigStorage());
    }

    public Storage createPackageStorage(PackageStorageSetup storageSetup) {
        if (null == storageSetup) {
            return null;
        }
        MinioClient minioClient = MinioClient.builder().endpoint(storageSetup.getEndpoint()).region(storageSetup.getRegion()).credentials(storageSetup.getAccessKey(), storageSetup.getSecretAccessKey()).build();
        return new S3PackageStorage(minioClient, storageSetup.getBucket(), storageSetup.getPrefix(), storageSetup.getPackageDescriptor(), storageSetup.getPackageFilename());
    }
}

