package org.eclipse.basyx.components.aas.executable;

import java.io.File;
import java.net.URISyntaxException;

import org.eclipse.basyx.components.aas.AASServerComponent;
import org.eclipse.basyx.components.aas.configuration.AASEventBackend;
import org.eclipse.basyx.components.aas.configuration.BaSyxAASServerConfiguration;
import org.eclipse.basyx.components.configuration.BaSyxContextConfiguration;
import org.eclipse.basyx.components.configuration.BaSyxMqttConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Starts an HTTP server that is able to receive AAS and submodels pushed from
 * remote <br />
 * They are made available at
 * <i>localhost:4000/aasServer/shells/${aasId}/aas</i>. Submodels are available
 * at
 * <i>localhost:4000/aasServer/shells/${aasId}/submodels/${submodelId}/submodel</i><br
 * />
 * 
 * @author schnicke, espen
 */
public class AASServerExecutable {
	// Creates a Logger based on the current class
	private static Logger logger = LoggerFactory.getLogger(AASServerExecutable.class);

	public static void main(String[] args) throws URISyntaxException {
		logger.info("Starting BaSyx AASServer component...");
		// Load context configuration
		BaSyxContextConfiguration contextConfig = new BaSyxContextConfiguration();
		contextConfig.loadFromDefaultSource();

		// Load aas configuration
		BaSyxAASServerConfiguration aasConfig = new BaSyxAASServerConfiguration();
		aasConfig.loadFromDefaultSource();

		// Load the additional file path relative to the executed jar file
		String rootPath = new File(AASServerExecutable.class.getProtectionDomain().getCodeSource().getLocation().toURI()).getParentFile().getPath();
		String docBasePath = rootPath;
		contextConfig.setDocBasePath(docBasePath);

		AASServerComponent component = new AASServerComponent(contextConfig, aasConfig);

		// If enabled, load mqtt configuration
		if (aasConfig.getAASEvents().equals(AASEventBackend.MQTT)) {
			BaSyxMqttConfiguration mqttConfig = new BaSyxMqttConfiguration();
			mqttConfig.loadFromDefaultSource();
			component.enableMQTT(mqttConfig);
		}

		component.startComponent();

		logger.info("BaSyx AAS Server component started");
	}
}
