/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.aas;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServlet;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.catalina.servlets.DefaultServlet;
import org.eclipse.basyx.aas.aggregator.AASAggregator;
import org.eclipse.basyx.aas.aggregator.api.IAASAggregator;
import org.eclipse.basyx.aas.metamodel.map.descriptor.AASDescriptor;
import org.eclipse.basyx.aas.registration.api.IAASRegistryService;
import org.eclipse.basyx.aas.registration.proxy.AASRegistryProxy;
import org.eclipse.basyx.aas.restapi.VABAASAPIFactory;
import org.eclipse.basyx.aas.restapi.api.IAASAPIFactory;
import org.eclipse.basyx.components.IComponent;
import org.eclipse.basyx.components.aas.aasx.AASXPackageManager;
import org.eclipse.basyx.components.aas.aasx.SubmodelFileEndpointLoader;
import org.eclipse.basyx.components.aas.configuration.AASServerBackend;
import org.eclipse.basyx.components.aas.configuration.BaSyxAASServerConfiguration;
import org.eclipse.basyx.components.aas.mongodb.MongoDBAASAggregator;
import org.eclipse.basyx.components.aas.mqtt.MqttSubmodelAPIFactory;
import org.eclipse.basyx.components.aas.servlet.AASAggregatorServlet;
import org.eclipse.basyx.components.configuration.BaSyxConfiguration;
import org.eclipse.basyx.components.configuration.BaSyxContextConfiguration;
import org.eclipse.basyx.components.configuration.BaSyxMongoDBConfiguration;
import org.eclipse.basyx.components.configuration.BaSyxMqttConfiguration;
import org.eclipse.basyx.components.json.JSONAASBundleFactory;
import org.eclipse.basyx.components.xml.XMLAASBundleFactory;
import org.eclipse.basyx.submodel.metamodel.api.ISubModel;
import org.eclipse.basyx.submodel.restapi.api.ISubmodelAPIFactory;
import org.eclipse.basyx.support.bundle.AASBundle;
import org.eclipse.basyx.support.bundle.AASBundleDescriptorFactory;
import org.eclipse.basyx.support.bundle.AASBundleIntegrator;
import org.eclipse.basyx.vab.protocol.http.server.AASHTTPServer;
import org.eclipse.basyx.vab.protocol.http.server.BaSyxContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class AASServerComponent
implements IComponent {
    private static Logger logger = LoggerFactory.getLogger(AASServerComponent.class);
    private AASHTTPServer server;
    private IAASRegistryService registry;
    private BaSyxContextConfiguration contextConfig;
    private BaSyxAASServerConfiguration aasConfig;
    private BaSyxMongoDBConfiguration mongoDBConfig;
    private BaSyxMqttConfiguration mqttConfig;
    protected Collection<AASBundle> aasBundles;

    public AASServerComponent(BaSyxContextConfiguration contextConfig) {
        this.contextConfig = contextConfig;
        this.aasConfig = new BaSyxAASServerConfiguration();
    }

    public AASServerComponent(BaSyxContextConfiguration contextConfig, BaSyxAASServerConfiguration aasConfig) {
        this.contextConfig = contextConfig;
        this.aasConfig = aasConfig;
    }

    public AASServerComponent(BaSyxContextConfiguration contextConfig, BaSyxAASServerConfiguration aasConfig, BaSyxMongoDBConfiguration mongoDBConfig) {
        this.contextConfig = contextConfig;
        this.aasConfig = aasConfig;
        this.aasConfig.setAASBackend(AASServerBackend.MONGODB);
        this.mongoDBConfig = mongoDBConfig;
    }

    public void enableMQTT(BaSyxMqttConfiguration configuration) {
        this.mqttConfig = configuration;
    }

    public void disableMQTT() {
        this.mqttConfig = null;
    }

    public void setRegistry(IAASRegistryService registry) {
        this.registry = registry;
    }

    public void startComponent() {
        logger.info("Create the server...");
        this.createRegistryFromUrl();
        AASAggregatorServlet aggregatorServlet = this.loadAggregatorServlet();
        BaSyxContext context = this.contextConfig.createBaSyxContext();
        context.addServletMapping("/*", (HttpServlet)aggregatorServlet);
        if (this.aasBundles != null) {
            context.addServletMapping("/files/*", (HttpServlet)new DefaultServlet());
            this.modifyFilePaths(this.contextConfig.getHostname(), this.contextConfig.getPort(), this.contextConfig.getContextPath());
            this.registerAAS();
        }
        logger.info("Start the server");
        this.server = new AASHTTPServer(context);
        this.server.start();
    }

    public String getURL() {
        return this.contextConfig.getUrl();
    }

    public void stopComponent() {
        this.server.shutdown();
    }

    private void loadBundleFromXML(String xmlPath) throws IOException, ParserConfigurationException, SAXException {
        logger.info("Loading aas from xml \"" + xmlPath + "\"");
        String xmlContent = BaSyxConfiguration.getResourceString((String)xmlPath);
        this.aasBundles = new XMLAASBundleFactory(xmlContent).create();
    }

    private void loadBundleFromJSON(String jsonPath) throws IOException, ParserConfigurationException, SAXException {
        logger.info("Loading aas from json \"" + jsonPath + "\"");
        String jsonContent = BaSyxConfiguration.getResourceString((String)jsonPath);
        this.aasBundles = new JSONAASBundleFactory(jsonContent).create();
    }

    private void loadBundleFromAASX(String aasxPath) throws IOException, ParserConfigurationException, SAXException, URISyntaxException {
        logger.info("Loading aas from aasx \"" + aasxPath + "\"");
        AASXPackageManager packageManager = new AASXPackageManager(aasxPath);
        packageManager.unzipRelatedFiles();
        this.aasBundles = packageManager.retrieveAASBundles();
    }

    private AASAggregatorServlet loadAggregatorServlet() {
        this.loadAASFromSource(this.aasConfig.getAASSource());
        IAASAggregator aggregator = this.loadAASAggregator();
        if (this.aasBundles != null) {
            AASBundleIntegrator.integrate((IAASAggregator)aggregator, this.aasBundles);
        }
        return new AASAggregatorServlet(aggregator);
    }

    private void loadAASFromSource(String aasSource) {
        if (aasSource.isEmpty()) {
            return;
        }
        try {
            if (aasSource.endsWith(".aasx")) {
                this.loadBundleFromAASX(aasSource);
            } else if (aasSource.endsWith(".json")) {
                this.loadBundleFromJSON(aasSource);
            } else if (aasSource.endsWith(".xml")) {
                this.loadBundleFromXML(aasSource);
            }
        }
        catch (IOException | URISyntaxException | ParserConfigurationException | SAXException e) {
            logger.error("Could not load initial AAS from source " + aasSource);
            e.printStackTrace();
        }
    }

    private void createRegistryFromUrl() {
        if (this.registry != null) {
            return;
        }
        String registryUrl = this.aasConfig.getRegistry();
        if (registryUrl != null && !registryUrl.isEmpty()) {
            this.registry = new AASRegistryProxy(registryUrl);
            logger.info("Registry loaded at \"" + registryUrl + "\"");
        }
    }

    private void registerAAS() {
        if (this.registry != null) {
            Set<AASDescriptor> descriptors = this.retrieveDescriptors(this.contextConfig.getUrl());
            descriptors.stream().forEach(arg_0 -> ((IAASRegistryService)this.registry).register(arg_0));
        } else {
            logger.info("No registry specified, skipped registration");
        }
    }

    private Set<AASDescriptor> retrieveDescriptors(String hostBasePath) {
        String fullBasePath = hostBasePath + "/" + "shells";
        return this.aasBundles.stream().map(b -> AASBundleDescriptorFactory.createAASDescriptor((AASBundle)b, (String)fullBasePath)).collect(Collectors.toSet());
    }

    private void modifyFilePaths(String hostName, int port, String rootPath) {
        rootPath = rootPath + "/files";
        for (AASBundle bundle : this.aasBundles) {
            Set submodels = bundle.getSubmodels();
            for (ISubModel sm : submodels) {
                SubmodelFileEndpointLoader.setRelativeFileEndpoints(sm, hostName, port, rootPath);
            }
        }
    }

    private IAASAggregator loadAASAggregator() {
        AASServerBackend backendType = this.aasConfig.getAASBackend();
        AASAggregator aggregator = null;
        if (backendType == AASServerBackend.INMEMORY && this.mqttConfig == null) {
            logger.info("Using InMemory backend");
            aggregator = new AASAggregator(this.registry);
        } else if (backendType == AASServerBackend.INMEMORY && this.mqttConfig != null) {
            logger.info("Using InMemory backend with MQTT providers");
            VABAASAPIFactory aasApiProvider = new VABAASAPIFactory();
            MqttSubmodelAPIFactory smApiProvider = new MqttSubmodelAPIFactory(this.mqttConfig);
            aggregator = new AASAggregator((IAASAPIFactory)aasApiProvider, (ISubmodelAPIFactory)smApiProvider, this.registry);
        } else if (backendType == AASServerBackend.MONGODB) {
            logger.info("Using MongoDB backend");
            aggregator = this.loadMongoDBAggregator();
        }
        return aggregator;
    }

    private IAASAggregator loadMongoDBAggregator() {
        BaSyxMongoDBConfiguration config;
        if (this.mongoDBConfig == null) {
            config = new BaSyxMongoDBConfiguration();
            config.loadFromDefaultSource();
        } else {
            config = this.mongoDBConfig;
        }
        MongoDBAASAggregator aggregator = new MongoDBAASAggregator(config);
        aggregator.setRegistry(this.registry);
        return aggregator;
    }
}

