/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.aas.aasx;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.IOUtils;
import org.eclipse.basyx.components.configuration.BaSyxConfiguration;
import org.eclipse.basyx.components.xml.XMLAASBundleFactory;
import org.eclipse.basyx.submodel.metamodel.api.ISubModel;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.ISubmodelElement;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.ISubmodelElementCollection;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.dataelement.IFile;
import org.eclipse.basyx.support.bundle.AASBundle;
import org.eclipse.basyx.vab.modelprovider.VABPathTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class AASXPackageManager {
    private String aasxPath;
    private XMLAASBundleFactory bundleFactory;
    private Set<AASBundle> bundles;
    private static Logger logger = LoggerFactory.getLogger(AASXPackageManager.class);

    public AASXPackageManager(String path) {
        this.aasxPath = path;
    }

    public Set<AASBundle> retrieveAASBundles() throws IOException, ParserConfigurationException, SAXException {
        if (this.bundles != null) {
            return this.bundles;
        }
        this.bundleFactory = new XMLAASBundleFactory(this.getXMLResourceString(this.aasxPath));
        this.bundles = this.bundleFactory.create();
        return this.bundles;
    }

    private String findAASXml(ZipInputStream stream) throws IOException, ParserConfigurationException, SAXException {
        ZipEntry entry;
        String path = "";
        while ((entry = stream.getNextEntry()) != null) {
            String aasXmlPath;
            String name = entry.getName();
            if (entry.isDirectory() || !name.startsWith("aasx/_rels") || !name.endsWith("aasx-origin.rels") || (aasXmlPath = this.findAASXMLAddress(stream)).isEmpty()) continue;
            path = aasXmlPath;
            break;
        }
        return path;
    }

    private ZipInputStream returnFileEntryStream(String filename, ZipInputStream stream) throws IOException {
        ZipEntry e;
        ZipInputStream str = null;
        if (filename.startsWith("/")) {
            filename = filename.substring(1);
        }
        while ((e = stream.getNextEntry()) != null) {
            String name = e.getName();
            if (!name.equals(filename)) continue;
            str = stream;
            break;
        }
        return str;
    }

    private String findAASXMLAddress(InputStream ins) throws ParserConfigurationException, SAXException, IOException {
        Node first;
        String path = "";
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(ins);
        doc.getDocumentElement().normalize();
        logger.info("Root element :" + doc.getDocumentElement().getNodeName());
        NodeList relList = doc.getElementsByTagName("Relationship");
        if (relList.getLength() == 1 && (first = relList.item(0)).getNodeType() == 1) {
            logger.info("\nCurrent Element :" + first.getNodeName());
            String targetFile = ((Element)first).getAttribute("Target");
            String type = ((Element)first).getAttribute("Type");
            if (type.endsWith("aas-spec")) {
                logger.info("target file name : " + targetFile);
                path = targetFile;
            }
        }
        return path;
    }

    private String getXMLResourceString(String filePath) throws IOException, ParserConfigurationException, SAXException {
        String aasXmlPath;
        try (ZipInputStream stream = this.getZipInputStream(filePath);){
            aasXmlPath = this.findAASXml(stream);
        }
        stream = this.getZipInputStream(filePath);
        var4_3 = null;
        try {
            String text;
            ZipInputStream streamPointingToEntry = this.returnFileEntryStream(aasXmlPath, stream);
            String string = text = IOUtils.toString((InputStream)streamPointingToEntry, (String)StandardCharsets.UTF_8.name());
            return string;
        }
        catch (Throwable throwable) {
            var4_3 = throwable;
            throw throwable;
        }
        finally {
            if (stream != null) {
                if (var4_3 != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable) {
                        var4_3.addSuppressed(throwable);
                    }
                } else {
                    stream.close();
                }
            }
        }
    }

    private List<String> parseReferencedFilePathsFromAASX() throws IOException, ParserConfigurationException, SAXException {
        Set<AASBundle> bundles = this.retrieveAASBundles();
        ArrayList submodels = new ArrayList();
        for (AASBundle bundle : bundles) {
            submodels.addAll(bundle.getSubmodels());
        }
        ArrayList<String> paths = new ArrayList<String>();
        for (ISubModel sm : submodels) {
            paths.addAll(this.parseElements(sm.getSubmodelElements().values()));
        }
        return paths;
    }

    private List<String> parseElements(Collection<ISubmodelElement> elements) {
        ArrayList<String> paths = new ArrayList<String>();
        for (ISubmodelElement element : elements) {
            if (element instanceof IFile) {
                IFile file = (IFile)element;
                if (file.getValue().contains("://")) continue;
                paths.add(file.getValue());
                continue;
            }
            if (!(element instanceof ISubmodelElementCollection)) continue;
            ISubmodelElementCollection collection = (ISubmodelElementCollection)element;
            paths.addAll(this.parseElements(collection.getSubmodelElements().values()));
        }
        return paths;
    }

    public void unzipRelatedFiles() throws IOException, ParserConfigurationException, SAXException, URISyntaxException {
        List<String> files = this.parseReferencedFilePathsFromAASX();
        for (String filePath : files) {
            this.unzipFile(filePath, this.aasxPath);
        }
    }

    private Path getRootFolder() throws IOException, URISyntaxException {
        URI uri = AASXPackageManager.class.getProtectionDomain().getCodeSource().getLocation().toURI();
        URI parent = new File(uri).getParentFile().toURI();
        return Paths.get(parent);
    }

    private void unzipFile(String filePath, String aasxPath) throws IOException, URISyntaxException {
        if (filePath.startsWith("/")) {
            filePath = filePath.substring(1);
        }
        logger.info("Unzipping " + filePath + " to root folder:");
        String relativePath = "files/" + VABPathTools.getParentPath((String)filePath);
        Path rootPath = this.getRootFolder();
        Path destDir = rootPath.resolve(relativePath);
        logger.info("Unzipping to " + destDir);
        Files.createDirectories(destDir, new FileAttribute[0]);
        byte[] buffer = new byte[1024];
        try (ZipInputStream stream = this.getZipInputStream(aasxPath);){
            ZipEntry zipEntry = stream.getNextEntry();
            while (zipEntry != null) {
                if (!zipEntry.isDirectory() && zipEntry.getName().contains(filePath)) {
                    File newFile = this.newFile(destDir.toFile(), zipEntry);
                    try (FileOutputStream fos = new FileOutputStream(newFile);){
                        int len;
                        while ((len = stream.read(buffer)) > 0) {
                            fos.write(buffer, 0, len);
                        }
                    }
                    return;
                }
                zipEntry = stream.getNextEntry();
            }
        }
    }

    private File newFile(File destinationDir, ZipEntry zipEntry) throws IOException {
        String filename = VABPathTools.getLastElement((String)zipEntry.getName());
        File destFile = new File(destinationDir, filename);
        String destDirPath = destinationDir.getCanonicalPath();
        String destFilePath = destFile.getCanonicalPath();
        if (!destFilePath.startsWith(destDirPath + File.separator)) {
            throw new IOException("Entry is outside of the target dir: " + zipEntry.getName());
        }
        return destFile;
    }

    private ZipInputStream getZipInputStream(String aasxFilePath) throws IOException {
        try {
            return new ZipInputStream(BaSyxConfiguration.getResourceStream((String)aasxFilePath));
        }
        catch (NullPointerException ex) {
            return new ZipInputStream(new FileInputStream(aasxFilePath));
        }
    }
}

