/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.aas.configuration;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.basyx.components.aas.configuration.AASEventBackend;
import org.eclipse.basyx.components.aas.configuration.AASServerBackend;
import org.eclipse.basyx.components.configuration.BaSyxConfiguration;

public class BaSyxAASServerConfiguration
extends BaSyxConfiguration {
    public static final String DEFAULT_BACKEND = AASServerBackend.INMEMORY.toString();
    public static final String DEFAULT_SOURCE = "";
    public static final String DEFAULT_REGISTRY = "";
    public static final String DEFAULT_EVENTS = AASEventBackend.NONE.toString();
    public static final String REGISTRY = "registry.path";
    public static final String BACKEND = "aas.backend";
    public static final String SOURCE = "aas.source";
    public static final String EVENTS = "aas.events";
    public static final String DEFAULT_CONFIG_PATH = "aas.properties";
    public static final String DEFAULT_FILE_KEY = "BASYX_AAS";

    public static Map<String, String> getDefaultProperties() {
        HashMap<String, String> defaultProps = new HashMap<String, String>();
        defaultProps.put(BACKEND, DEFAULT_BACKEND);
        defaultProps.put(SOURCE, "");
        defaultProps.put(REGISTRY, "");
        defaultProps.put(EVENTS, DEFAULT_EVENTS);
        return defaultProps;
    }

    public BaSyxAASServerConfiguration() {
        super(BaSyxAASServerConfiguration.getDefaultProperties());
    }

    public BaSyxAASServerConfiguration(AASServerBackend backend, String source) {
        super(BaSyxAASServerConfiguration.getDefaultProperties());
        this.setAASBackend(backend);
        this.setAASSource(source);
    }

    public BaSyxAASServerConfiguration(AASServerBackend backend, String source, String registryUrl) {
        super(BaSyxAASServerConfiguration.getDefaultProperties());
        this.setAASBackend(backend);
        this.setAASSource(source);
        this.setRegistry(registryUrl);
    }

    public BaSyxAASServerConfiguration(Map<String, String> values) {
        super(values);
    }

    public void loadFromDefaultSource() {
        this.loadFileOrDefaultResource(DEFAULT_FILE_KEY, DEFAULT_CONFIG_PATH);
    }

    public AASServerBackend getAASBackend() {
        return AASServerBackend.fromString(this.getProperty(BACKEND));
    }

    public void setAASBackend(AASServerBackend backend) {
        this.setProperty(BACKEND, backend.toString());
    }

    public AASEventBackend getAASEvents() {
        return AASEventBackend.fromString(this.getProperty(EVENTS));
    }

    public void setAASEvents(AASEventBackend events) {
        this.setProperty(EVENTS, events.toString());
    }

    public String getAASSource() {
        return this.getProperty(SOURCE);
    }

    public void setAASSource(String source) {
        this.setProperty(SOURCE, source);
    }

    public String getRegistry() {
        return this.getProperty(REGISTRY);
    }

    public void setRegistry(String registryPath) {
        this.setProperty(REGISTRY, registryPath);
    }
}

