/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.aas.mongodb;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.basyx.aas.aggregator.api.IAASAggregator;
import org.eclipse.basyx.aas.metamodel.api.IAssetAdministrationShell;
import org.eclipse.basyx.aas.metamodel.map.AssetAdministrationShell;
import org.eclipse.basyx.aas.registration.api.IAASRegistryService;
import org.eclipse.basyx.aas.restapi.AASModelProvider;
import org.eclipse.basyx.aas.restapi.VABMultiSubmodelProvider;
import org.eclipse.basyx.aas.restapi.api.IAASAPI;
import org.eclipse.basyx.components.aas.mongodb.MongoDBAASAPI;
import org.eclipse.basyx.components.aas.mongodb.MongoDBSubmodelAPI;
import org.eclipse.basyx.components.configuration.BaSyxMongoDBConfiguration;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IIdentifier;
import org.eclipse.basyx.submodel.metamodel.api.reference.IKey;
import org.eclipse.basyx.submodel.metamodel.api.reference.IReference;
import org.eclipse.basyx.submodel.metamodel.api.reference.enums.KeyType;
import org.eclipse.basyx.submodel.metamodel.map.SubModel;
import org.eclipse.basyx.submodel.restapi.SubModelProvider;
import org.eclipse.basyx.submodel.restapi.api.ISubmodelAPI;
import org.eclipse.basyx.vab.exception.provider.ResourceNotFoundException;
import org.eclipse.basyx.vab.modelprovider.api.IModelProvider;
import org.eclipse.basyx.vab.protocol.http.connector.HTTPConnectorProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

public class MongoDBAASAggregator
implements IAASAggregator {
    private static Logger logger = LoggerFactory.getLogger(MongoDBAASAggregator.class);
    private static final String DEFAULT_CONFIG_PATH = "mongodb.properties";
    private static final String IDSHORTPATH = "idShort";
    private static final String IDPATH = "identification.id";
    protected Map<String, VABMultiSubmodelProvider> aasProviderMap = new HashMap<String, VABMultiSubmodelProvider>();
    protected BaSyxMongoDBConfiguration config;
    protected MongoOperations mongoOps;
    protected String aasCollection;
    protected String smCollection;
    private IAASRegistryService registry;

    public MongoDBAASAggregator(BaSyxMongoDBConfiguration config) {
        this.setConfiguration(config);
        this.init();
    }

    public void setRegistry(IAASRegistryService registry) {
        this.registry = registry;
    }

    public MongoDBAASAggregator(String resourceConfigPath) {
        this.config = new BaSyxMongoDBConfiguration();
        this.config.loadFromResource(resourceConfigPath);
        this.setConfiguration(this.config);
        this.init();
    }

    public MongoDBAASAggregator() {
        this(DEFAULT_CONFIG_PATH);
    }

    public void setConfiguration(BaSyxMongoDBConfiguration config) {
        this.config = config;
        MongoClient client = MongoClients.create((String)config.getConnectionUrl());
        this.mongoOps = new MongoTemplate(client, config.getDatabase());
        this.aasCollection = config.getAASCollection();
        this.smCollection = config.getSubmodelCollection();
    }

    public void reset() {
        this.mongoOps.dropCollection(this.aasCollection);
        this.mongoOps.dropCollection(this.smCollection);
        this.aasProviderMap.clear();
    }

    private void init() {
        List data = this.mongoOps.findAll(AssetAdministrationShell.class, this.aasCollection);
        for (AssetAdministrationShell aas : data) {
            logger.info("Adding AAS from DB: " + aas.getIdentification().getId());
            VABMultiSubmodelProvider provider = this.createMultiSubmodelProvider(aas);
            this.aasProviderMap.put(aas.getIdentification().getId(), provider);
        }
    }

    private VABMultiSubmodelProvider createMultiSubmodelProvider(AssetAdministrationShell aas) {
        MongoDBAASAPI aasApi = new MongoDBAASAPI(this.config, aas.getIdentification().getId());
        AASModelProvider aasProvider = new AASModelProvider((IAASAPI)aasApi);
        VABMultiSubmodelProvider provider = new VABMultiSubmodelProvider(aasProvider, this.registry, new HTTPConnectorProvider());
        Collection submodelRefs = aas.getSubmodelReferences();
        ArrayList<String> smIds = new ArrayList<String>();
        ArrayList<String> smIdShorts = new ArrayList<String>();
        for (IReference ref : submodelRefs) {
            List keys = ref.getKeys();
            IKey lastKey = (IKey)keys.get(keys.size() - 1);
            if (lastKey.getIdType() == KeyType.IDSHORT) {
                smIdShorts.add(lastKey.getValue());
                continue;
            }
            smIds.add(lastKey.getValue());
        }
        for (String idShort : smIdShorts) {
            String id = this.getSubmodelId(idShort);
            if (id == null) continue;
            smIds.add(id);
        }
        for (String id : smIds) {
            logger.info("Adding Submodel from DB: " + id);
            this.addSubmodelProvidersById(id, provider);
        }
        return provider;
    }

    private String getSubmodelId(String idShort) {
        SubModel sm = (SubModel)this.mongoOps.findOne(Query.query((CriteriaDefinition)Criteria.where((String)IDSHORTPATH).is((Object)idShort)), SubModel.class);
        if (sm != null) {
            return sm.getIdentification().getId();
        }
        return null;
    }

    private void addSubmodelProvidersById(String smId, VABMultiSubmodelProvider provider) {
        MongoDBSubmodelAPI smApi = new MongoDBSubmodelAPI(smId);
        SubModelProvider smProvider = new SubModelProvider((ISubmodelAPI)smApi);
        provider.addSubmodel(smProvider);
    }

    public Collection<IAssetAdministrationShell> getAASList() {
        return this.aasProviderMap.values().stream().map(p -> {
            try {
                return p.getModelPropertyValue("/aas");
            }
            catch (Exception e1) {
                e1.printStackTrace();
                throw new RuntimeException();
            }
        }).map(m -> {
            AssetAdministrationShell aas = new AssetAdministrationShell();
            aas.putAll((Map)m);
            return aas;
        }).collect(Collectors.toList());
    }

    public IAssetAdministrationShell getAAS(IIdentifier aasId) {
        IModelProvider aasProvider = this.getAASProvider(aasId);
        Map aasMap = (Map)aasProvider.getModelPropertyValue("/aas");
        return AssetAdministrationShell.createAsFacade((Map)aasMap);
    }

    public void createAAS(AssetAdministrationShell aas) {
        MongoDBAASAPI aasApi = new MongoDBAASAPI(this.config, aas.getIdentification().getId());
        aasApi.setAAS(aas);
        AASModelProvider provider = new AASModelProvider((IAASAPI)aasApi);
        this.aasProviderMap.put(aas.getIdentification().getId(), new VABMultiSubmodelProvider(provider));
    }

    public void updateAAS(AssetAdministrationShell aas) {
        this.createAAS(aas);
    }

    public void deleteAAS(IIdentifier aasId) {
        Query hasId = Query.query((CriteriaDefinition)Criteria.where((String)IDPATH).is((Object)aasId));
        this.mongoOps.remove(hasId, this.aasCollection);
        this.aasProviderMap.remove(aasId.getId());
    }

    public VABMultiSubmodelProvider getProviderForAASId(String aasId) {
        return this.aasProviderMap.get(aasId);
    }

    public IModelProvider getAASProvider(IIdentifier aasId) {
        VABMultiSubmodelProvider provider = this.aasProviderMap.get(aasId.getId());
        if (provider == null) {
            throw new ResourceNotFoundException("AAS with Id " + aasId.getId() + " does not exist");
        }
        return provider;
    }
}

