/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.aas.mongodb;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.basyx.components.configuration.BaSyxMongoDBConfiguration;
import org.eclipse.basyx.submodel.metamodel.api.ISubModel;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.ISubmodelElement;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.operation.IOperation;
import org.eclipse.basyx.submodel.metamodel.facade.submodelelement.SubmodelElementFacadeFactory;
import org.eclipse.basyx.submodel.metamodel.map.SubModel;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.SubmodelElement;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.SubmodelElementCollection;
import org.eclipse.basyx.submodel.restapi.SubmodelElementProvider;
import org.eclipse.basyx.submodel.restapi.api.ISubmodelAPI;
import org.eclipse.basyx.vab.exception.provider.MalformedRequestException;
import org.eclipse.basyx.vab.exception.provider.ResourceNotFoundException;
import org.eclipse.basyx.vab.modelprovider.VABPathTools;
import org.eclipse.basyx.vab.modelprovider.api.IModelProvider;
import org.eclipse.basyx.vab.modelprovider.map.VABMapProvider;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

public class MongoDBSubmodelAPI
implements ISubmodelAPI {
    private static final String DEFAULT_CONFIG_PATH = "mongodb.properties";
    private static final String SMIDPATH = "identification.id";
    protected BaSyxMongoDBConfiguration config;
    protected MongoOperations mongoOps;
    protected String collection;
    protected String smId;

    public MongoDBSubmodelAPI(BaSyxMongoDBConfiguration config, String smId) {
        this.setConfiguration(config);
        this.setSubmodelId(smId);
    }

    public MongoDBSubmodelAPI(String resourceConfigPath, String smId) {
        this.config = new BaSyxMongoDBConfiguration();
        this.config.loadFromResource(resourceConfigPath);
        this.setConfiguration(this.config);
        this.setSubmodelId(smId);
    }

    public MongoDBSubmodelAPI(String smId) {
        this(DEFAULT_CONFIG_PATH, smId);
    }

    public void setConfiguration(BaSyxMongoDBConfiguration config) {
        this.config = config;
        MongoClient client = MongoClients.create((String)config.getConnectionUrl());
        this.mongoOps = new MongoTemplate(client, config.getDatabase());
        this.collection = config.getSubmodelCollection();
    }

    public void setSubmodelId(String smId) {
        this.smId = smId;
    }

    public void setSubModel(SubModel sm) {
        String id = sm.getIdentification().getId();
        this.setSubmodelId(id);
        Query hasId = Query.query((CriteriaDefinition)Criteria.where((String)SMIDPATH).is((Object)this.smId));
        Object replaced = this.mongoOps.findAndReplace(hasId, (Object)sm, this.collection);
        if (replaced == null) {
            this.mongoOps.insert((Object)sm, this.collection);
        }
    }

    public ISubModel getSubmodel() {
        Query hasId = Query.query((CriteriaDefinition)Criteria.where((String)SMIDPATH).is((Object)this.smId));
        SubModel result = (SubModel)this.mongoOps.findOne(hasId, SubModel.class, this.collection);
        if (result == null) {
            throw new ResourceNotFoundException("The submodel " + this.smId + " could not be found in the database.");
        }
        result.remove((Object)"_id");
        HashMap<String, ISubmodelElement> elements = new HashMap<String, ISubmodelElement>();
        Map elemMaps = (Map)result.get((Object)"submodelElements");
        for (Map.Entry entry : elemMaps.entrySet()) {
            String shortId = (String)entry.getKey();
            Map elemMap = (Map)entry.getValue();
            ISubmodelElement element = SubmodelElementFacadeFactory.createSubmodelElement((Map)elemMap);
            elements.put(shortId, element);
        }
        result.put("submodelElements", elements);
        return result;
    }

    public void addSubmodelElement(ISubmodelElement elem) {
        SubModel sm = (SubModel)this.getSubmodel();
        sm.addSubModelElement(elem);
        Query hasId = Query.query((CriteriaDefinition)Criteria.where((String)SMIDPATH).is((Object)this.smId));
        this.mongoOps.findAndReplace(hasId, (Object)sm, this.collection);
    }

    private ISubmodelElement getTopLevelSubmodelElement(String idShort) {
        SubModel sm = (SubModel)this.getSubmodel();
        Map submodelElements = sm.getSubmodelElements();
        ISubmodelElement element = (ISubmodelElement)submodelElements.get(idShort);
        if (element == null) {
            throw new ResourceNotFoundException("The element \"" + idShort + "\" could not be found");
        }
        return this.convertSubmodelElement(element);
    }

    private ISubmodelElement convertSubmodelElement(ISubmodelElement element) {
        Map elementMap = (Map)element;
        SubmodelElementProvider elementProvider = new SubmodelElementProvider((IModelProvider)new VABMapProvider(elementMap));
        Object elementVABObj = elementProvider.getModelPropertyValue("");
        return SubmodelElement.createAsFacade((Map)((Map)elementVABObj));
    }

    private void deleteTopLevelSubmodelElement(String idShort) {
        SubModel sm = (SubModel)this.getSubmodel();
        sm.getSubmodelElements().remove(idShort);
        Query hasId = Query.query((CriteriaDefinition)Criteria.where((String)SMIDPATH).is((Object)this.smId));
        this.mongoOps.findAndReplace(hasId, (Object)sm, this.collection);
    }

    public Collection<IOperation> getOperations() {
        SubModel sm = (SubModel)this.getSubmodel();
        return sm.getOperations().values();
    }

    private void addNestedSubmodelElement(List<String> idShorts, ISubmodelElement elem) {
        SubModel sm = (SubModel)this.getSubmodel();
        if (idShorts.size() > 1) {
            ISubmodelElement parentElement = this.getNestedSubmodelElement(sm, idShorts = idShorts.subList(0, idShorts.size() - 1));
            if (parentElement instanceof SubmodelElementCollection) {
                ((SubmodelElementCollection)parentElement).addSubModelElement(elem);
                Query hasId = Query.query((CriteriaDefinition)Criteria.where((String)SMIDPATH).is((Object)this.smId));
                this.mongoOps.findAndReplace(hasId, (Object)sm, this.collection);
            }
        } else {
            sm.addSubModelElement(elem);
            Query hasId = Query.query((CriteriaDefinition)Criteria.where((String)SMIDPATH).is((Object)this.smId));
            this.mongoOps.findAndReplace(hasId, (Object)sm, this.collection);
        }
    }

    public Collection<ISubmodelElement> getSubmodelElements() {
        SubModel sm = (SubModel)this.getSubmodel();
        return sm.getSubmodelElements().values();
    }

    private void updateTopLevelSubmodelElement(String idShort, Object newValue) {
        SubModel sm = (SubModel)this.getSubmodel();
        newValue = this.unwrapParameter(newValue);
        this.getElementProvider(sm, idShort).setModelPropertyValue("value", newValue);
        Query hasId = Query.query((CriteriaDefinition)Criteria.where((String)SMIDPATH).is((Object)this.smId));
        this.mongoOps.findAndReplace(hasId, (Object)sm, this.collection);
    }

    private void updateNestedSubmodelElement(List<String> idShorts, Object newValue) {
        SubModel sm = (SubModel)this.getSubmodel();
        ISubmodelElement element = this.getNestedSubmodelElement(sm, idShorts);
        VABMapProvider mapProvider = new VABMapProvider((Map)element);
        IModelProvider elemProvider = SubmodelElementProvider.getElementProvider((IModelProvider)mapProvider);
        elemProvider.setModelPropertyValue("value", newValue);
        Query hasId = Query.query((CriteriaDefinition)Criteria.where((String)SMIDPATH).is((Object)this.smId));
        this.mongoOps.findAndReplace(hasId, (Object)sm, this.collection);
    }

    private Object getTopLevelSubmodelElementValue(String idShort) {
        SubModel sm = (SubModel)this.getSubmodel();
        return this.getElementProvider(sm, idShort).getModelPropertyValue("/value");
    }

    private Object getNestedSubmodelElementValue(List<String> idShorts) {
        ISubmodelElement lastElement = this.getNestedSubmodelElement(idShorts);
        VABMapProvider mapProvider = new VABMapProvider((Map)lastElement);
        return SubmodelElementProvider.getElementProvider((IModelProvider)mapProvider).getModelPropertyValue("/value");
    }

    protected Object unwrapParameter(Object parameter) {
        Map map;
        if (parameter instanceof Map && (map = (Map)parameter).get("valueType") != null && map.containsKey("value")) {
            return map.get("value");
        }
        return parameter;
    }

    private IModelProvider getElementProvider(SubModel sm, String idShort) {
        ISubmodelElement elem = (ISubmodelElement)sm.getSubmodelElements().get(idShort);
        VABMapProvider mapProvider = new VABMapProvider((Map)elem);
        return SubmodelElementProvider.getElementProvider((IModelProvider)mapProvider);
    }

    private ISubmodelElement getNestedSubmodelElement(SubModel sm, List<String> idShorts) {
        Map elemMap = sm.getSubmodelElements();
        for (int i = 0; i < idShorts.size() - 1; ++i) {
            String idShort = idShorts.get(i);
            ISubmodelElement elem = (ISubmodelElement)elemMap.get(idShort);
            if (!(elem instanceof SubmodelElementCollection)) {
                throw new ResourceNotFoundException(idShort + " in the nested submodel element path could not be resolved.");
            }
            elemMap = ((SubmodelElementCollection)elem).getSubmodelElements();
        }
        String lastIdShort = idShorts.get(idShorts.size() - 1);
        if (!elemMap.containsKey(lastIdShort)) {
            throw new ResourceNotFoundException(lastIdShort + " in the nested submodel element path could not be resolved.");
        }
        return (ISubmodelElement)elemMap.get(lastIdShort);
    }

    private ISubmodelElement getNestedSubmodelElement(List<String> idShorts) {
        SubModel sm = (SubModel)this.getSubmodel();
        return this.convertSubmodelElement(this.getNestedSubmodelElement(sm, idShorts));
    }

    private Object invokeTopLevelOperation(String idShort, Object ... params) {
        throw new MalformedRequestException("Invoke not supported by this backend");
    }

    private void deleteNestedSubmodelElement(List<String> idShorts) {
        if (idShorts.size() == 1) {
            this.deleteSubmodelElement(idShorts.get(0));
            return;
        }
        SubModel sm = (SubModel)this.getSubmodel();
        List<String> parentIds = idShorts.subList(0, idShorts.size() - 1);
        ISubmodelElement parentElement = this.getNestedSubmodelElement(sm, parentIds);
        SubmodelElementCollection coll = (SubmodelElementCollection)parentElement;
        coll.deleteSubmodelElement(idShorts.get(idShorts.size() - 1));
        Query hasId = Query.query((CriteriaDefinition)Criteria.where((String)SMIDPATH).is((Object)this.smId));
        this.mongoOps.findAndReplace(hasId, (Object)sm, this.collection);
    }

    private Object invokeNestedOperation(List<String> idShorts, Object ... params) {
        throw new MalformedRequestException("Invoke not supported by this backend");
    }

    private Object invokeNestedOperationAsync(List<String> idShorts, Object ... params) {
        throw new MalformedRequestException("Invoke not supported by this backend");
    }

    public Object getOperationResult(String idShort, String requestId) {
        throw new MalformedRequestException("Invoke not supported by this backend");
    }

    public ISubmodelElement getSubmodelElement(String idShortPath) {
        if (idShortPath.contains("/")) {
            String[] splitted = VABPathTools.splitPath((String)idShortPath);
            List<String> idShorts = Arrays.asList(splitted);
            return this.getNestedSubmodelElement(idShorts);
        }
        return this.getTopLevelSubmodelElement(idShortPath);
    }

    public void deleteSubmodelElement(String idShortPath) {
        if (idShortPath.contains("/")) {
            String[] splitted = VABPathTools.splitPath((String)idShortPath);
            List<String> idShorts = Arrays.asList(splitted);
            this.deleteNestedSubmodelElement(idShorts);
        } else {
            this.deleteTopLevelSubmodelElement(idShortPath);
        }
    }

    public void updateSubmodelElement(String idShortPath, Object newValue) {
        if (idShortPath.contains("/")) {
            String[] splitted = VABPathTools.splitPath((String)idShortPath);
            List<String> idShorts = Arrays.asList(splitted);
            this.updateNestedSubmodelElement(idShorts, newValue);
        } else {
            this.updateTopLevelSubmodelElement(idShortPath, newValue);
        }
    }

    public Object getSubmodelElementValue(String idShortPath) {
        if (idShortPath.contains("/")) {
            String[] splitted = VABPathTools.splitPath((String)idShortPath);
            List<String> idShorts = Arrays.asList(splitted);
            return this.getNestedSubmodelElementValue(idShorts);
        }
        return this.getTopLevelSubmodelElementValue(idShortPath);
    }

    public Object invokeOperation(String idShortPath, Object ... params) {
        if (idShortPath.contains("/")) {
            String[] splitted = VABPathTools.splitPath((String)idShortPath);
            List<String> idShorts = Arrays.asList(splitted);
            return this.invokeNestedOperation(idShorts, params);
        }
        return this.invokeTopLevelOperation(idShortPath, params);
    }

    public Object invokeAsync(String idShortPath, Object ... params) {
        String[] splitted = VABPathTools.splitPath((String)idShortPath);
        List<String> idShorts = Arrays.asList(splitted);
        return this.invokeNestedOperationAsync(idShorts, params);
    }

    public void addSubmodelElement(String idShortPath, ISubmodelElement elem) {
        String[] splitted = VABPathTools.splitPath((String)idShortPath);
        List<String> idShorts = Arrays.asList(splitted);
        this.addNestedSubmodelElement(idShorts, elem);
    }
}

