/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.aas.mqtt;

import java.util.Set;
import org.eclipse.basyx.components.configuration.BaSyxMqttConfiguration;
import org.eclipse.basyx.extensions.events.submodel.mqtt.MqttSubmodelAPI;
import org.eclipse.basyx.submodel.restapi.api.ISubmodelAPI;
import org.eclipse.basyx.submodel.restapi.api.ISubmodelAPIFactory;
import org.eclipse.basyx.submodel.restapi.vab.VABSubmodelAPI;
import org.eclipse.basyx.vab.modelprovider.VABPathTools;
import org.eclipse.basyx.vab.modelprovider.api.IModelProvider;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttSubmodelAPIFactory
implements ISubmodelAPIFactory {
    private static Logger logger = LoggerFactory.getLogger(MqttSubmodelAPIFactory.class);
    private BaSyxMqttConfiguration config;

    public MqttSubmodelAPIFactory(BaSyxMqttConfiguration config) {
        this.config = config;
    }

    public ISubmodelAPI getSubmodelAPI(IModelProvider smProvider) {
        MqttSubmodelAPI api;
        String idPath = VABPathTools.concatenatePaths((String[])new String[]{"identification", "id"});
        String smId = (String)smProvider.getModelPropertyValue(idPath);
        VABSubmodelAPI observedApi = new VABSubmodelAPI(smProvider);
        String brokerEndpoint = this.config.getServer();
        String clientId = smId;
        try {
            if (this.config.getUser() != null) {
                String user = this.config.getUser();
                String pass = this.config.getPass();
                api = new MqttSubmodelAPI((ISubmodelAPI)observedApi, brokerEndpoint, clientId, user, pass.toCharArray());
            } else {
                api = new MqttSubmodelAPI((ISubmodelAPI)observedApi, brokerEndpoint, clientId);
            }
            this.setWhitelist(api, smId);
        }
        catch (MqttException e) {
            logger.error("Could not create MqttSubmodelApi", (Throwable)e);
            return observedApi;
        }
        return api;
    }

    private void setWhitelist(MqttSubmodelAPI api, String smId) {
        if (!this.config.isWhitelistEnabled(smId)) {
            api.disableWhitelist();
            return;
        }
        Set whitelist = this.config.getWhitelist(smId);
        logger.info("Set MQTT whitelist for " + smId + " with " + whitelist.size() + " entries");
        api.setWhitelist(whitelist);
        api.enableWhitelist();
    }
}

