/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.regression.models.controlcomponent;

import org.eclipse.basyx.models.controlcomponent.ExecutionMode;
import org.eclipse.basyx.models.controlcomponent.ExecutionState;
import org.eclipse.basyx.models.controlcomponent.OccupationState;
import org.eclipse.basyx.models.controlcomponent.SimpleControlComponent;
import org.junit.Assert;
import org.junit.Test;

public class TestSimpleControlComponent {
    @Test
    public void executionStateAssignmentTests() {
        SimpleControlComponent ctrlComponent = new SimpleControlComponent();
        ctrlComponent.setExecutionState("idle");
        Assert.assertTrue((boolean)ctrlComponent.getExecutionState().equals("idle"));
    }

    @Test
    public void testSimpleProxyControlComponent() {
        SimpleControlComponent ctrlComponent = new SimpleControlComponent();
        Assert.assertTrue((boolean)ctrlComponent.getExecutionState().equals("idle"));
        Assert.assertTrue((boolean)ctrlComponent.getOccupationState().equals((Object)OccupationState.FREE));
        Assert.assertTrue((boolean)ctrlComponent.getExecutionMode().equals((Object)ExecutionMode.AUTO));
        Assert.assertTrue((boolean)ctrlComponent.getErrorState().equals(""));
    }

    @Test
    public void testSimpleProxyControlComponentSequence() {
        SimpleControlComponent ctrlComponent = new SimpleControlComponent(true);
        Assert.assertTrue((boolean)ctrlComponent.getExecutionState().equals("idle"));
        ctrlComponent.setOperationMode("DefaultService");
        Assert.assertTrue((boolean)ctrlComponent.getOperationMode().equals("DefaultService"));
        ctrlComponent.setCommand("START");
        Assert.assertTrue((boolean)ctrlComponent.getExecutionState().equals(ExecutionState.EXECUTE.getValue()));
        ctrlComponent.finishState();
        Assert.assertTrue((boolean)ctrlComponent.getExecutionState().equals(ExecutionState.COMPLETE.getValue()));
        ctrlComponent.setCommand("RESET");
        Assert.assertTrue((boolean)ctrlComponent.getExecutionState().equals(ExecutionState.RESETTING.getValue()));
        ctrlComponent.finishState();
        Assert.assertTrue((boolean)ctrlComponent.getExecutionState().equals(ExecutionState.IDLE.getValue()));
    }

    @Test
    public void testSimpleProxyControlComponentSequenceAbort() {
        SimpleControlComponent ctrlComponent = new SimpleControlComponent(true);
        Assert.assertTrue((boolean)ctrlComponent.getExecutionState().equals("idle"));
        ctrlComponent.setOperationMode("DefaultService");
        Assert.assertTrue((boolean)ctrlComponent.getOperationMode().equals("DefaultService"));
        ctrlComponent.setCommand("START");
        Assert.assertTrue((boolean)ctrlComponent.getExecutionState().equals(ExecutionState.EXECUTE.getValue()));
        ctrlComponent.setCommand("ABORT");
        Assert.assertTrue((boolean)ctrlComponent.getExecutionState().equals(ExecutionState.ABORTED.getValue()));
        ctrlComponent.setCommand("CLEAR");
        Assert.assertTrue((boolean)ctrlComponent.getExecutionState().equals(ExecutionState.STOPPED.getValue()));
        ctrlComponent.setCommand("RESET");
        Assert.assertTrue((boolean)ctrlComponent.getExecutionState().equals(ExecutionState.RESETTING.getValue()));
        ctrlComponent.finishState();
        Assert.assertTrue((boolean)ctrlComponent.getExecutionState().equals(ExecutionState.IDLE.getValue()));
    }
}

