/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.regression.processengineconnector;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.basyx.aas.manager.ConnectedAssetAdministrationShellManager;
import org.eclipse.basyx.aas.manager.api.IAssetAdministrationShellManager;
import org.eclipse.basyx.aas.metamodel.map.AssetAdministrationShell;
import org.eclipse.basyx.aas.metamodel.map.descriptor.AASDescriptor;
import org.eclipse.basyx.aas.metamodel.map.descriptor.SubmodelDescriptor;
import org.eclipse.basyx.aas.registration.api.IAASRegistryService;
import org.eclipse.basyx.aas.registration.memory.InMemoryRegistry;
import org.eclipse.basyx.aas.restapi.AASModelProvider;
import org.eclipse.basyx.aas.restapi.VABMultiSubmodelProvider;
import org.eclipse.basyx.components.processengine.connector.DeviceServiceExecutor;
import org.eclipse.basyx.regression.support.processengine.aas.DeviceAdministrationShellFactory;
import org.eclipse.basyx.regression.support.processengine.stubs.CoilcarStub;
import org.eclipse.basyx.regression.support.processengine.submodel.DeviceSubmodelFactory;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IIdentifier;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IdentifierType;
import org.eclipse.basyx.submodel.metamodel.map.SubModel;
import org.eclipse.basyx.submodel.metamodel.map.identifier.Identifier;
import org.eclipse.basyx.submodel.restapi.SubModelProvider;
import org.eclipse.basyx.testsuite.regression.vab.gateway.ConnectorProviderStub;
import org.eclipse.basyx.vab.modelprovider.api.IModelProvider;
import org.eclipse.basyx.vab.protocol.api.IConnectorProvider;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestAASServicecall {
    private DeviceServiceExecutor serviceExecutor;
    private CoilcarStub coilcar;
    private static final String AAS_ID = "coilcar";
    private static final String SUBMODEL_ID = "submodel1";
    private static final String SERVICE_LIFTTO = "liftTo";
    private static final String SERVICE_MOVETO = "moveTo";

    @Before
    public void setupDeviceServiceExecutor() {
        AssetAdministrationShell aas = new DeviceAdministrationShellFactory().create(AAS_ID, SUBMODEL_ID);
        this.coilcar = new CoilcarStub();
        SubModel sm = new DeviceSubmodelFactory().create(SUBMODEL_ID, this.coilcar);
        VABMultiSubmodelProvider provider = new VABMultiSubmodelProvider();
        provider.addSubmodel(new SubModelProvider(sm));
        provider.setAssetAdministrationShell(new AASModelProvider(aas));
        InMemoryRegistry registry = new InMemoryRegistry();
        Identifier id = new Identifier(IdentifierType.CUSTOM, AAS_ID);
        AASDescriptor aasDescriptor = new AASDescriptor((IIdentifier)id, "/aas");
        Identifier smId = new Identifier(IdentifierType.CUSTOM, SUBMODEL_ID);
        SubmodelDescriptor smDescriptor = new SubmodelDescriptor("submodel1Name", (IIdentifier)smId, "/aas/submodels/submodel1/submodel");
        aasDescriptor.addSubmodelDescriptor(smDescriptor);
        registry.register(aasDescriptor);
        ConnectorProviderStub connectorProvider = new ConnectorProviderStub();
        connectorProvider.addMapping("", (IModelProvider)provider);
        ConnectedAssetAdministrationShellManager manager = new ConnectedAssetAdministrationShellManager((IAASRegistryService)registry, (IConnectorProvider)connectorProvider);
        this.serviceExecutor = new DeviceServiceExecutor((IAssetAdministrationShellManager)manager);
    }

    @Test
    public void testServicecall() {
        this.serviceExecutor.executeService(SERVICE_MOVETO, AAS_ID, SUBMODEL_ID, new ArrayList<Object>(Arrays.asList(123)));
        Assert.assertEquals((Object)123, (Object)this.coilcar.getParameter());
        Assert.assertTrue((boolean)this.coilcar.getServiceCalled().equals(SERVICE_MOVETO));
        this.serviceExecutor.executeService(SERVICE_LIFTTO, AAS_ID, SUBMODEL_ID, new ArrayList<Object>(Arrays.asList(456)));
        Assert.assertEquals((Object)456, (Object)this.coilcar.getParameter());
        Assert.assertTrue((boolean)this.coilcar.getServiceCalled().equals(SERVICE_LIFTTO));
        this.serviceExecutor.executeService(SERVICE_MOVETO, AAS_ID, SUBMODEL_ID, new ArrayList<Object>(Arrays.asList(789)));
        Assert.assertEquals((Object)789, (Object)this.coilcar.getParameter());
        Assert.assertTrue((boolean)this.coilcar.getServiceCalled().equals(SERVICE_MOVETO));
    }
}

