/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.regression.processengineconnector;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cfg.StandaloneProcessEngineConfiguration;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.eclipse.basyx.aas.manager.ConnectedAssetAdministrationShellManager;
import org.eclipse.basyx.aas.manager.api.IAssetAdministrationShellManager;
import org.eclipse.basyx.aas.metamodel.map.descriptor.AASDescriptor;
import org.eclipse.basyx.aas.metamodel.map.descriptor.SubmodelDescriptor;
import org.eclipse.basyx.aas.registration.api.IAASRegistryService;
import org.eclipse.basyx.aas.registration.memory.InMemoryRegistry;
import org.eclipse.basyx.components.processengine.connector.DeviceServiceDelegate;
import org.eclipse.basyx.components.processengine.connector.DeviceServiceExecutor;
import org.eclipse.basyx.components.processengine.connector.IDeviceServiceExecutor;
import org.eclipse.basyx.regression.support.server.context.ComponentsRegressionContext;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IIdentifier;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IdentifierType;
import org.eclipse.basyx.submodel.metamodel.map.identifier.Identifier;
import org.eclipse.basyx.testsuite.regression.vab.protocol.http.AASHTTPServerResource;
import org.eclipse.basyx.vab.protocol.api.IConnectorProvider;
import org.eclipse.basyx.vab.protocol.http.connector.HTTPConnectorProvider;
import org.eclipse.basyx.vab.protocol.http.server.BaSyxContext;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestTransportProcess_ConfigureEngineProgrammatically {
    private static final Logger logger = LoggerFactory.getLogger(TestTransportProcess_ConfigureEngineProgrammatically.class);
    ConnectedAssetAdministrationShellManager manager;
    InMemoryRegistry registry;
    private static final String AAS_ID = "coilcar";
    private static final String SUBMODEL_ID = "submodel1";
    private static String relativeConfigPath = "/WebContent/WEB-INF/config/processengine/SimpleTransportProcess.bpmn20.xml";
    @ClassRule
    public static AASHTTPServerResource res = new AASHTTPServerResource((BaSyxContext)new ComponentsRegressionContext());

    @Before
    public void build() {
        this.registry = new InMemoryRegistry();
        Identifier id = new Identifier(IdentifierType.CUSTOM, AAS_ID);
        AASDescriptor ccDescriptor = new AASDescriptor((IIdentifier)id, "http://localhost:8080/basys.components/Testsuite/Processengine/coilcar/aas");
        Identifier smId = new Identifier(IdentifierType.CUSTOM, SUBMODEL_ID);
        SubmodelDescriptor smDescriptor = new SubmodelDescriptor(SUBMODEL_ID, (IIdentifier)smId, "http://localhost:8080/basys.components/Testsuite/Processengine/coilcar/aas/submodels/submodel1");
        ccDescriptor.addSubmodelDescriptor(smDescriptor);
        this.registry.register(ccDescriptor);
        this.manager = new ConnectedAssetAdministrationShellManager((IAASRegistryService)this.registry, (IConnectorProvider)new HTTPConnectorProvider());
    }

    @Test
    public void deploy() throws FileNotFoundException {
        ProcessEngineConfigurationImpl cfg = new StandaloneProcessEngineConfiguration().setJdbcUrl("jdbc:h2:mem:activiti;DB_CLOSE_DELAY=1000").setJdbcUsername("test").setJdbcPassword("test").setJdbcDriver("org.h2.Driver").setDatabaseSchemaUpdate("true").setJobExecutorActivate(false);
        ProcessEngine processEngine = cfg.buildProcessEngine();
        String pName = processEngine.getName();
        String ver = "fox";
        logger.debug("ProcessEngine [" + pName + "] Version: [" + ver + "]");
        RepositoryService repositoryService = processEngine.getRepositoryService();
        File configFile = new File(System.getProperty("user.dir") + relativeConfigPath);
        repositoryService.createDeployment().addInputStream("SimpleTransportProcess.bpmn20.xml", (InputStream)new FileInputStream(configFile)).deploy();
        HashMap<String, Integer> variables = new HashMap<String, Integer>();
        variables.put("coilposition", 2);
        DeviceServiceDelegate.setDeviceServiceExecutor((IDeviceServiceExecutor)new DeviceServiceExecutor((IAssetAdministrationShellManager)this.manager));
        ProcessInstance processInstance1 = processEngine.getRuntimeService().startProcessInstanceByKey("SimpleTransportProcess", variables);
        processEngine.close();
    }
}

