/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.regression.sqlproxy;

import java.util.Arrays;
import org.eclipse.basyx.tools.sqlproxy.SQLMap;
import org.eclipse.basyx.tools.sqlproxy.SQLRootElement;
import org.junit.Assert;
import org.junit.Test;

public class SQLProxyTestMapArrayTypes {
    protected SQLRootElement sqlRootElement = null;

    @Test
    public void test() throws Exception {
        this.sqlRootElement = new SQLRootElement("postgres", "admin", "//localhost/basyx-map?", "org.postgresql.Driver", "jdbc:postgresql:", "root_el_01");
        this.sqlRootElement.dropTable(1);
        this.sqlRootElement.drop();
        this.sqlRootElement.createRootTableIfNotExists();
        SQLMap sqlMap = this.sqlRootElement.createMap(1);
        sqlMap.clear();
        sqlMap.put("intArray", new int[]{1, 2, 3});
        sqlMap.put("floatArray", new float[]{1.2f, 2.2f, 3.4f});
        sqlMap.put("doubleArray", new double[]{3.2, -2.7});
        sqlMap.put("boolArray", new boolean[]{true, true, false});
        sqlMap.put("StringArray", new String[]{"x", "y", "z"});
        sqlMap.put("CharArray", new char[]{'x', 'y', 'z'});
        Assert.assertTrue((sqlMap.size() == 6 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Arrays.equals((int[])sqlMap.get("intArray"), new int[]{1, 2, 3}));
        Assert.assertTrue((boolean)Arrays.equals((float[])sqlMap.get("floatArray"), new float[]{1.2f, 2.2f, 3.4f}));
        Assert.assertTrue((boolean)Arrays.equals((double[])sqlMap.get("doubleArray"), new double[]{3.2, -2.7}));
        Assert.assertTrue((boolean)Arrays.equals((boolean[])sqlMap.get("boolArray"), new boolean[]{true, true, false}));
        Assert.assertTrue((boolean)Arrays.equals((String[])sqlMap.get("StringArray"), new String[]{"x", "y", "z"}));
        Assert.assertTrue((boolean)Arrays.equals((char[])sqlMap.get("CharArray"), new char[]{'x', 'y', 'z'}));
        Assert.assertTrue((boolean)sqlMap.containsValue(new int[]{1, 2, 3}));
        sqlMap.clear();
        Assert.assertTrue((sqlMap.size() == 0 ? 1 : 0) != 0);
        this.sqlRootElement.dropTable(1);
        this.sqlRootElement.drop();
    }
}

