/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.regression.sqlproxy;

import org.eclipse.basyx.tools.sqlproxy.SQLMap;
import org.eclipse.basyx.tools.sqlproxy.SQLRootElement;
import org.junit.Assert;
import org.junit.Test;

public class SQLProxyTestMapSimpleTypes {
    protected SQLRootElement sqlRootElement = null;

    @Test
    public void test() throws Exception {
        this.sqlRootElement = new SQLRootElement("postgres", "admin", "//localhost/basyx-map?", "org.postgresql.Driver", "jdbc:postgresql:", "root_el_01");
        this.sqlRootElement.dropTable(1);
        this.sqlRootElement.drop();
        this.sqlRootElement.createRootTableIfNotExists();
        SQLMap sqlMap = this.sqlRootElement.createMap(1);
        sqlMap.clear();
        sqlMap.put("intVal1", 14);
        sqlMap.put("intVal2", -14);
        sqlMap.put("floatVal1", Float.valueOf(14.2f));
        sqlMap.put("floatVal2", Float.valueOf(-14.4f));
        sqlMap.put("doubleVal1", 13.2);
        sqlMap.put("doubleVal2", -13.4);
        sqlMap.put("boolVal1", true);
        sqlMap.put("boolVal2", false);
        sqlMap.put("StringVal1", "");
        sqlMap.put("StringVal2", "abc");
        sqlMap.put("CharVal1", Character.valueOf('a'));
        sqlMap.put("CharVal2", Character.valueOf('b'));
        Assert.assertTrue((sqlMap.size() == 12 ? 1 : 0) != 0);
        Assert.assertTrue(((Integer)sqlMap.get("intVal1") == 14 ? 1 : 0) != 0);
        Assert.assertTrue(((Integer)sqlMap.get("intVal2") == -14 ? 1 : 0) != 0);
        Assert.assertTrue((((Float)sqlMap.get("floatVal1")).floatValue() == 14.2f ? 1 : 0) != 0);
        Assert.assertTrue((((Float)sqlMap.get("floatVal2")).floatValue() == -14.4f ? 1 : 0) != 0);
        Assert.assertTrue(((Double)sqlMap.get("doubleVal1") == 13.2 ? 1 : 0) != 0);
        Assert.assertTrue(((Double)sqlMap.get("doubleVal2") == -13.4 ? 1 : 0) != 0);
        Assert.assertTrue(((Boolean)sqlMap.get("boolVal1") == true ? 1 : 0) != 0);
        Assert.assertTrue(((Boolean)sqlMap.get("boolVal2") == false ? 1 : 0) != 0);
        Assert.assertTrue((boolean)sqlMap.get("StringVal1").equals(""));
        Assert.assertTrue((boolean)sqlMap.get("StringVal2").equals("abc"));
        Assert.assertTrue((((Character)sqlMap.get("CharVal1")).charValue() == 'a' ? 1 : 0) != 0);
        Assert.assertTrue((((Character)sqlMap.get("CharVal2")).charValue() == 'b' ? 1 : 0) != 0);
        sqlMap.clear();
        Assert.assertTrue((sqlMap.size() == 0 ? 1 : 0) != 0);
        this.sqlRootElement.dropTable(1);
        this.sqlRootElement.drop();
    }
}

