/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.regression.support.processengine.stubs;

import java.util.ArrayList;
import java.util.Arrays;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.ExclusiveGatewayBuilder;
import org.camunda.bpm.model.bpmn.builder.ProcessBuilder;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.camunda.bpm.model.bpmn.builder.StartEventBuilder;
import org.camunda.bpm.model.bpmn.instance.ExtensionElements;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;
import org.eclipse.basyx.vab.coder.json.serialization.DefaultTypeFactory;
import org.eclipse.basyx.vab.coder.json.serialization.GSONTools;
import org.eclipse.basyx.vab.coder.json.serialization.GSONToolsFactory;

public class BPMNModelFactory {
    private static final String TASKI_MPL = "org.eclipse.basyx.components.processengine.connector.DeviceServiceDelegate";
    private static final String SUBMODEL_ID = "submodelId";
    private static final String SERVICE_NAME = "serviceName";
    private static final String SERVICE_PROVIDER = "serviceProvider";
    private static final String SERVICE_PARAMETERS = "serviceParameter";

    public BpmnModelInstance create(String processId) {
        BpmnModelInstance modelInstance = ((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)((ExclusiveGatewayBuilder)((ExclusiveGatewayBuilder)((StartEventBuilder)((ProcessBuilder)Bpmn.createExecutableProcess((String)"my-process").name(processId)).startEvent("start01").name("pickup the coil")).exclusiveGateway("gateway01").name("check the current position of the coil")).condition("Pickup position 1", "${coilposition==1}")).serviceTask("t1").name("pickup the coil")).camundaClass(TASKI_MPL)).serviceTask("t3").name("drive the coil to the milling machine")).camundaClass(TASKI_MPL)).serviceTask("t4").name("lift the coil to the expected position")).camundaClass(TASKI_MPL)).serviceTask("t5").name("put the coil on the mandrel")).camundaClass(TASKI_MPL)).serviceTask("t6").name("set the lifter to the start position")).camundaClass(TASKI_MPL)).serviceTask("t7").name("drive the coilcar back to the start position")).camundaClass(TASKI_MPL)).endEvent("end01").moveToLastGateway().condition("Pickup position 2", " ${coilposition==2}").serviceTask("t2").name("move to the coil")).camundaClass(TASKI_MPL)).connectTo("t1").done();
        this.createFieldExtension(modelInstance, "liftTo", "coilcar", new Object[]{1}, SUBMODEL_ID, "t1");
        this.createFieldExtension(modelInstance, "moveTo", "coilcar", new Object[]{1}, SUBMODEL_ID, "t2");
        this.createFieldExtension(modelInstance, "moveTo", "coilcar", new Object[]{5}, SUBMODEL_ID, "t3");
        this.createFieldExtension(modelInstance, "liftTo", "coilcar", new Object[]{6}, SUBMODEL_ID, "t4");
        this.createFieldExtension(modelInstance, "moveTo", "coilcar", new Object[]{6}, SUBMODEL_ID, "t5");
        this.createFieldExtension(modelInstance, "liftTo", "coilcar", new Object[]{0}, SUBMODEL_ID, "t6");
        this.createFieldExtension(modelInstance, "moveTo", "coilcar", new Object[]{0}, SUBMODEL_ID, "t7");
        return modelInstance;
    }

    private void createFieldExtension(BpmnModelInstance modelInstance, String serviceNameValue, String serviceProviderValue, Object[] params, String smIDValue, String taskid) {
        ExtensionElements extensionElements = (ExtensionElements)modelInstance.newInstance(ExtensionElements.class);
        ModelElementInstance serviceName = extensionElements.addExtensionElement("http://camunda.org/schema/1.0/bpmn", "field");
        serviceName.setAttributeValueNs("http://camunda.org/schema/1.0/bpmn", "stringValue", serviceNameValue);
        serviceName.setAttributeValueNs("http://camunda.org/schema/1.0/bpmn", "name", SERVICE_NAME);
        ModelElementInstance serviceProvider = extensionElements.addExtensionElement("http://camunda.org/schema/1.0/bpmn", "field");
        serviceProvider.setAttributeValueNs("http://camunda.org/schema/1.0/bpmn", "stringValue", serviceProviderValue);
        serviceProvider.setAttributeValueNs("http://camunda.org/schema/1.0/bpmn", "name", SERVICE_PROVIDER);
        ModelElementInstance serviceParameter = extensionElements.addExtensionElement("http://camunda.org/schema/1.0/bpmn", "field");
        serviceParameter.setAttributeValueNs("http://camunda.org/schema/1.0/bpmn", "stringValue", this.generateJsonString(params));
        serviceParameter.setAttributeValueNs("http://camunda.org/schema/1.0/bpmn", "name", SERVICE_PARAMETERS);
        ModelElementInstance submodelID = extensionElements.addExtensionElement("http://camunda.org/schema/1.0/bpmn", "field");
        submodelID.setAttributeValueNs("http://camunda.org/schema/1.0/bpmn", "stringValue", smIDValue);
        submodelID.setAttributeValueNs("http://camunda.org/schema/1.0/bpmn", "name", SUBMODEL_ID);
        modelInstance.getModelElementById(taskid).addChildElement((ModelElementInstance)extensionElements);
    }

    private String generateJsonString(Object[] params) {
        GSONTools gson = new GSONTools((GSONToolsFactory)new DefaultTypeFactory());
        String to = gson.serialize(new ArrayList<Object>(Arrays.asList(params)));
        return to;
    }
}

