/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.regression.support.processengine.stubs;

import org.eclipse.basyx.regression.support.processengine.stubs.ICoilcar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Coilcar
implements ICoilcar {
    private static final Logger logger = LoggerFactory.getLogger(Coilcar.class);
    private int currentPosition = 0;
    private int currentLifterPosition = 0;

    @Override
    public int moveTo(int position) {
        Double[] steps;
        logger.debug("#submodel# invoke service +MoveTo+ with parameter: %d \n\n", (Object)position);
        for (Double step : steps = this.generateCurve(this.currentPosition, position)) {
            logger.debug(step == null ? "null" : step.toString());
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.currentPosition = position;
        return this.currentPosition;
    }

    @Override
    public int liftTo(int position) {
        Double[] steps;
        logger.debug("#submodel# Call service LiftTo with Parameter: %d \n\n", (Object)position);
        for (Double step : steps = this.generateCurve(this.currentLifterPosition, position)) {
            logger.debug(step == null ? "null" : step.toString());
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.currentLifterPosition = position;
        return this.currentLifterPosition;
    }

    public int getCurrentPosition() {
        return this.currentPosition;
    }

    public int getCurrentLifterPosition() {
        return this.currentLifterPosition;
    }

    private Double[] generateCurve(double current, double goal) {
        Double[] stepList = new Double[20];
        double delta = (goal - current) / 20.0;
        for (int i = 0; i < 20; ++i) {
            stepList[i] = current + delta * (double)(i + 1);
        }
        return stepList;
    }
}

