/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.regression.xml;

import java.io.IOException;
import java.util.Optional;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.basyx.components.configuration.BaSyxConfiguration;
import org.eclipse.basyx.components.xml.XMLAASBundleFactory;
import org.eclipse.basyx.support.bundle.AASBundle;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.SAXException;

public class TestXMLAASBundleFactory {
    private static final String xmlPath = "aas/factory/xml/in.xml";

    @Test
    public void testBundleCreation() throws IOException, ParserConfigurationException, SAXException {
        XMLAASBundleFactory factory = new XMLAASBundleFactory(BaSyxConfiguration.getResourceString((String)xmlPath));
        Set bundle = factory.create();
        Optional<AASBundle> fullAASBundleOptional = bundle.stream().filter(b -> b.getAAS().getIdentification().getId().equals("www.admin-shell.io/aas-sample/1/0")).findFirst();
        Optional<AASBundle> minimalBundleOptional = bundle.stream().filter(b -> b.getAAS().getIdentification().getId().equals("www.admin-shell.io/aas-sample/1/1")).findFirst();
        Assert.assertTrue((boolean)fullAASBundleOptional.isPresent());
        Assert.assertTrue((boolean)minimalBundleOptional.isPresent());
        AASBundle fullAASBundle = fullAASBundleOptional.get();
        AASBundle minimalAASBundle = minimalBundleOptional.get();
        Set fullAASSM = fullAASBundle.getSubmodels();
        Assert.assertTrue((boolean)fullAASSM.stream().anyMatch(s -> s.getIdentification().getId().equals("http://www.zvei.de/demo/submodel/12345679")));
        Set minimalAASSM = minimalAASBundle.getSubmodels();
        Assert.assertTrue((boolean)minimalAASSM.isEmpty());
    }
}

