/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.configuration;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaSyxConfiguration {
    private static Logger logger = LoggerFactory.getLogger(BaSyxConfiguration.class);
    private Map<String, String> values;

    public BaSyxConfiguration(Map<String, String> defaultValues) {
        this.values = defaultValues;
    }

    public static InputStream getResourceStream(String relativeResourcePath) {
        ClassLoader classLoader = BaSyxConfiguration.class.getClassLoader();
        return classLoader.getResourceAsStream(relativeResourcePath);
    }

    public static String getResourceString(String relativeResourcePath) throws IOException {
        ClassLoader classLoader = BaSyxConfiguration.class.getClassLoader();
        return IOUtils.resourceToString((String)relativeResourcePath, (Charset)StandardCharsets.UTF_8, (ClassLoader)classLoader);
    }

    public void loadFromFile(String filePath) {
        try (FileInputStream fileStream = new FileInputStream(filePath);){
            logger.info("Loading properties from file '" + filePath + "'");
            this.loadFromStream(fileStream);
        }
        catch (FileNotFoundException e) {
            logger.error("Configuration file not found: '" + filePath + "'", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("Configuration io error: '" + filePath + "'", (Throwable)e);
        }
    }

    public void loadFileOrDefaultResource(String fileKey, String defaultResource) {
        String configFilePath = System.getProperty(fileKey);
        if (configFilePath == null || configFilePath.isEmpty()) {
            configFilePath = System.getenv(fileKey);
        }
        if (configFilePath != null && !configFilePath.isEmpty()) {
            this.loadFromFile(configFilePath);
        } else {
            this.loadFromResource(defaultResource);
        }
    }

    public void loadFromStream(InputStream input) {
        logger.info("Loading from inputStream: " + input);
        Properties properties = new Properties();
        try {
            properties.load(input);
            this.loadFromProperties(properties);
        }
        catch (IOException e) {
            logger.error("Could not load properties", (Throwable)e);
        }
    }

    public void loadFromResource(String relativeResourcePath) {
        logger.info("Loading properties from resource '" + relativeResourcePath + "'");
        try (InputStream resourceStream = BaSyxConfiguration.getResourceStream(relativeResourcePath);){
            if (resourceStream == null) {
                logger.info("Could not get resource stream!");
            }
            this.loadFromStream(resourceStream);
        }
        catch (FileNotFoundException e) {
            logger.error("Configuration resource not found: '" + relativeResourcePath + "'", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("Configuration io error: '" + relativeResourcePath + "'", (Throwable)e);
        }
    }

    public void loadFromProperties(Properties properties) {
        for (Object property : properties.keySet()) {
            String propertyName = (String)property;
            String loaded = properties.getProperty(propertyName);
            if (this.values.containsKey(propertyName)) {
                logger.info(propertyName + ": '" + loaded + "'");
            } else {
                logger.debug(propertyName + ": '" + loaded + "'");
            }
            this.values.put(propertyName, loaded);
        }
    }

    public void setProperty(String name, String value) {
        this.values.put(name, value);
    }

    public List<String> getProperties(String prefix) {
        return this.values.keySet().stream().filter(key -> key.startsWith(prefix)).collect(Collectors.toList());
    }

    public String getProperty(String name) {
        return this.values.get(name);
    }
}

