/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.configuration;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.basyx.components.configuration.BaSyxConfiguration;
import org.eclipse.basyx.vab.protocol.http.server.BaSyxContext;

public class BaSyxContextConfiguration
extends BaSyxConfiguration {
    public static final String DEFAULT_CONTEXTPATH = "/basys.sdk";
    public static final String DEFAULT_DOCBASE = System.getProperty("java.io.tmpdir");
    public static final String DEFAULT_HOSTNAME = "localhost";
    public static final int DEFAULT_PORT = 4000;
    public static final String CONTEXTPATH = "contextPath";
    public static final String DOCBASE = "contextDocPath";
    public static final String HOSTNAME = "contextHostname";
    public static final String PORT = "contextPort";
    public static final String DEFAULT_CONFIG_PATH = "context.properties";
    public static final String DEFAULT_FILE_KEY = "BASYX_CONTEXT";

    public static Map<String, String> getDefaultProperties() {
        HashMap<String, String> defaultProps = new HashMap<String, String>();
        defaultProps.put(CONTEXTPATH, DEFAULT_CONTEXTPATH);
        defaultProps.put(DOCBASE, DEFAULT_DOCBASE);
        defaultProps.put(HOSTNAME, DEFAULT_HOSTNAME);
        defaultProps.put(PORT, Integer.toString(4000));
        return defaultProps;
    }

    public BaSyxContextConfiguration() {
        super(BaSyxContextConfiguration.getDefaultProperties());
    }

    public BaSyxContextConfiguration(Map<String, String> values) {
        super(values);
    }

    public BaSyxContextConfiguration(int port, String contextPath) {
        this();
        this.setPort(port);
        this.setContextPath(contextPath);
    }

    public BaSyxContextConfiguration(String contextPath, String docBasePath, String hostname, int port) {
        this();
        this.setContextPath(contextPath);
        this.setDocBasePath(docBasePath);
        this.setHostname(hostname);
        this.setPort(port);
    }

    public void loadFromDefaultSource() {
        this.loadFileOrDefaultResource(DEFAULT_FILE_KEY, DEFAULT_CONFIG_PATH);
    }

    public BaSyxContext createBaSyxContext() {
        String reqContextPath = this.getContextPath();
        String reqDocBasePath = this.getDocBasePath();
        String hostName = this.getHostname();
        int reqPort = this.getPort();
        return new BaSyxContext(reqContextPath, reqDocBasePath, hostName, reqPort);
    }

    public String getContextPath() {
        return this.getProperty(CONTEXTPATH);
    }

    public void setContextPath(String contextPath) {
        this.setProperty(CONTEXTPATH, contextPath);
    }

    public String getDocBasePath() {
        return this.getProperty(DOCBASE);
    }

    public void setDocBasePath(String docBasePath) {
        this.setProperty(DOCBASE, docBasePath);
    }

    public String getHostname() {
        return this.getProperty(HOSTNAME);
    }

    public void setHostname(String hostname) {
        this.setProperty(HOSTNAME, hostname);
    }

    public int getPort() {
        return Integer.parseInt(this.getProperty(PORT));
    }

    public void setPort(int port) {
        this.setProperty(PORT, Integer.toString(port));
    }

    public String getUrl() {
        return "http://" + this.getHostname() + ":" + this.getPort() + "/" + this.getContextPath();
    }
}

