/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.configuration;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.basyx.components.configuration.BaSyxConfiguration;

public class BaSyxMongoDBConfiguration
extends BaSyxConfiguration {
    public static final String DEFAULT_USER = "admin";
    public static final String DEFAULT_CONNECTIONURL = "mongodb://127.0.0.1:27017/";
    public static final String DEFAULT_DATABASE = "admin";
    public static final String DEFAULT_REGISTRY_COLLECTION = "basyxregistry";
    public static final String DEFAULT_AAS_COLLECTION = "basyxaas";
    public static final String DEFAULT_SUBMODEL_COLLECTION = "basyxsubmodel";
    public static final String USER = "dbuser";
    public static final String DATABASE = "dbname";
    public static final String CONNECTIONURL = "dbconnectionstring";
    public static final String REGISTRY_COLLECTION = "dbcollectionRegistry";
    public static final String AAS_COLLECTION = "dbcollectionAAS";
    public static final String SUBMODEL_COLLECTION = "dbcollectionSubmodels";
    public static final String DEFAULT_CONFIG_PATH = "mongodb.properties";
    public static final String DEFAULT_FILE_KEY = "BASYX_MONGODB";

    public static Map<String, String> getDefaultProperties() {
        HashMap<String, String> defaultProps = new HashMap<String, String>();
        defaultProps.put(USER, "admin");
        defaultProps.put(CONNECTIONURL, DEFAULT_CONNECTIONURL);
        defaultProps.put(DATABASE, "admin");
        defaultProps.put(REGISTRY_COLLECTION, DEFAULT_REGISTRY_COLLECTION);
        defaultProps.put(AAS_COLLECTION, DEFAULT_AAS_COLLECTION);
        defaultProps.put(SUBMODEL_COLLECTION, DEFAULT_SUBMODEL_COLLECTION);
        return defaultProps;
    }

    public BaSyxMongoDBConfiguration(Map<String, String> values) {
        super(values);
    }

    public BaSyxMongoDBConfiguration() {
        super(BaSyxMongoDBConfiguration.getDefaultProperties());
    }

    public BaSyxMongoDBConfiguration(String user, String connectionUrl, String database, String registryCollection, String aasCollection, String submodelCollection) {
        this();
        this.setUser(user);
        this.setConnectionUrl(connectionUrl);
        this.setDatabase(database);
        this.setRegistryCollection(registryCollection);
        this.setAASCollection(aasCollection);
        this.setSubmodelCollection(submodelCollection);
    }

    public BaSyxMongoDBConfiguration(String user, String connectionUrl, String database, String aasCollection, String submodelCollection) {
        this();
        this.setUser(user);
        this.setConnectionUrl(connectionUrl);
        this.setDatabase(database);
        this.setAASCollection(aasCollection);
        this.setSubmodelCollection(submodelCollection);
    }

    public BaSyxMongoDBConfiguration(String user, String connectionUrl, String database, String registryCollection) {
        this();
        this.setUser(user);
        this.setConnectionUrl(connectionUrl);
        this.setDatabase(database);
        this.setRegistryCollection(registryCollection);
    }

    public void loadFromDefaultSource() {
        this.loadFileOrDefaultResource(DEFAULT_FILE_KEY, DEFAULT_CONFIG_PATH);
    }

    public String getUser() {
        return this.getProperty(USER);
    }

    public void setUser(String user) {
        this.setProperty(USER, user);
    }

    public String getDatabase() {
        return this.getProperty(DATABASE);
    }

    public void setDatabase(String database) {
        this.setProperty(DATABASE, database);
    }

    public String getConnectionUrl() {
        return this.getProperty(CONNECTIONURL);
    }

    public void setConnectionUrl(String connectionUrl) {
        this.setProperty(CONNECTIONURL, connectionUrl);
    }

    public String getRegistryCollection() {
        return this.getProperty(REGISTRY_COLLECTION);
    }

    public void setRegistryCollection(String registryCollection) {
        this.setProperty(REGISTRY_COLLECTION, registryCollection);
    }

    public String getAASCollection() {
        return this.getProperty(AAS_COLLECTION);
    }

    public void setAASCollection(String aasCollection) {
        this.setProperty(AAS_COLLECTION, aasCollection);
    }

    public String getSubmodelCollection() {
        return this.getProperty(SUBMODEL_COLLECTION);
    }

    public void setSubmodelCollection(String submodelCollection) {
        this.setProperty(SUBMODEL_COLLECTION, submodelCollection);
    }
}

