/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.configuration.builder;

import org.eclipse.basyx.aas.manager.ConnectedAssetAdministrationShellManager;
import org.eclipse.basyx.aas.registration.api.IAASRegistryService;
import org.eclipse.basyx.aas.registration.proxy.AASRegistryProxy;
import org.eclipse.basyx.components.configuration.CFGBaSyxProtocolType;
import org.eclipse.basyx.components.configuration.ConfigurableComponent;
import org.eclipse.basyx.components.configuration.builder.BaSyxConfigurationBuilder;
import org.eclipse.basyx.vab.directory.api.IVABDirectoryService;
import org.eclipse.basyx.vab.manager.VABConnectionManager;
import org.eclipse.basyx.vab.protocol.api.IConnectorProvider;
import org.eclipse.basyx.vab.protocol.http.connector.HTTPConnectorProvider;

public class BaSyxServiceConfigurationBuilder<T extends BaSyxServiceConfigurationBuilder<T>>
extends BaSyxConfigurationBuilder<Void> {
    protected String registryURL = null;
    protected CFGBaSyxProtocolType protocoltype = null;
    protected IVABDirectoryService vabDirectory = null;

    public BaSyxServiceConfigurationBuilder(ConfigurableComponent<?> component) {
        this.setConfiguredComponent(component);
    }

    public T registryURL(String url) {
        this.registryURL = url;
        return (T)this;
    }

    public IAASRegistryService getRegistry() {
        return new AASRegistryProxy(this.registryURL);
    }

    public T connectionManagerType(CFGBaSyxProtocolType protocol) {
        this.protocoltype = protocol;
        return (T)this;
    }

    public T directoryService(IVABDirectoryService vabDirectory) {
        this.vabDirectory = vabDirectory;
        return (T)this;
    }

    public VABConnectionManager getConnectionManager() {
        return new VABConnectionManager(this.vabDirectory, (IConnectorProvider)new HTTPConnectorProvider());
    }

    public ConnectedAssetAdministrationShellManager getConnetedAASManager() {
        return new ConnectedAssetAdministrationShellManager(this.getRegistry(), (IConnectorProvider)new HTTPConnectorProvider());
    }
}

