/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.device;

import org.eclipse.basyx.components.device.IBaSysNativeDeviceStatus;
import org.eclipse.basyx.components.service.BaseBaSyxService;
import org.eclipse.basyx.models.controlcomponent.ExecutionState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseDevice
extends BaseBaSyxService
implements IBaSysNativeDeviceStatus {
    private static final Logger logger = LoggerFactory.getLogger(BaseDevice.class);

    @Override
    public void deviceInitialized() {
        this.onInitialize();
        this.statusChange(ExecutionState.IDLE.getValue());
    }

    @Override
    public void serviceRunning() {
        this.onServiceInvocation();
        this.statusChange(ExecutionState.EXECUTE.getValue());
    }

    @Override
    public void serviceCompleted() {
        this.onServiceEnd();
        this.statusChange(ExecutionState.COMPLETE.getValue());
    }

    @Override
    public void resetCompleted() {
        this.onReset();
        this.statusChange(ExecutionState.IDLE.getValue());
    }

    protected abstract void statusChange(String var1);

    protected void onInitialize() {
        logger.debug("Device " + this.name + " status change: initialize");
    }

    protected void onServiceInvocation() {
        logger.debug("Device " + this.name + " status change: invoke");
    }

    protected void onServiceEnd() {
        logger.debug("Device " + this.name + " status change: end");
    }

    protected void onReset() {
        logger.debug("Device " + this.name + " status change: reset");
    }
}

