/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.device;

import org.eclipse.basyx.components.device.BaseDevice;
import org.eclipse.basyx.components.device.IBaSysNativeDeviceStatus;
import org.eclipse.basyx.models.controlcomponent.ControlComponent;
import org.eclipse.basyx.models.controlcomponent.ControlComponentChangeListener;
import org.eclipse.basyx.models.controlcomponent.ExecutionMode;
import org.eclipse.basyx.models.controlcomponent.ExecutionState;
import org.eclipse.basyx.models.controlcomponent.OccupationState;
import org.eclipse.basyx.models.controlcomponent.SimpleControlComponent;

public abstract class BaseSmartDevice
extends BaseDevice
implements ControlComponentChangeListener,
IBaSysNativeDeviceStatus {
    protected ControlComponent controlComponent = null;

    public BaseSmartDevice() {
        this.controlComponent = new SimpleControlComponent(true);
        this.controlComponent.addControlComponentChangeListener(this);
    }

    public BaseSmartDevice(ControlComponent component) {
        this.controlComponent = component;
        component.addControlComponentChangeListener(this);
    }

    @Override
    public void start() {
    }

    public ControlComponent getControlComponent() {
        return this.controlComponent;
    }

    @Override
    public void statusChange(String newStatus) {
        this.controlComponent.setExecutionState(newStatus);
    }

    @Override
    public void onVariableChange(String varName, Object newValue) {
    }

    @Override
    public void onNewOccupier(String occupierId) {
    }

    @Override
    public void onNewOccupationState(OccupationState state) {
    }

    @Override
    public void onChangedExecutionMode(ExecutionMode newExecutionMode) {
    }

    @Override
    public void onChangedExecutionState(ExecutionState newExecutionState) {
        if (newExecutionState == ExecutionState.EXECUTE) {
            this.onServiceInvocation();
        }
    }

    @Override
    public void onChangedOperationMode(String newOperationMode) {
    }

    @Override
    public void onChangedWorkState(String newWorkState) {
    }

    @Override
    public void onChangedErrorState(String newWorkState) {
    }
}

