/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.device;

import org.eclipse.basyx.components.device.BaseTCPDeviceAdapter;
import org.eclipse.basyx.components.device.IBaSysNativeDeviceStatus;
import org.eclipse.basyx.components.netcomm.NetworkReceiver;
import org.eclipse.basyx.components.netcomm.TCPClient;
import org.eclipse.basyx.models.controlcomponent.ExecutionState;

public abstract class BaseTCPControllableDeviceAdapter
extends BaseTCPDeviceAdapter
implements IBaSysNativeDeviceStatus,
NetworkReceiver {
    protected Thread rxThread = null;
    protected String opMode = "";
    protected ExecutionState exState = null;

    public BaseTCPControllableDeviceAdapter(int port) {
        super(port);
    }

    @Override
    public void start() {
        super.start();
        this.communicationClient.addTCPMessageListener(this);
        this.rxThread = new Thread(this.communicationClient);
        this.rxThread.start();
    }

    @Override
    public void stop() {
        super.stop();
        this.communicationClient.close();
    }

    @Override
    public void waitFor() {
        super.waitFor();
        try {
            this.rxThread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void statusChange(String newStatus) {
        if (newStatus.equals(ExecutionState.EXECUTE.getValue())) {
            this.onServiceInvocation();
        }
        this.exState = ExecutionState.byValue(newStatus);
    }

    protected void onOperationModeChange(String newOperationMode) {
        this.opMode = newOperationMode;
    }

    @Override
    public void onReceive(byte[] message) {
        String rxMessage = TCPClient.toString(message);
        if (rxMessage.startsWith("state:")) {
            this.statusChange(rxMessage.substring("state:".length()));
            return;
        }
        if (rxMessage.startsWith("opMode:")) {
            this.onOperationModeChange(rxMessage.substring("opMode:".length()));
            return;
        }
        throw new RuntimeException("Unexpected message received:" + rxMessage);
    }

    public String getOpMode() {
        return this.opMode;
    }

    public ExecutionState getExState() {
        return this.exState;
    }
}

