/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.devicemanager;

import org.eclipse.basyx.components.devicemanager.DeviceManagerComponent;
import org.eclipse.basyx.components.netcomm.NetworkReceiver;
import org.eclipse.basyx.components.netcomm.TCPServer;

public abstract class TCPDeviceManagerComponent
extends DeviceManagerComponent
implements NetworkReceiver {
    protected int tcpPortNumber = -1;
    protected TCPServer tcpServer = null;
    protected Thread tcpServerThread = null;

    public TCPDeviceManagerComponent(int portNumber) {
        this.tcpPortNumber = portNumber;
    }

    @Override
    public void start() {
        super.start();
        this.tcpServer = new TCPServer(this.tcpPortNumber);
        this.tcpServer.addTCPMessageListener(this);
        this.tcpServerThread = new Thread(this.tcpServer);
        this.tcpServerThread.start();
    }

    @Override
    public void stop() {
        super.stop();
        this.tcpServer.closeServer();
        this.tcpServer.close();
    }

    @Override
    public void waitFor() {
        super.waitFor();
        try {
            this.tcpServerThread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

